/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.federation.model.idp;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.picketlink.federation.model.idp.TrustDomainResourceDefinition;
import org.wildfly.extension.picketlink.federation.service.IdentityProviderService;
import org.wildfly.extension.picketlink.federation.service.TrustDomainService;

public class TrustDomainAddHandler
extends AbstractAddStepHandler {
    static final TrustDomainAddHandler INSTANCE = new TrustDomainAddHandler();

    static void launchServices(OperationContext context, PathAddress pathAddress, ModelNode model) throws OperationFailedException {
        String identityProviderName = pathAddress.subAddress(0, pathAddress.size() - 1).getLastElement().getValue();
        String domainName = pathAddress.getLastElement().getValue();
        TrustDomainAddHandler.launchServices(context, identityProviderName, domainName);
    }

    private static void launchServices(OperationContext context, String identityProviderName, String domainName) {
        TrustDomainService service = new TrustDomainService(domainName);
        ServiceName serviceName = TrustDomainService.createServiceName(identityProviderName, domainName);
        context.getServiceTarget().addService(serviceName, (Service)service).addDependency(IdentityProviderService.createServiceName(identityProviderName), IdentityProviderService.class, service.getIdentityProviderService()).setInitialMode(ServiceController.Mode.PASSIVE).install();
    }

    static void restartServices(OperationContext context, String identityProviderName, String domainName) {
        ServiceName serviceName = TrustDomainService.createServiceName(identityProviderName, domainName);
        context.removeService(serviceName);
        TrustDomainAddHandler.launchServices(context, identityProviderName, domainName);
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        ModelNode model = resource.getModel();
        for (SimpleAttributeDefinition attribute : TrustDomainResourceDefinition.INSTANCE.getAttributes()) {
            attribute.validateAndSet(operation, model);
        }
        TrustDomainResourceDefinition.validateModelInOperation(context, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        TrustDomainAddHandler.launchServices(context, PathAddress.pathAddress((ModelNode)operation.get("address")), model);
    }
}

