/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.lang.reflect.Array;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.ScalarMarshaller;

public class PackedArrayMarshaller<T>
implements ScalarMarshaller<Object> {
    private final Class<T> componentType;
    private final ScalarMarshaller<T> element;
    private final Class<? extends Object> arrayClass;

    public PackedArrayMarshaller(Class<T> componentType, ScalarMarshaller<T> element) {
        this.componentType = componentType;
        this.element = element;
        this.arrayClass = Array.newInstance(this.componentType, 0).getClass();
    }

    @Override
    public Object readFrom(ProtoStreamReader reader) throws IOException {
        int length = reader.readUInt32();
        Object array = Array.newInstance(this.componentType, length);
        for (int i = 0; i < length; ++i) {
            Object element = this.element.readFrom(reader);
            Array.set(array, i, element);
        }
        return array;
    }

    @Override
    public void writeTo(ProtoStreamWriter writer, Object array) throws IOException {
        int length = Array.getLength(array);
        writer.writeUInt32NoTag(length);
        for (int i = 0; i < length; ++i) {
            Object element = Array.get(array, i);
            this.element.writeTo(writer, element);
        }
    }

    @Override
    public Class<? extends Object> getJavaClass() {
        return this.arrayClass;
    }

    @Override
    public int getWireType() {
        return 2;
    }
}

