/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.function.UnaryOperator;
import org.jboss.as.clustering.controller.Capability;
import org.jboss.as.clustering.controller.ResourceCapabilityReference;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceConfiguratorFactory;
import org.jboss.as.clustering.controller.UnaryCapabilityNameResolver;
import org.jboss.as.clustering.jgroups.auth.BinaryAuthToken;
import org.jboss.as.clustering.jgroups.auth.CipherAuthToken;
import org.jboss.as.clustering.jgroups.subsystem.AuthProtocolConfigurationServiceConfigurator;
import org.jboss.as.clustering.jgroups.subsystem.AuthTokenResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.CipherAuthTokenResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.DigestAuthTokenResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.PlainAuthTokenResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceDefinition;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jgroups.conf.ClassConfigurator;
import org.wildfly.clustering.service.UnaryRequirement;

public class AuthProtocolResourceDefinition
extends ProtocolResourceDefinition {
    static void addTransformations(ModelVersion version, ResourceTransformationDescriptionBuilder builder) {
        ProtocolResourceDefinition.addTransformations(version, builder);
        PlainAuthTokenResourceDefinition.buildTransformation(version, builder);
        DigestAuthTokenResourceDefinition.buildTransformation(version, builder);
        CipherAuthTokenResourceDefinition.buildTransformation(version, builder);
    }

    AuthProtocolResourceDefinition(String name, UnaryOperator<ResourceDescriptor> configurator, ResourceServiceConfiguratorFactory parentServiceConfiguratorFactory) {
        super(AuthProtocolResourceDefinition.pathElement(name), (UnaryOperator<ResourceDescriptor>)new ResourceDescriptorConfigurator(configurator), AuthProtocolConfigurationServiceConfigurator::new, parentServiceConfiguratorFactory);
    }

    @Override
    public ManagementResourceRegistration register(ManagementResourceRegistration parent) {
        ManagementResourceRegistration registration = super.register(parent);
        new PlainAuthTokenResourceDefinition().register(registration);
        new DigestAuthTokenResourceDefinition().register(registration);
        new CipherAuthTokenResourceDefinition().register(registration);
        return registration;
    }

    static {
        ClassConfigurator.add((short)1100, BinaryAuthToken.class);
        ClassConfigurator.add((short)1101, CipherAuthToken.class);
    }

    private static class ResourceDescriptorConfigurator
    implements UnaryOperator<ResourceDescriptor> {
        private final UnaryOperator<ResourceDescriptor> configurator;

        ResourceDescriptorConfigurator(UnaryOperator<ResourceDescriptor> configurator) {
            this.configurator = configurator;
        }

        @Override
        public ResourceDescriptor apply(ResourceDescriptor descriptor) {
            return ((ResourceDescriptor)this.configurator.apply(descriptor)).setAddOperationTransformation((UnaryOperator)new ProtocolResourceDefinition.LegacyAddOperationTransformation("auth_class")).setOperationTransformation(ProtocolResourceDefinition.LEGACY_OPERATION_TRANSFORMER).addResourceCapabilityReference((CapabilityReferenceRecorder)new ResourceCapabilityReference((Capability)ProtocolResourceDefinition.Capability.PROTOCOL, (UnaryRequirement)AuthTokenResourceDefinition.Capability.AUTH_TOKEN, UnaryCapabilityNameResolver.PARENT));
        }
    }
}

