/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.broadcast;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.activemq.artemis.api.core.BroadcastEndpoint;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;
import org.wildfly.clustering.spi.dispatcher.CommandDispatcherFactory;
import org.wildfly.extension.messaging.activemq.broadcast.BroadcastManager;
import org.wildfly.extension.messaging.activemq.broadcast.CommandDispatcherBroadcastEndpoint;
import org.wildfly.extension.messaging.activemq.broadcast.QueueBroadcastManager;

public class CommandDispatcherBroadcastEndpointFactory
implements BroadcastEndpointFactory {
    private static final Map<String, BroadcastManager> BROADCAST_MANAGERS = new ConcurrentHashMap<String, BroadcastManager>();
    private final CommandDispatcherFactory factory;
    private final String name;
    private final BroadcastManager manager;

    public CommandDispatcherBroadcastEndpointFactory(CommandDispatcherFactory factory, String name) {
        this.factory = factory;
        this.name = name;
        this.manager = BROADCAST_MANAGERS.computeIfAbsent(name, key -> new QueueBroadcastManager());
    }

    public BroadcastEndpoint createBroadcastEndpoint() throws Exception {
        return new CommandDispatcherBroadcastEndpoint(this.factory, this.name, this.manager);
    }
}

