/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.resourceadapters;

import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.subsystems.resourceadapters.Constants;
import org.jboss.as.connector.subsystems.resourceadapters.RaOperationUtil;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;

public class RaActivate
implements OperationStepHandler {
    static final RaActivate INSTANCE = new RaActivate();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode address = operation.require("address");
        final String idName = PathAddress.pathAddress((ModelNode)address).getLastElement().getValue();
        ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
        if (!model.hasDefined(Constants.ARCHIVE.getName()) && !model.hasDefined(Constants.MODULE.getName())) {
            throw ConnectorLogger.ROOT_LOGGER.archiveOrModuleRequired();
        }
        final String archiveOrModuleName = model.get(Constants.ARCHIVE.getName()).isDefined() ? model.get(Constants.ARCHIVE.getName()).asString() : model.get(Constants.MODULE.getName()).asString();
        if (context.isNormalServer()) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ServiceName restartedServiceName = RaOperationUtil.restartIfPresent(context, archiveOrModuleName, idName);
                    if (restartedServiceName == null) {
                        RaOperationUtil.activate(context, idName, archiveOrModuleName);
                    }
                    context.completeStep(new OperationContext.RollbackHandler(){

                        public void handleRollback(OperationContext context, ModelNode operation) {
                            try {
                                RaOperationUtil.removeIfActive(context, archiveOrModuleName, idName);
                            }
                            catch (OperationFailedException operationFailedException) {
                                // empty catch block
                            }
                        }
                    });
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }
}

