/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.parsers.util;

import java.net.URI;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.constants.JBossSAMLConstants;
import org.picketlink.common.constants.JBossSAMLURIConstants;
import org.picketlink.common.exceptions.ParsingException;
import org.picketlink.common.util.StaxParserUtil;
import org.picketlink.identity.federation.core.parsers.saml.SAML11SubjectParser;
import org.picketlink.identity.federation.core.saml.v2.util.SignatureUtil;
import org.picketlink.identity.federation.core.saml.v2.util.XMLTimeUtil;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11ActionType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11AttributeStatementType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11AttributeType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11AudienceRestrictionCondition;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11AuthenticationStatementType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11AuthorityBindingType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11AuthorizationDecisionStatementType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11ConditionsType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11DecisionType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11SubjectConfirmationType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11SubjectLocalityType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11SubjectStatementType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11SubjectType;
import org.picketlink.identity.federation.saml.v1.protocol.SAML11AttributeQueryType;
import org.picketlink.identity.federation.saml.v1.protocol.SAML11AuthenticationQueryType;
import org.picketlink.identity.federation.saml.v1.protocol.SAML11AuthorizationDecisionQueryType;
import org.picketlink.identity.federation.saml.v2.assertion.SubjectConfirmationDataType;
import org.picketlink.identity.xmlsec.w3.xmldsig.DSAKeyValueType;
import org.picketlink.identity.xmlsec.w3.xmldsig.KeyInfoType;
import org.picketlink.identity.xmlsec.w3.xmldsig.KeyValueType;
import org.picketlink.identity.xmlsec.w3.xmldsig.RSAKeyValueType;
import org.picketlink.identity.xmlsec.w3.xmldsig.X509CertificateType;
import org.picketlink.identity.xmlsec.w3.xmldsig.X509DataType;
import org.w3c.dom.Element;

public class SAML11ParserUtil {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();

    public static SAML11AuthenticationStatementType parseAuthenticationStatement(XMLEventReader xmlEventReader) throws ParsingException {
        XMLEvent xmlEvent;
        StartElement startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
        StaxParserUtil.validate((StartElement)startElement, (String)"AuthenticationStatement");
        Attribute authMethod = startElement.getAttributeByName(new QName("AuthenticationMethod"));
        if (authMethod == null) {
            throw logger.parserRequiredAttribute("AuthenticationMethod");
        }
        Attribute authInstant = startElement.getAttributeByName(new QName("AuthenticationInstant"));
        if (authInstant == null) {
            throw logger.parserRequiredAttribute("AuthenticationInstant");
        }
        SAML11AuthenticationStatementType authStat = new SAML11AuthenticationStatementType(URI.create(StaxParserUtil.getAttributeValue((Attribute)authMethod)), XMLTimeUtil.parse(StaxParserUtil.getAttributeValue((Attribute)authInstant)));
        while (xmlEventReader.hasNext() && (xmlEvent = StaxParserUtil.peek((XMLEventReader)xmlEventReader)) != null) {
            if (xmlEvent instanceof EndElement) {
                xmlEvent = StaxParserUtil.getNextEvent((XMLEventReader)xmlEventReader);
                EndElement endElement = (EndElement)xmlEvent;
                String endElementTag = StaxParserUtil.getEndElementName((EndElement)endElement);
                if (endElementTag.equals("AuthenticationStatement")) break;
                throw logger.parserUnknownEndElement(endElementTag);
            }
            startElement = null;
            startElement = xmlEvent instanceof StartElement ? (StartElement)xmlEvent : StaxParserUtil.peekNextStartElement((XMLEventReader)xmlEventReader);
            if (startElement == null) break;
            String tag = StaxParserUtil.getStartElementName((StartElement)startElement);
            if (JBossSAMLConstants.SUBJECT.get().equalsIgnoreCase(tag)) {
                SAML11SubjectParser subjectParser = new SAML11SubjectParser();
                SAML11SubjectType subject = (SAML11SubjectType)subjectParser.parse(xmlEventReader);
                SAML11SubjectStatementType subStat = new SAML11SubjectStatementType();
                subStat.setSubject(subject);
                authStat.setSubject(subject);
                continue;
            }
            if (JBossSAMLConstants.SUBJECT_LOCALITY.get().equals(tag)) {
                Attribute dns;
                startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                SAML11SubjectLocalityType subjectLocalityType = new SAML11SubjectLocalityType();
                Attribute address = startElement.getAttributeByName(new QName("IPAddress"));
                if (address != null) {
                    subjectLocalityType.setIpAddress(StaxParserUtil.getAttributeValue((Attribute)address));
                }
                if ((dns = startElement.getAttributeByName(new QName("DNSAddress"))) != null) {
                    subjectLocalityType.setDnsAddress(StaxParserUtil.getAttributeValue((Attribute)dns));
                }
                authStat.setSubjectLocality(subjectLocalityType);
                StaxParserUtil.validate((EndElement)StaxParserUtil.getNextEndElement((XMLEventReader)xmlEventReader), (String)JBossSAMLConstants.SUBJECT_LOCALITY.get());
                continue;
            }
            if ("AuthorityBinding".equals(tag)) {
                Attribute authorityKindAttr = startElement.getAttributeByName(new QName("AuthorityKind"));
                if (authorityKindAttr == null) {
                    throw logger.parserRequiredAttribute("AuthorityKind");
                }
                Attribute locationAttr = startElement.getAttributeByName(new QName("Location"));
                if (locationAttr == null) {
                    throw logger.parserRequiredAttribute("Location");
                }
                URI location = URI.create(StaxParserUtil.getAttributeValue((Attribute)locationAttr));
                Attribute bindingAttr = startElement.getAttributeByName(new QName("Binding"));
                if (bindingAttr == null) {
                    throw logger.parserRequiredAttribute("Binding");
                }
                URI binding = URI.create(StaxParserUtil.getAttributeValue((Attribute)bindingAttr));
                QName authorityKind = QName.valueOf(StaxParserUtil.getAttributeValue((Attribute)authorityKindAttr));
                SAML11AuthorityBindingType authorityBinding = new SAML11AuthorityBindingType(authorityKind, location, binding);
                authStat.add(authorityBinding);
                continue;
            }
            throw logger.parserUnknownTag("", startElement.getLocation());
        }
        return authStat;
    }

    public static SAML11SubjectConfirmationType parseSAML11SubjectConfirmation(XMLEventReader xmlEventReader) throws ParsingException {
        SAML11SubjectConfirmationType subjectConfirmationType = new SAML11SubjectConfirmationType();
        StartElement startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = StaxParserUtil.peek((XMLEventReader)xmlEventReader);
            if (xmlEvent instanceof EndElement) {
                EndElement endElement = StaxParserUtil.getNextEndElement((XMLEventReader)xmlEventReader);
                StaxParserUtil.validate((EndElement)endElement, (String)JBossSAMLConstants.SUBJECT_CONFIRMATION.get());
                break;
            }
            if (!(xmlEvent instanceof StartElement)) continue;
            startElement = (StartElement)xmlEvent;
            String startTag = StaxParserUtil.getStartElementName((StartElement)startElement);
            if (startTag.equals("ConfirmationMethod")) {
                startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                String method = StaxParserUtil.getElementText((XMLEventReader)xmlEventReader);
                subjectConfirmationType.addConfirmationMethod(URI.create(method));
                continue;
            }
            if (startTag.equals(JBossSAMLConstants.SUBJECT_CONFIRMATION_DATA.get())) {
                startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                SubjectConfirmationDataType subjectConfirmationData = SAML11ParserUtil.parseSubjectConfirmationData(xmlEventReader);
                subjectConfirmationType.setSubjectConfirmationData(subjectConfirmationData);
                continue;
            }
            if (startTag.equals(JBossSAMLConstants.KEY_INFO.get())) {
                Element keyInfo = StaxParserUtil.getDOMElement((XMLEventReader)xmlEventReader);
                subjectConfirmationType.setKeyInfo(keyInfo);
                continue;
            }
            throw logger.parserUnknownTag(startTag, startElement.getLocation());
        }
        return subjectConfirmationType;
    }

    public static SubjectConfirmationDataType parseSubjectConfirmationData(XMLEventReader xmlEventReader) throws ParsingException {
        XMLEvent xmlEvent;
        Attribute address;
        Attribute recipient;
        Attribute notOnOrAfter;
        Attribute notBefore;
        StartElement startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
        StaxParserUtil.validate((StartElement)startElement, (String)JBossSAMLConstants.SUBJECT_CONFIRMATION_DATA.get());
        SubjectConfirmationDataType subjectConfirmationData = new SubjectConfirmationDataType();
        Attribute inResponseTo = startElement.getAttributeByName(new QName(JBossSAMLConstants.IN_RESPONSE_TO.get()));
        if (inResponseTo != null) {
            subjectConfirmationData.setInResponseTo(StaxParserUtil.getAttributeValue((Attribute)inResponseTo));
        }
        if ((notBefore = startElement.getAttributeByName(new QName(JBossSAMLConstants.NOT_BEFORE.get()))) != null) {
            subjectConfirmationData.setNotBefore(XMLTimeUtil.parse(StaxParserUtil.getAttributeValue((Attribute)notBefore)));
        }
        if ((notOnOrAfter = startElement.getAttributeByName(new QName(JBossSAMLConstants.NOT_ON_OR_AFTER.get()))) != null) {
            subjectConfirmationData.setNotOnOrAfter(XMLTimeUtil.parse(StaxParserUtil.getAttributeValue((Attribute)notOnOrAfter)));
        }
        if ((recipient = startElement.getAttributeByName(new QName(JBossSAMLConstants.RECIPIENT.get()))) != null) {
            subjectConfirmationData.setRecipient(StaxParserUtil.getAttributeValue((Attribute)recipient));
        }
        if ((address = startElement.getAttributeByName(new QName(JBossSAMLConstants.ADDRESS.get()))) != null) {
            subjectConfirmationData.setAddress(StaxParserUtil.getAttributeValue((Attribute)address));
        }
        if (!((xmlEvent = StaxParserUtil.peek((XMLEventReader)xmlEventReader)) instanceof EndElement)) {
            startElement = StaxParserUtil.peekNextStartElement((XMLEventReader)xmlEventReader);
            String tag = StaxParserUtil.getStartElementName((StartElement)startElement);
            if (tag.equals("KeyInfo")) {
                KeyInfoType keyInfo = SAML11ParserUtil.parseKeyInfo(xmlEventReader);
                subjectConfirmationData.setAnyType(keyInfo);
            } else if (tag.equals("EncryptedKey")) {
                subjectConfirmationData.setAnyType(StaxParserUtil.getDOMElement((XMLEventReader)xmlEventReader));
            } else {
                throw logger.parserUnknownTag(tag, startElement.getLocation());
            }
        }
        EndElement endElement = (EndElement)StaxParserUtil.getNextEvent((XMLEventReader)xmlEventReader);
        StaxParserUtil.matches((EndElement)endElement, (String)JBossSAMLConstants.SUBJECT_CONFIRMATION_DATA.get());
        return subjectConfirmationData;
    }

    public static SAML11AttributeStatementType parseSAML11AttributeStatement(XMLEventReader xmlEventReader) throws ParsingException {
        SAML11AttributeStatementType attributeStatementType = new SAML11AttributeStatementType();
        StartElement startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
        String ATTRIBSTATEMT = JBossSAMLConstants.ATTRIBUTE_STATEMENT.get();
        StaxParserUtil.validate((StartElement)startElement, (String)ATTRIBSTATEMT);
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = StaxParserUtil.peek((XMLEventReader)xmlEventReader);
            if (xmlEvent instanceof EndElement) {
                EndElement endElement = StaxParserUtil.getNextEndElement((XMLEventReader)xmlEventReader);
                StaxParserUtil.validate((EndElement)endElement, (String)JBossSAMLConstants.ATTRIBUTE_STATEMENT.get());
                break;
            }
            startElement = StaxParserUtil.peekNextStartElement((XMLEventReader)xmlEventReader);
            String tag = startElement.getName().getLocalPart();
            if (JBossSAMLConstants.ATTRIBUTE.get().equals(tag)) {
                SAML11AttributeType attribute = SAML11ParserUtil.parseSAML11Attribute(xmlEventReader);
                attributeStatementType.add(attribute);
                continue;
            }
            if (JBossSAMLConstants.SUBJECT.get().equals(tag)) {
                SAML11SubjectParser parser = new SAML11SubjectParser();
                SAML11SubjectType subject = (SAML11SubjectType)parser.parse(xmlEventReader);
                attributeStatementType.setSubject(subject);
                continue;
            }
            throw logger.parserUnknownTag(tag, startElement.getLocation());
        }
        return attributeStatementType;
    }

    public static SAML11AttributeType parseSAML11Attribute(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
        StaxParserUtil.validate((StartElement)startElement, (String)JBossSAMLConstants.ATTRIBUTE.get());
        SAML11AttributeType attributeType = null;
        Attribute name = startElement.getAttributeByName(new QName("AttributeName"));
        if (name == null) {
            throw logger.parserRequiredAttribute("Name");
        }
        String attribName = StaxParserUtil.getAttributeValue((Attribute)name);
        Attribute namesp = startElement.getAttributeByName(new QName("AttributeNamespace"));
        if (namesp == null) {
            throw logger.parserRequiredAttribute("Namespace");
        }
        String attribNamespace = StaxParserUtil.getAttributeValue((Attribute)namesp);
        attributeType = new SAML11AttributeType(attribName, URI.create(attribNamespace));
        attributeType.add(SAML11ParserUtil.parseAttributeValue(xmlEventReader));
        SAML11ParserUtil.parseAttributeType(xmlEventReader, startElement, JBossSAMLConstants.ATTRIBUTE.get(), attributeType);
        return attributeType;
    }

    public static void parseAttributeType(XMLEventReader xmlEventReader, StartElement startElement, String rootTag, SAML11AttributeType attributeType) throws ParsingException {
        EndElement end;
        XMLEvent xmlEvent;
        while (!(!xmlEventReader.hasNext() || (xmlEvent = StaxParserUtil.peek((XMLEventReader)xmlEventReader)) instanceof EndElement && StaxParserUtil.matches((EndElement)(end = StaxParserUtil.getNextEndElement((XMLEventReader)xmlEventReader)), (String)rootTag) || (startElement = StaxParserUtil.peekNextStartElement((XMLEventReader)xmlEventReader)) == null)) {
            String tag = StaxParserUtil.getStartElementName((StartElement)startElement);
            if (JBossSAMLConstants.ATTRIBUTE.get().equals(tag)) break;
            if (JBossSAMLConstants.ATTRIBUTE_VALUE.get().equals(tag)) {
                Object attributeValue = SAML11ParserUtil.parseAttributeValue(xmlEventReader);
                attributeType.add(attributeValue);
                continue;
            }
            throw logger.parserUnknownTag(tag, startElement.getLocation());
        }
    }

    public static Object parseAttributeValue(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
        StaxParserUtil.validate((StartElement)startElement, (String)JBossSAMLConstants.ATTRIBUTE_VALUE.get());
        Attribute type = startElement.getAttributeByName(new QName(JBossSAMLURIConstants.XSI_NSURI.get(), "type", "xsi"));
        if (type == null) {
            return StaxParserUtil.getElementText((XMLEventReader)xmlEventReader);
        }
        String typeValue = StaxParserUtil.getAttributeValue((Attribute)type);
        if (typeValue.contains(":string")) {
            return StaxParserUtil.getElementText((XMLEventReader)xmlEventReader);
        }
        throw logger.parserUnknownXSI(typeValue);
    }

    public static SAML11AuthorizationDecisionStatementType parseSAML11AuthorizationDecisionStatement(XMLEventReader xmlEventReader) throws ParsingException {
        EndElement end;
        XMLEvent xmlEvent;
        SAML11AuthorizationDecisionStatementType authzDecision = null;
        StartElement startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
        StaxParserUtil.validate((StartElement)startElement, (String)"AuthorizationDecisionStatement");
        Attribute decision = startElement.getAttributeByName(new QName("Decision"));
        if (decision == null) {
            throw logger.parserRequiredAttribute("Decision");
        }
        String decisionValue = StaxParserUtil.getAttributeValue((Attribute)decision);
        Attribute resource = startElement.getAttributeByName(new QName("Resource"));
        if (resource == null) {
            throw logger.parserRequiredAttribute("Namespace");
        }
        String resValue = StaxParserUtil.getAttributeValue((Attribute)resource);
        authzDecision = new SAML11AuthorizationDecisionStatementType(URI.create(resValue), SAML11DecisionType.valueOf(decisionValue));
        while (!(!xmlEventReader.hasNext() || (xmlEvent = StaxParserUtil.peek((XMLEventReader)xmlEventReader)) instanceof EndElement && StaxParserUtil.matches((EndElement)(end = StaxParserUtil.getNextEndElement((XMLEventReader)xmlEventReader)), (String)"AuthorizationDecisionStatement") || (startElement = StaxParserUtil.peekNextStartElement((XMLEventReader)xmlEventReader)) == null)) {
            String tag = StaxParserUtil.getStartElementName((StartElement)startElement);
            if ("Action".equals(tag)) {
                startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                SAML11ActionType samlAction = new SAML11ActionType();
                Attribute namespaceAttr = startElement.getAttributeByName(new QName("Namespace"));
                if (namespaceAttr != null) {
                    samlAction.setNamespace(StaxParserUtil.getAttributeValue((Attribute)namespaceAttr));
                }
                samlAction.setValue(StaxParserUtil.getElementText((XMLEventReader)xmlEventReader));
                authzDecision.addAction(samlAction);
                continue;
            }
            if (JBossSAMLConstants.SUBJECT.get().equals(tag)) {
                SAML11SubjectParser parser = new SAML11SubjectParser();
                authzDecision.setSubject((SAML11SubjectType)parser.parse(xmlEventReader));
                continue;
            }
            throw logger.parserUnknownTag(tag, startElement.getLocation());
        }
        return authzDecision;
    }

    public static SAML11ConditionsType parseSAML11Conditions(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement startElement;
        EndElement end;
        XMLEvent xmlEvent;
        Attribute notAfterAttribute;
        SAML11ConditionsType conditions = new SAML11ConditionsType();
        StartElement conditionsElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
        StaxParserUtil.validate((StartElement)conditionsElement, (String)JBossSAMLConstants.CONDITIONS.get());
        String assertionNS = "urn:oasis:names:tc:SAML:1.0:assertion";
        QName notBeforeQName = new QName("", JBossSAMLConstants.NOT_BEFORE.get());
        QName notBeforeQNameWithNS = new QName(assertionNS, JBossSAMLConstants.NOT_BEFORE.get());
        QName notAfterQName = new QName("", JBossSAMLConstants.NOT_ON_OR_AFTER.get());
        QName notAfterQNameWithNS = new QName(assertionNS, JBossSAMLConstants.NOT_ON_OR_AFTER.get());
        Attribute notBeforeAttribute = conditionsElement.getAttributeByName(notBeforeQName);
        if (notBeforeAttribute == null) {
            notBeforeAttribute = conditionsElement.getAttributeByName(notBeforeQNameWithNS);
        }
        if ((notAfterAttribute = conditionsElement.getAttributeByName(notAfterQName)) == null) {
            notAfterAttribute = conditionsElement.getAttributeByName(notAfterQNameWithNS);
        }
        if (notBeforeAttribute != null) {
            String notBeforeValue = StaxParserUtil.getAttributeValue((Attribute)notBeforeAttribute);
            conditions.setNotBefore(XMLTimeUtil.parse(notBeforeValue));
        }
        if (notAfterAttribute != null) {
            String notAfterValue = StaxParserUtil.getAttributeValue((Attribute)notAfterAttribute);
            conditions.setNotOnOrAfter(XMLTimeUtil.parse(notAfterValue));
        }
        while (!(!xmlEventReader.hasNext() || (xmlEvent = StaxParserUtil.peek((XMLEventReader)xmlEventReader)) instanceof EndElement && StaxParserUtil.matches((EndElement)(end = StaxParserUtil.getNextEndElement((XMLEventReader)xmlEventReader)), (String)JBossSAMLConstants.CONDITIONS.get()) || (startElement = StaxParserUtil.peekNextStartElement((XMLEventReader)xmlEventReader)) == null)) {
            String tag = StaxParserUtil.getStartElementName((StartElement)startElement);
            if ("AudienceRestrictionCondition".equals(tag)) {
                startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                SAML11AudienceRestrictionCondition restrictCond = new SAML11AudienceRestrictionCondition();
                startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                if (StaxParserUtil.getStartElementName((StartElement)startElement).equals(JBossSAMLConstants.AUDIENCE.get())) {
                    restrictCond.add(URI.create(StaxParserUtil.getElementText((XMLEventReader)xmlEventReader)));
                }
                EndElement theEndElement = StaxParserUtil.getNextEndElement((XMLEventReader)xmlEventReader);
                StaxParserUtil.validate((EndElement)theEndElement, (String)"AudienceRestrictionCondition");
                conditions.add(restrictCond);
                continue;
            }
            throw logger.parserUnknownTag(tag, startElement.getLocation());
        }
        return conditions;
    }

    public static KeyInfoType parseKeyInfo(XMLEventReader xmlEventReader) throws ParsingException {
        KeyInfoType keyInfo = new KeyInfoType();
        StartElement startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
        StaxParserUtil.validate((StartElement)startElement, (String)"KeyInfo");
        XMLEvent xmlEvent = null;
        String tag = null;
        while (xmlEventReader.hasNext()) {
            xmlEvent = StaxParserUtil.peek((XMLEventReader)xmlEventReader);
            if (xmlEvent instanceof EndElement) {
                tag = StaxParserUtil.getEndElementName((EndElement)((EndElement)xmlEvent));
                if (tag.equals("KeyInfo")) {
                    xmlEvent = StaxParserUtil.getNextEndElement((XMLEventReader)xmlEventReader);
                    break;
                }
                throw logger.parserUnknownEndElement(tag);
            }
            startElement = (StartElement)xmlEvent;
            tag = StaxParserUtil.getStartElementName((StartElement)startElement);
            if (tag.equals("EncryptedKey")) {
                keyInfo.addContent(StaxParserUtil.getDOMElement((XMLEventReader)xmlEventReader));
                continue;
            }
            if (tag.equals("X509Data")) {
                startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                X509DataType x509 = new X509DataType();
                startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                StaxParserUtil.validate((StartElement)startElement, (String)"X509Certificate");
                X509CertificateType cert = new X509CertificateType();
                String certValue = StaxParserUtil.getElementText((XMLEventReader)xmlEventReader);
                cert.setEncodedCertificate(certValue.getBytes());
                x509.add(cert);
                EndElement endElement = StaxParserUtil.getNextEndElement((XMLEventReader)xmlEventReader);
                StaxParserUtil.validate((EndElement)endElement, (String)"X509Data");
                keyInfo.addContent(x509);
                continue;
            }
            if (!tag.equals("KeyValue")) continue;
            startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
            KeyValueType keyValue = null;
            startElement = StaxParserUtil.peekNextStartElement((XMLEventReader)xmlEventReader);
            tag = StaxParserUtil.getStartElementName((StartElement)startElement);
            if (tag.equals("RSAKeyValue")) {
                keyValue = SAML11ParserUtil.parseRSAKeyValue(xmlEventReader);
            } else if (tag.equals("DSAKeyValue")) {
                keyValue = SAML11ParserUtil.parseDSAKeyValue(xmlEventReader);
            } else {
                throw logger.parserUnknownTag(tag, startElement.getLocation());
            }
            EndElement endElement = StaxParserUtil.getNextEndElement((XMLEventReader)xmlEventReader);
            StaxParserUtil.validate((EndElement)endElement, (String)"KeyValue");
            keyInfo.addContent(keyValue);
        }
        return keyInfo;
    }

    public static RSAKeyValueType parseRSAKeyValue(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
        StaxParserUtil.validate((StartElement)startElement, (String)"RSAKeyValue");
        XMLEvent xmlEvent = null;
        String tag = null;
        RSAKeyValueType rsaKeyValue = new RSAKeyValueType();
        while (xmlEventReader.hasNext()) {
            String text;
            xmlEvent = StaxParserUtil.peek((XMLEventReader)xmlEventReader);
            if (xmlEvent instanceof EndElement) {
                tag = StaxParserUtil.getEndElementName((EndElement)((EndElement)xmlEvent));
                if (tag.equals("RSAKeyValue")) {
                    xmlEvent = StaxParserUtil.getNextEndElement((XMLEventReader)xmlEventReader);
                    break;
                }
                throw logger.parserUnknownEndElement(tag);
            }
            startElement = (StartElement)xmlEvent;
            tag = StaxParserUtil.getStartElementName((StartElement)startElement);
            if (tag.equals("Modulus")) {
                startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                text = StaxParserUtil.getElementText((XMLEventReader)xmlEventReader);
                rsaKeyValue.setModulus(text.getBytes());
                continue;
            }
            if (tag.equals("Exponent")) {
                startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                text = StaxParserUtil.getElementText((XMLEventReader)xmlEventReader);
                rsaKeyValue.setExponent(text.getBytes());
                continue;
            }
            throw logger.parserUnknownTag(tag, startElement.getLocation());
        }
        return rsaKeyValue;
    }

    private static DSAKeyValueType parseDSAKeyValue(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement startElement = StaxParserUtil.peekNextStartElement((XMLEventReader)xmlEventReader);
        StaxParserUtil.validate((StartElement)startElement, (String)"DSAKeyValue");
        Element dsaElement = StaxParserUtil.getDOMElement((XMLEventReader)xmlEventReader);
        return SignatureUtil.getDSAKeyValue(dsaElement);
    }

    public static SAML11AttributeQueryType parseSAML11AttributeQuery(XMLEventReader xmlEventReader) throws ParsingException {
        SAML11AttributeQueryType query = new SAML11AttributeQueryType();
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = StaxParserUtil.peek((XMLEventReader)xmlEventReader);
            if (xmlEvent instanceof EndElement) {
                EndElement endElement = StaxParserUtil.getNextEndElement((XMLEventReader)xmlEventReader);
                if (StaxParserUtil.matches((EndElement)endElement, (String)"AttributeQuery")) break;
                throw logger.parserUnknownEndElement(StaxParserUtil.getEndElementName((EndElement)endElement));
            }
            if (!(xmlEvent instanceof StartElement)) continue;
            StartElement startElement = (StartElement)xmlEvent;
            String startTag = StaxParserUtil.getStartElementName((StartElement)startElement);
            if (startTag.equals(JBossSAMLConstants.SUBJECT.get())) {
                SAML11SubjectParser parser = new SAML11SubjectParser();
                query.setSubject((SAML11SubjectType)parser.parse(xmlEventReader));
                continue;
            }
            throw logger.parserUnknownTag(startTag, startElement.getLocation());
        }
        return query;
    }

    public static SAML11AuthenticationQueryType parseSAML11AuthenticationQuery(XMLEventReader xmlEventReader) throws ParsingException {
        SAML11AuthenticationQueryType query = new SAML11AuthenticationQueryType();
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = StaxParserUtil.peek((XMLEventReader)xmlEventReader);
            if (xmlEvent instanceof EndElement) {
                EndElement endElement = StaxParserUtil.getNextEndElement((XMLEventReader)xmlEventReader);
                if (StaxParserUtil.matches((EndElement)endElement, (String)"AuthenticationQuery")) break;
                throw logger.parserUnknownEndElement(StaxParserUtil.getEndElementName((EndElement)endElement));
            }
            if (!(xmlEvent instanceof StartElement)) continue;
            StartElement startElement = (StartElement)xmlEvent;
            String startTag = StaxParserUtil.getStartElementName((StartElement)startElement);
            if (startTag.equals(JBossSAMLConstants.SUBJECT.get())) {
                SAML11SubjectParser parser = new SAML11SubjectParser();
                query.setSubject((SAML11SubjectType)parser.parse(xmlEventReader));
                continue;
            }
            throw logger.parserUnknownTag(startTag, startElement.getLocation());
        }
        return query;
    }

    public static SAML11AuthorizationDecisionQueryType parseSAML11AuthorizationDecisionQueryType(XMLEventReader xmlEventReader) throws ParsingException {
        SAML11AuthorizationDecisionQueryType query = new SAML11AuthorizationDecisionQueryType();
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = StaxParserUtil.peek((XMLEventReader)xmlEventReader);
            if (xmlEvent instanceof EndElement) {
                EndElement endElement = StaxParserUtil.getNextEndElement((XMLEventReader)xmlEventReader);
                if (StaxParserUtil.matches((EndElement)endElement, (String)"AuthorizationDecisionQuery")) break;
                throw logger.parserUnknownEndElement(StaxParserUtil.getEndElementName((EndElement)endElement));
            }
            if (!(xmlEvent instanceof StartElement)) continue;
            StartElement startElement = (StartElement)xmlEvent;
            String startTag = StaxParserUtil.getStartElementName((StartElement)startElement);
            if (startTag.equals(JBossSAMLConstants.SUBJECT.get())) {
                SAML11SubjectParser parser = new SAML11SubjectParser();
                query.setSubject((SAML11SubjectType)parser.parse(xmlEventReader));
                continue;
            }
            if (startTag.equals("Resource")) {
                startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                query.setResource(URI.create(StaxParserUtil.getElementText((XMLEventReader)xmlEventReader)));
                continue;
            }
            if (startTag.equals("Action")) {
                startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                SAML11ActionType action = new SAML11ActionType();
                Attribute nsAttr = startElement.getAttributeByName(new QName("Namespace"));
                if (nsAttr != null) {
                    action.setNamespace(StaxParserUtil.getAttributeValue((Attribute)nsAttr));
                }
                action.setValue(StaxParserUtil.getElementText((XMLEventReader)xmlEventReader));
                query.add(action);
                continue;
            }
            throw logger.parserUnknownTag(startTag, startElement.getLocation());
        }
        return query;
    }
}

