/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.webservices11.wsba.client;

import com.arjuna.webservices.SoapFault;
import com.arjuna.webservices.logging.WSTLogger;
import com.arjuna.webservices11.ServiceRegistry;
import com.arjuna.webservices11.SoapFault11;
import com.arjuna.webservices11.util.PrivilegedMapBuilderFactory;
import com.arjuna.webservices11.util.PrivilegedServiceRegistryFactory;
import com.arjuna.webservices11.wsaddr.AddressingHelper;
import com.arjuna.webservices11.wsaddr.EndpointHelper;
import com.arjuna.webservices11.wsaddr.NativeEndpointReference;
import com.arjuna.webservices11.wsarj.InstanceIdentifier;
import com.arjuna.webservices11.wsba.client.WSBAClient;
import java.io.IOException;
import javax.xml.namespace.QName;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.jboss.ws.api.addressing.MAP;
import org.jboss.ws.api.addressing.MAPBuilder;
import org.jboss.ws.api.addressing.MAPEndpoint;
import org.oasis_open.docs.ws_tx.wsba._2006._06.BusinessAgreementWithParticipantCompletionCoordinatorPortType;
import org.oasis_open.docs.ws_tx.wsba._2006._06.ExceptionType;
import org.oasis_open.docs.ws_tx.wsba._2006._06.NotificationType;
import org.oasis_open.docs.ws_tx.wsba._2006._06.StatusType;
import org.xmlsoap.schemas.soap.envelope.Fault;

public class ParticipantCompletionCoordinatorClient {
    private static final ParticipantCompletionCoordinatorClient CLIENT = new ParticipantCompletionCoordinatorClient();
    private String completedAction = null;
    private String failAction = null;
    private String compensatedAction = null;
    private String closedAction = null;
    private String cancelledAction = null;
    private String exitAction = null;
    private String cannotCompleteAction = null;
    private String getStatusAction = null;
    private String statusAction = null;
    private MAPEndpoint participantCompletionParticipant = null;
    private MAPEndpoint secureParticipantCompletionParticipant = null;

    private ParticipantCompletionCoordinatorClient() {
        if (WSTLogger.logger.isTraceEnabled()) {
            WSTLogger.logger.trace((Object)(this.getClass().getSimpleName() + " constructor"));
        }
        MAPBuilder builder = PrivilegedMapBuilderFactory.getInstance().getBuilderInstance();
        this.completedAction = "http://docs.oasis-open.org/ws-tx/wsba/2006/06/Completed";
        this.failAction = "http://docs.oasis-open.org/ws-tx/wsba/2006/06/Fail";
        this.compensatedAction = "http://docs.oasis-open.org/ws-tx/wsba/2006/06/Compensated";
        this.closedAction = "http://docs.oasis-open.org/ws-tx/wsba/2006/06/Closed";
        this.cancelledAction = "http://docs.oasis-open.org/ws-tx/wsba/2006/06/Canceled";
        this.exitAction = "http://docs.oasis-open.org/ws-tx/wsba/2006/06/Exit";
        this.cannotCompleteAction = "http://docs.oasis-open.org/ws-tx/wsba/2006/06/CannotComplete";
        this.getStatusAction = "http://docs.oasis-open.org/ws-tx/wsba/2006/06/GetStatus";
        this.statusAction = "http://docs.oasis-open.org/ws-tx/wsba/2006/06/Status";
        ServiceRegistry serviceRegistry = PrivilegedServiceRegistryFactory.getInstance().getServiceRegistry();
        String participantCompletionParticipantURIString = serviceRegistry.getServiceURI("BusinessAgreementWithParticipantCompletionParticipantService", false);
        String secureParticipantCompletionParticipantURIString = serviceRegistry.getServiceURI("BusinessAgreementWithParticipantCompletionParticipantService", true);
        this.participantCompletionParticipant = builder.newEndpoint(participantCompletionParticipantURIString);
        this.secureParticipantCompletionParticipant = builder.newEndpoint(secureParticipantCompletionParticipantURIString);
    }

    public void sendCompleted(W3CEndpointReference endpoint, MAP map, InstanceIdentifier identifier) throws SoapFault, IOException {
        if (WSTLogger.logger.isTraceEnabled()) {
            WSTLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".sendCompleted"));
        }
        MAPEndpoint participant = this.getParticipant(endpoint, map);
        AddressingHelper.installFromFaultTo(map, participant, identifier);
        BusinessAgreementWithParticipantCompletionCoordinatorPortType port = this.getPort(endpoint, map, this.completedAction);
        NotificationType completed = new NotificationType();
        port.completedOperation(completed);
    }

    public void sendFail(W3CEndpointReference endpoint, MAP map, InstanceIdentifier identifier, QName exceptionIdentifier) throws SoapFault, IOException {
        if (WSTLogger.logger.isTraceEnabled()) {
            WSTLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".sendFail"));
        }
        MAPEndpoint participant = this.getParticipant(endpoint, map);
        AddressingHelper.installFromFaultTo(map, participant, identifier);
        BusinessAgreementWithParticipantCompletionCoordinatorPortType port = this.getPort(endpoint, map, this.failAction);
        ExceptionType fail = new ExceptionType();
        fail.setExceptionIdentifier(exceptionIdentifier);
        port.failOperation(fail);
    }

    public void sendCompensated(W3CEndpointReference endpoint, MAP map, InstanceIdentifier identifier) throws SoapFault, IOException {
        if (WSTLogger.logger.isTraceEnabled()) {
            WSTLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".sendCompensated"));
        }
        MAPEndpoint participant = this.getParticipant(endpoint, map);
        AddressingHelper.installFaultTo(map, participant, identifier);
        BusinessAgreementWithParticipantCompletionCoordinatorPortType port = this.getPort(endpoint, map, this.compensatedAction);
        NotificationType compensated = new NotificationType();
        port.compensatedOperation(compensated);
    }

    public void sendClosed(W3CEndpointReference endpoint, MAP map, InstanceIdentifier identifier) throws SoapFault, IOException {
        if (WSTLogger.logger.isTraceEnabled()) {
            WSTLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".sendClosed"));
        }
        MAPEndpoint participant = this.getParticipant(endpoint, map);
        AddressingHelper.installFaultTo(map, participant, identifier);
        BusinessAgreementWithParticipantCompletionCoordinatorPortType port = this.getPort(endpoint, map, this.closedAction);
        NotificationType closed = new NotificationType();
        port.closedOperation(closed);
    }

    public void sendCancelled(W3CEndpointReference endpoint, MAP map, InstanceIdentifier identifier) throws SoapFault, IOException {
        if (WSTLogger.logger.isTraceEnabled()) {
            WSTLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".sendCancelled"));
        }
        MAPEndpoint participant = this.getParticipant(endpoint, map);
        AddressingHelper.installFaultTo(map, participant, identifier);
        BusinessAgreementWithParticipantCompletionCoordinatorPortType port = this.getPort(endpoint, map, this.cancelledAction);
        NotificationType cancelled = new NotificationType();
        port.canceledOperation(cancelled);
    }

    public void sendExit(W3CEndpointReference endpoint, MAP map, InstanceIdentifier identifier) throws SoapFault, IOException {
        if (WSTLogger.logger.isTraceEnabled()) {
            WSTLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".sendExit"));
        }
        MAPEndpoint participant = this.getParticipant(endpoint, map);
        AddressingHelper.installFromFaultTo(map, participant, identifier);
        BusinessAgreementWithParticipantCompletionCoordinatorPortType port = this.getPort(endpoint, map, this.exitAction);
        NotificationType exit = new NotificationType();
        port.exitOperation(exit);
    }

    public void sendCannotComplete(W3CEndpointReference endpoint, MAP map, InstanceIdentifier identifier) throws SoapFault, IOException {
        if (WSTLogger.logger.isTraceEnabled()) {
            WSTLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".sendCannotComplete"));
        }
        MAPEndpoint participant = this.getParticipant(endpoint, map);
        AddressingHelper.installFromFaultTo(map, participant, identifier);
        BusinessAgreementWithParticipantCompletionCoordinatorPortType port = this.getPort(endpoint, map, this.cannotCompleteAction);
        NotificationType cannotComplete = new NotificationType();
        port.cannotComplete(cannotComplete);
    }

    public void sendGetStatus(W3CEndpointReference endpoint, MAP map, InstanceIdentifier identifier) throws SoapFault, IOException {
        if (WSTLogger.logger.isTraceEnabled()) {
            WSTLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".sendGetStatus"));
        }
        MAPEndpoint participant = this.getParticipant(endpoint, map);
        AddressingHelper.installFromFaultTo(map, participant, identifier);
        BusinessAgreementWithParticipantCompletionCoordinatorPortType port = this.getPort(endpoint, map, this.getStatusAction);
        NotificationType getStatus = new NotificationType();
        port.getStatusOperation(getStatus);
    }

    public void sendStatus(W3CEndpointReference endpoint, MAP map, InstanceIdentifier identifier, QName state) throws SoapFault, IOException {
        if (WSTLogger.logger.isTraceEnabled()) {
            WSTLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".sendStatus"));
        }
        MAPEndpoint participant = this.getParticipant(endpoint, map);
        AddressingHelper.installFromFaultTo(map, participant, identifier);
        BusinessAgreementWithParticipantCompletionCoordinatorPortType port = this.getPort(endpoint, map, this.statusAction);
        StatusType status = new StatusType();
        status.setState(state);
        port.statusOperation(status);
    }

    public void sendSoapFault(SoapFault11 soapFault, W3CEndpointReference participant, MAP map, String faultAction) throws SoapFault, IOException {
        if (WSTLogger.logger.isTraceEnabled()) {
            WSTLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".sendSoapFault"));
        }
        AddressingHelper.installNoneReplyTo(map);
        map.setAction(faultAction);
        BusinessAgreementWithParticipantCompletionCoordinatorPortType port = this.getPort(participant, map, faultAction);
        Fault fault = soapFault.toFault();
        port.soapFault(fault);
    }

    MAPEndpoint getParticipant(W3CEndpointReference endpoint, MAP map) {
        String address;
        if (WSTLogger.logger.isTraceEnabled()) {
            WSTLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".getParticipant"));
        }
        if (endpoint != null) {
            NativeEndpointReference nativeRef = EndpointHelper.transform(NativeEndpointReference.class, (EndpointReference)endpoint);
            address = nativeRef.getAddress();
        } else {
            address = map.getTo();
        }
        if (address.startsWith("https")) {
            return this.secureParticipantCompletionParticipant;
        }
        return this.participantCompletionParticipant;
    }

    public static ParticipantCompletionCoordinatorClient getClient() {
        return CLIENT;
    }

    private BusinessAgreementWithParticipantCompletionCoordinatorPortType getPort(W3CEndpointReference participant, MAP map, String action) {
        AddressingHelper.installNoneReplyTo(map);
        if (participant != null) {
            return WSBAClient.getParticipantCompletionCoordinatorPort(participant, action, map);
        }
        return WSBAClient.getParticipantCompletionCoordinatorPort(action, map);
    }
}

