/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.jose.i18n;

import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageBundle;
import org.jboss.resteasy.jose.jwe.CompressionAlgorithm;
import org.jboss.resteasy.jose.jwe.EncryptionMethod;

@MessageBundle(projectCode="RESTEASY")
public interface Messages {
    public static final Messages MESSAGES = (Messages)org.jboss.logging.Messages.getBundle(Messages.class);
    public static final int BASE = 14000;

    @Message(id=14000, value="The algorithm of the shared symmetric key must be AES")
    public String algorithmOfSharedSymmetricKey();

    @Message(id=14005, value="Algorithm was null")
    public String algorithmWasNull();

    @Message(id=14010, value="The authentication tag must not be null")
    public String authenticationTagMustNotBeNull();

    @Message(id=14015, value="CEK key length mismatch: {0} != {1}", format=Message.Format.MESSAGE_FORMAT)
    public String cekKeyLengthMismatch(int var1, int var2);

    @Message(id=14020, value="The cipher text must not be null")
    public String cipherTextMustNotBeNull();

    @Message(id=14025, value="The Content Encryption Key (CEK) length must be {0} bits for {1} encryption", format=Message.Format.MESSAGE_FORMAT)
    public String contentEncryptionKeyLength(int var1, EncryptionMethod var2);

    @Message(id=14030, value="Could not find MessageBodyReader for JSON")
    public String couldNotFindMessageBodyReaderForJSON();

    @Message(id=14035, value="Could not find MessageBodyWriter for JSON")
    public String couldNotFindMessageBodyWriterForJSON();

    @Message(id=14040, value="Couldn't compress plain text: %s")
    public String couldntCompressPlainText(String var1);

    @Message(id=14045, value="Couldn't decompress plain text: %s")
    public String couldntDecompressPlainText(String var1);

    @Message(id=14050, value="Couldn't decrypt Content Encryption Key (CEK): %s")
    public String couldntDecryptCEK(String var1);

    @Message(id=14055, value="Couldn't encrypt Content Encryption Key (CEK): %s")
    public String couldntEncryptCEK(String var1);

    @Message(id=14060, value="Couldn't generate GCM authentication tag: %s")
    public String couldntGenerateGCMAuthentication(String var1);

    @Message(id=14065, value="Couldn't validate GCM authentication tag: %s")
    public String couldntValidateGCMAuthentication(String var1);

    @Message(id=14070, value="The encrypted key must not be null")
    public String encryptedKeyMustNotBeNull();

    @Message(id=14075, value="EncryptionMethod was null")
    public String encryptionMethodWasNull();

    @Message(id=14080, value="Illegal base64url string!")
    public String illegalBase64UrlString();

    @Message(id=14085, value="The initialization vector (IV) must not be null")
    public String initializationVectorMustNotBeNull();

    @Message(id=14090, value="Invalid HMAC key: %s")
    public String invalidHMACkey(String var1);

    @Message(id=14095, value="The length of the shared symmetric key must be 128 bits (16 bytes), 256 bits (32 bytes) or 512 bites (64 bytes)")
    public String lengthOfSharedSymmetricKey();

    @Message(id=14100, value="MAC check failed")
    public String macCheckFailed();

    @Message(id=14105, value="Not a MAC Algorithm")
    public String notAMACalgorithm();

    @Message(id=14110, value="Not an RSA Algorithm")
    public String notAnRSAalgorithm();

    @Message(id=14115, value="Not encrypted with dir algorithm")
    public String notEncryptedWithDirAlgorithm();

    @Message(id=14120, value="Not encrypted with RSA algorithm")
    public String notEncryptedWithRSAalgorithm();

    @Message(id=14125, value="Parsing error")
    public String parsingError();

    @Message(id=14130, value="Unable to find MessageBodyWriter")
    public String unableToFindMessageBodyWriter();

    @Message(id=14135, value="Unable to find reader for content type")
    public String unableToFindReaderForContentType();

    @Message(id=14140, value="Unexpected encrypted key, must be omitted")
    public String unexpectedEncryptedKey();

    @Message(id=14145, value="Unknown length")
    public String unknownLength();

    @Message(id=14150, value="Unsupported algorithm, must be \"dir\"")
    public String unsupportedAlgorithm();

    @Message(id=14155, value="Unsupported compression algorithm: %s")
    public String unsupportedCompressionAlgorithm(CompressionAlgorithm var1);

    @Message(id=14160, value="Unsupported encryption method, must be A128CBC_HS256, A256CBC_HS512, A128GCM or A128GCM")
    public String unsupportedEncryptionMethod();

    @Message(id=14165, value="Unsupported HMAC algorithm: %s")
    public String unsupportedHMACalgorithm(String var1);

    @Message(id=14170, value="Unsupported JWE algorithm, must be RSA1_5 or RSA_OAEP")
    public String unsupportedJWEalgorithm();

    @Message(id=14175, value="Unsupported AES/CBC/PKCS5Padding/HMAC-SHA2 key length, must be 256 or 512 bits")
    public String unsupportedKeyLength();
}

