/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.core;

import java.io.IOException;
import java.io.ObjectOutput;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.io.ByteBufferImpl;
import org.infinispan.marshall.core.GlobalMarshaller;

final class BytesObjectOutput
implements ObjectOutput {
    final GlobalMarshaller marshaller;
    byte[] bytes;
    int pos;
    private static final int DEFAULT_DOUBLING_SIZE = 0x400000;

    BytesObjectOutput(int size, GlobalMarshaller marshaller) {
        this.bytes = new byte[size];
        this.marshaller = marshaller;
    }

    @Override
    public void writeObject(Object obj) throws IOException {
        this.marshaller.writeNullableObject(obj, this);
    }

    @Override
    public void write(int b) {
        this.writeByte(b);
    }

    @Override
    public void write(byte[] b) {
        int len = b.length;
        int newcount = this.ensureCapacity(len);
        System.arraycopy(b, 0, this.bytes, this.pos, len);
        this.pos = newcount;
    }

    @Override
    public void write(byte[] b, int off, int len) {
        int newcount = this.ensureCapacity(len);
        System.arraycopy(b, off, this.bytes, this.pos, len);
        this.pos = newcount;
    }

    @Override
    public void writeBoolean(boolean v) {
        this.writeByte((byte)(v ? 1 : 0));
    }

    @Override
    public void writeByte(int v) {
        int newcount = this.ensureCapacity(1);
        this.bytes[this.pos] = (byte)v;
        this.pos = newcount;
    }

    @Override
    public void writeShort(int v) {
        int newcount = this.ensureCapacity(2);
        int s = this.pos;
        this.bytes[s] = (byte)(v >> 8);
        this.bytes[s + 1] = (byte)v;
        this.pos = newcount;
    }

    @Override
    public void writeChar(int v) {
        int newcount = this.ensureCapacity(2);
        int s = this.pos;
        this.bytes[s] = (byte)(v >> 8);
        this.bytes[s + 1] = (byte)v;
        this.pos = newcount;
    }

    @Override
    public void writeInt(int v) {
        int newcount = this.ensureCapacity(4);
        int s = this.pos;
        this.bytes[s] = (byte)(v >> 24);
        this.bytes[s + 1] = (byte)(v >> 16);
        this.bytes[s + 2] = (byte)(v >> 8);
        this.bytes[s + 3] = (byte)v;
        this.pos = newcount;
    }

    @Override
    public void writeLong(long v) {
        int newcount = this.ensureCapacity(8);
        int s = this.pos;
        this.bytes[s] = (byte)(v >> 56);
        this.bytes[s + 1] = (byte)(v >> 48);
        this.bytes[s + 2] = (byte)(v >> 40);
        this.bytes[s + 3] = (byte)(v >> 32);
        this.bytes[s + 4] = (byte)(v >> 24);
        this.bytes[s + 5] = (byte)(v >> 16);
        this.bytes[s + 6] = (byte)(v >> 8);
        this.bytes[s + 7] = (byte)v;
        this.pos = newcount;
    }

    @Override
    public void writeFloat(float v) {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public void writeDouble(double v) {
        this.writeLong(Double.doubleToLongBits(v));
    }

    @Override
    public void writeBytes(String s) {
        this.writeString(s);
    }

    @Override
    public void writeChars(String s) {
        this.writeString(s);
    }

    void writeString(String s) {
        int len = s.length();
        if (len == 0) {
            this.writeByte(0);
        } else if (this.isAscii(s, len)) {
            this.writeByte(1);
            this.writeByte(len);
            int newcount = this.ensureCapacity(len);
            s.getBytes(0, len, this.bytes, this.pos);
            this.pos = newcount;
        } else {
            this.writeByte(2);
            this.writeUTF(s);
        }
    }

    private boolean isAscii(String s, int len) {
        boolean ascii = false;
        if (len < 64) {
            ascii = true;
            for (int i = 0; i < len; ++i) {
                if (s.charAt(i) <= '\u007f') continue;
                ascii = false;
                break;
            }
        }
        return ascii;
    }

    @Override
    public void writeUTF(String s) {
        int startPos = this.skipIntSize();
        int localPos = this.pos;
        byte[] localBuf = this.bytes;
        int strlen = s.length();
        char c = '\u0000';
        int i = 0;
        for (i = 0; i < strlen && (c = s.charAt(i)) >= '\u0001' && c <= '\u007f'; ++i) {
            if (localPos == this.bytes.length) {
                this.pos = localPos;
                this.ensureCapacity(1);
                localBuf = this.bytes;
            }
            localBuf[localPos++] = (byte)c;
        }
        while (i < strlen) {
            c = s.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                if (localPos == this.bytes.length) {
                    this.pos = localPos;
                    this.ensureCapacity(1);
                    localBuf = this.bytes;
                }
                localBuf[localPos++] = (byte)c;
            } else if (c > '\u07ff') {
                if (localPos + 3 >= this.bytes.length) {
                    this.pos = localPos;
                    this.ensureCapacity(3);
                    localBuf = this.bytes;
                }
                localBuf[localPos++] = (byte)(0xE0 | c >> 12 & 0xF);
                localBuf[localPos++] = (byte)(0x80 | c >> 6 & 0x3F);
                localBuf[localPos++] = (byte)(0x80 | c & 0x3F);
            } else {
                if (localPos + 2 >= this.bytes.length) {
                    this.pos = localPos;
                    this.ensureCapacity(2);
                    localBuf = this.bytes;
                }
                localBuf[localPos++] = (byte)(0xC0 | c >> 6 & 0x1F);
                localBuf[localPos++] = (byte)(0x80 | c & 0x3F);
            }
            ++i;
        }
        this.pos = localPos;
        this.writeIntDirect(localPos - 4 - startPos, startPos);
    }

    private int skipIntSize() {
        this.ensureCapacity(4);
        int count = this.pos;
        this.pos += 4;
        return count;
    }

    private void writeIntDirect(int intValue, int index) {
        byte[] buf = this.bytes;
        buf[index] = (byte)(intValue >>> 24 & 0xFF);
        buf[index + 1] = (byte)(intValue >>> 16 & 0xFF);
        buf[index + 2] = (byte)(intValue >>> 8 & 0xFF);
        buf[index + 3] = (byte)(intValue & 0xFF);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    private int ensureCapacity(int len) {
        int newcount = this.pos + len;
        if (newcount > this.bytes.length) {
            byte[] newbuf = new byte[this.getNewBufferSize(this.bytes.length, newcount)];
            System.arraycopy(this.bytes, 0, newbuf, 0, this.pos);
            this.bytes = newbuf;
        }
        return newcount;
    }

    private int getNewBufferSize(int curSize, int minNewSize) {
        if (curSize <= 0x400000) {
            return Math.max(curSize << 1, minNewSize);
        }
        return Math.max(curSize + (curSize >> 2), minNewSize);
    }

    byte[] toBytes() {
        byte[] b = new byte[this.pos];
        System.arraycopy(this.bytes, 0, b, 0, this.pos);
        this.pos = 0;
        return b;
    }

    ByteBuffer toByteBuffer() {
        return ByteBufferImpl.create((byte[])this.bytes, (int)0, (int)this.pos);
    }
}

