/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.deployment;

import io.undertow.predicate.Predicate;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.handlers.ServletRequestContext;
import java.util.List;
import org.wildfly.extension.requestcontroller.ControlPoint;
import org.wildfly.extension.requestcontroller.RunResult;

public class GlobalRequestControllerHandler
implements HttpHandler {
    public static final String ORG_WILDFLY_SUSPENDED = "org.wildfly.suspended";
    private final HttpHandler next;
    private final ControlPoint entryPoint;
    private final List<Predicate> allowSuspendedRequests;
    private final ExchangeCompletionListener listener = new ExchangeCompletionListener(){

        public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
            GlobalRequestControllerHandler.this.entryPoint.requestComplete();
            nextListener.proceed();
        }
    };

    public GlobalRequestControllerHandler(HttpHandler next, ControlPoint entryPoint, List<Predicate> allowSuspendedRequests) {
        this.next = next;
        this.entryPoint = entryPoint;
        this.allowSuspendedRequests = allowSuspendedRequests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        RunResult result = this.entryPoint.beginRequest();
        try {
            if (result == RunResult.RUN) {
                this.next.handleRequest(exchange);
            } else {
                boolean allowed = false;
                for (Predicate allow : this.allowSuspendedRequests) {
                    if (!allow.resolve(exchange)) continue;
                    allowed = true;
                    ServletRequestContext src = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
                    if (src != null) {
                        src.getServletRequest().setAttribute(ORG_WILDFLY_SUSPENDED, (Object)"true");
                    }
                    this.next.handleRequest(exchange);
                    break;
                }
                if (!allowed) {
                    exchange.setStatusCode(503);
                    exchange.endExchange();
                }
            }
        }
        finally {
            if (result == RunResult.RUN && (exchange.isComplete() || !exchange.isDispatched())) {
                this.entryPoint.requestComplete();
            } else if (result == RunResult.RUN) {
                exchange.addExchangeCompleteListener(this.listener);
            }
        }
    }

    public static HandlerWrapper wrapper(ControlPoint entryPoint, List<Predicate> allowSuspendedRequests) {
        return handler -> new GlobalRequestControllerHandler(handler, entryPoint, allowSuspendedRequests);
    }

    public HttpHandler getNext() {
        return this.next;
    }
}

