/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.ToLongFunction;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscription;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.server.Bindable;
import org.apache.activemq.artemis.core.server.Consumer;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.impl.AckReason;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.utils.ReferenceCounter;
import org.apache.activemq.artemis.utils.collections.LinkedListIterator;
import org.apache.activemq.artemis.utils.critical.CriticalComponent;

public interface Queue
extends Bindable,
CriticalComponent {
    public static final int MAX_CONSUMERS_UNLIMITED = -1;

    public SimpleString getName();

    public long getID();

    public Filter getFilter();

    public void setFilter(Filter var1);

    public PagingStore getPagingStore();

    public PageSubscription getPageSubscription();

    public RoutingType getRoutingType();

    public void setRoutingType(RoutingType var1);

    public boolean allowsReferenceCallback();

    public boolean isDurable();

    public int durableUp(Message var1);

    public int durableDown(Message var1);

    public void refUp(MessageReference var1);

    public void refDown(MessageReference var1);

    public MessageReference removeWithSuppliedID(long var1, ToLongFunction<MessageReference> var3);

    public boolean isDurableMessage();

    public boolean isAutoDelete();

    public long getAutoDeleteDelay();

    public long getAutoDeleteMessageCount();

    public boolean isTemporary();

    public boolean isAutoCreated();

    public boolean isPurgeOnNoConsumers();

    public void setPurgeOnNoConsumers(boolean var1);

    public boolean isEnabled();

    public void setEnabled(boolean var1);

    public int getConsumersBeforeDispatch();

    public void setConsumersBeforeDispatch(int var1);

    public long getDelayBeforeDispatch();

    public void setDelayBeforeDispatch(long var1);

    public long getDispatchStartTime();

    public boolean isDispatching();

    public void setDispatching(boolean var1);

    public boolean isExclusive();

    public void setExclusive(boolean var1);

    public boolean isLastValue();

    public SimpleString getLastValueKey();

    public boolean isNonDestructive();

    public void setNonDestructive(boolean var1);

    public int getMaxConsumers();

    public void setMaxConsumer(int var1);

    public int getGroupBuckets();

    public void setGroupBuckets(int var1);

    public boolean isGroupRebalance();

    public void setGroupRebalance(boolean var1);

    public boolean isGroupRebalancePauseDispatch();

    public void setGroupRebalancePauseDispatch(boolean var1);

    public SimpleString getGroupFirstKey();

    public void setGroupFirstKey(SimpleString var1);

    public boolean isConfigurationManaged();

    public void setConfigurationManaged(boolean var1);

    public void addConsumer(Consumer var1) throws Exception;

    public void addLingerSession(String var1);

    public void removeLingerSession(String var1);

    public void removeConsumer(Consumer var1);

    public int getConsumerCount();

    public long getConsumerRemovedTimestamp();

    public void setRingSize(long var1);

    public long getRingSize();

    default public boolean isMirrorController() {
        return false;
    }

    default public void setMirrorController(boolean mirrorController) {
    }

    public void setConsumersRefCount(ReferenceCounter var1);

    public ReferenceCounter getConsumersRefCount();

    public void addSorted(List<MessageReference> var1, boolean var2);

    public void reload(MessageReference var1);

    public void addTail(MessageReference var1);

    public void addTail(MessageReference var1, boolean var2);

    public void addHead(MessageReference var1, boolean var2);

    public void addSorted(MessageReference var1, boolean var2);

    public void addHead(List<MessageReference> var1, boolean var2);

    public void acknowledge(MessageReference var1) throws Exception;

    public void acknowledge(MessageReference var1, ServerConsumer var2) throws Exception;

    public void acknowledge(MessageReference var1, AckReason var2, ServerConsumer var3) throws Exception;

    public void acknowledge(Transaction var1, MessageReference var2) throws Exception;

    public void acknowledge(Transaction var1, MessageReference var2, AckReason var3, ServerConsumer var4) throws Exception;

    public void reacknowledge(Transaction var1, MessageReference var2) throws Exception;

    public void cancel(Transaction var1, MessageReference var2);

    public void cancel(Transaction var1, MessageReference var2, boolean var3);

    public void cancel(MessageReference var1, long var2, boolean var4) throws Exception;

    public void deliverAsync();

    public void unproposed(SimpleString var1);

    public void forceDelivery();

    public void deleteQueue() throws Exception;

    public void deleteQueue(boolean var1) throws Exception;

    public void removeAddress() throws Exception;

    public void destroyPaging() throws Exception;

    public long getMessageCount();

    public long getPersistentSize();

    public long getDurableMessageCount();

    public long getDurablePersistentSize();

    public int getDeliveringCount();

    public long getDeliveringSize();

    public int getDurableDeliveringCount();

    public long getDurableDeliveringSize();

    public void referenceHandled(MessageReference var1);

    public int getScheduledCount();

    public long getScheduledSize();

    public int getDurableScheduledCount();

    public long getDurableScheduledSize();

    public List<MessageReference> getScheduledMessages();

    public Map<String, List<MessageReference>> getDeliveringMessages();

    public long getMessagesAdded();

    public long getAcknowledgeAttempts();

    public long getMessagesAcknowledged();

    public long getMessagesExpired();

    public long getMessagesKilled();

    public long getMessagesReplaced();

    public MessageReference removeReferenceWithID(long var1) throws Exception;

    public MessageReference getReference(long var1) throws ActiveMQException;

    public int deleteAllReferences() throws Exception;

    public int deleteAllReferences(int var1) throws Exception;

    public boolean deleteReference(long var1) throws Exception;

    public int deleteMatchingReferences(Filter var1) throws Exception;

    default public int deleteMatchingReferences(int flushLImit, Filter filter) throws Exception {
        return this.deleteMatchingReferences(flushLImit, filter, AckReason.KILLED);
    }

    public int deleteMatchingReferences(int var1, Filter var2, AckReason var3) throws Exception;

    public boolean expireReference(long var1) throws Exception;

    public int expireReferences(Filter var1) throws Exception;

    public void expireReferences() throws Exception;

    public void expire(MessageReference var1) throws Exception;

    public void expire(MessageReference var1, ServerConsumer var2) throws Exception;

    public boolean sendMessageToDeadLetterAddress(long var1) throws Exception;

    public int sendMessagesToDeadLetterAddress(Filter var1) throws Exception;

    public boolean sendToDeadLetterAddress(Transaction var1, MessageReference var2) throws Exception;

    public boolean changeReferencePriority(long var1, byte var3) throws Exception;

    public int changeReferencesPriority(Filter var1, byte var2) throws Exception;

    public boolean moveReference(long var1, SimpleString var3, Binding var4, boolean var5) throws Exception;

    public int moveReferences(Filter var1, SimpleString var2, Binding var3) throws Exception;

    public int moveReferences(int var1, Filter var2, SimpleString var3, boolean var4, Binding var5) throws Exception;

    public int retryMessages(Filter var1) throws Exception;

    public void addRedistributor(long var1);

    public void cancelRedistributor() throws Exception;

    public boolean hasMatchingConsumer(Message var1);

    public Collection<Consumer> getConsumers();

    public Map<SimpleString, Consumer> getGroups();

    public void resetGroup(SimpleString var1);

    public void resetAllGroups();

    public int getGroupCount();

    public Pair<Boolean, Boolean> checkRedelivery(MessageReference var1, long var2, boolean var4) throws Exception;

    public LinkedListIterator<MessageReference> iterator();

    public LinkedListIterator<MessageReference> browserIterator();

    public SimpleString getExpiryAddress();

    public void pause();

    public void pause(boolean var1);

    public void reloadPause(long var1);

    public void resume();

    public boolean isPaused();

    public boolean isPersistedPause();

    public Executor getExecutor();

    public void resetAllIterators();

    public boolean flushExecutor();

    public void close() throws Exception;

    public boolean isDirectDeliver();

    public SimpleString getAddress();

    public boolean isInternalQueue();

    public void setInternalQueue(boolean var1);

    public void resetMessagesAdded();

    public void resetMessagesAcknowledged();

    public void resetMessagesExpired();

    public void resetMessagesKilled();

    public void incrementMesssagesAdded();

    public void deliverScheduledMessages() throws ActiveMQException;

    public void postAcknowledge(MessageReference var1, AckReason var2);

    public float getRate();

    public SimpleString getUser();

    public void setUser(SimpleString var1);

    public void recheckRefCount(OperationContext var1);

    default public void errorProcessing(Consumer consumer, Throwable t, MessageReference messageReference) {
    }

    default public QueueConfiguration getQueueConfiguration() {
        return null;
    }
}

