/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jdbc.store.logging;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.apache.activemq.artemis.jdbc.store.logging.LoggingPreparedStatement;
import org.apache.activemq.artemis.jdbc.store.logging.LoggingStatement;
import org.apache.activemq.artemis.jdbc.store.logging.LoggingUtil;
import org.jboss.logging.Logger;

public class LoggingConnection
implements Connection {
    private final Connection connection;
    private final String connectionID;
    private Logger logger;
    private Logger.Level level = Logger.Level.TRACE;

    public LoggingConnection(Connection connection, Logger logger) {
        this.connection = connection;
        this.logger = logger;
        this.connectionID = LoggingUtil.getID(connection);
    }

    public Connection getConnection() {
        return this.connection;
    }

    public String getConnectionID() {
        return this.connectionID;
    }

    @Override
    public Statement createStatement() throws SQLException {
        LoggingStatement statement = new LoggingStatement(this.connection.createStatement(), this.logger);
        this.logger.logf(this.level, "%s.createStatement() = %s", (Object)this.connectionID, (Object)statement.getStatementID());
        return statement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        LoggingPreparedStatement statement = new LoggingPreparedStatement(this.connection.prepareStatement(sql), this.logger);
        this.logger.logf(this.level, "%s.prepareStatement(%s) = %s", (Object)this.connectionID, (Object)sql, (Object)statement.getStatementID());
        return statement;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        CallableStatement statement = this.connection.prepareCall(sql);
        this.logger.logf(this.level, "%s.prepareCall(%s) = %s", (Object)this.connectionID, (Object)sql, (Object)LoggingUtil.getID(statement));
        return statement;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        String x = this.connection.nativeSQL(sql);
        this.logger.logf(this.level, "%s.nativeSQL(%s) = %s", (Object)this.connectionID, (Object)sql, (Object)x);
        return x;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.logger.logf(this.level, "%s.setAutoCommit(%s)", (Object)this.connectionID, (Object)autoCommit);
        this.connection.setAutoCommit(autoCommit);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        boolean x = this.connection.getAutoCommit();
        this.logger.logf(this.level, "%s.getAutoCommit() = %s", (Object)this.connectionID, (Object)x);
        return x;
    }

    @Override
    public void commit() throws SQLException {
        this.logger.logf(this.level, "%s.commit()", (Object)this.connectionID);
        this.connection.commit();
    }

    @Override
    public void rollback() throws SQLException {
        this.logger.logf(this.level, "%s.rollback()", (Object)this.connectionID);
        this.connection.rollback();
    }

    @Override
    public void close() throws SQLException {
        this.logger.logf(this.level, "%s.close()", (Object)this.connectionID);
        this.connection.close();
    }

    @Override
    public boolean isClosed() throws SQLException {
        boolean x = this.connection.isClosed();
        this.logger.logf(this.level, "%s.isClosed() = %s", (Object)this.connectionID, (Object)x);
        return x;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        DatabaseMetaData x = this.connection.getMetaData();
        this.logger.logf(this.level, "%s.getMetaData() = %s", (Object)this.connectionID, (Object)x);
        return x;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.logger.logf(this.level, "%s.setReadOnly(%s)", (Object)this.connectionID, (Object)readOnly);
        this.connection.setReadOnly(readOnly);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        boolean x = this.connection.isReadOnly();
        this.logger.logf(this.level, "%s.isReadOnly() = %s", (Object)this.connectionID, (Object)x);
        return x;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.logger.logf(this.level, "%s.setCatalog(%s)", (Object)this.connectionID, (Object)catalog);
        this.connection.setCatalog(catalog);
    }

    @Override
    public String getCatalog() throws SQLException {
        String x = this.connection.getCatalog();
        this.logger.logf(this.level, "%s.getCatalog() = %s", (Object)this.connectionID, (Object)x);
        return x;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.logger.logf(this.level, "%s.setTransactionIsolation(%s)", (Object)this.connectionID, (Object)level);
        this.connection.setTransactionIsolation(level);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        int x = this.connection.getTransactionIsolation();
        this.logger.logf(this.level, "%s.getTransactionIsolation() = %s", (Object)this.connectionID, (Object)x);
        return x;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        SQLWarning x = this.connection.getWarnings();
        this.logger.logf(this.level, "%s.getWarnings() = %s", (Object)this.connectionID, (Object)x);
        return x;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.logger.logf(this.level, "%s.clearWarnings()", (Object)this.connectionID);
        this.connection.clearWarnings();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        LoggingStatement statement = new LoggingStatement(this.connection.createStatement(resultSetType, resultSetConcurrency), this.logger);
        this.logger.logf(this.level, "%s.createStatement(%s, %s) = %s", new Object[]{this.connectionID, resultSetType, resultSetConcurrency, statement.getStatementID()});
        return statement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        LoggingPreparedStatement statement = new LoggingPreparedStatement(this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency), this.logger);
        this.logger.logf(this.level, "%s.prepareStatement(%s, %s, %s) = %s", new Object[]{this.connectionID, sql, resultSetType, resultSetConcurrency, statement.getStatementID()});
        return statement;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        CallableStatement statement = this.connection.prepareCall(sql, resultSetType, resultSetConcurrency);
        this.logger.logf(this.level, "%s.createStatement(%s, %s) = %s", new Object[]{this.connectionID, sql, resultSetType, resultSetConcurrency, LoggingUtil.getID(statement)});
        return statement;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        Map<String, Class<?>> x = this.connection.getTypeMap();
        this.logger.logf(this.level, "%s.getTypeMap() = %s", (Object)this.connectionID, x);
        return x;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.logger.logf(this.level, "%s.setTypeMap(%s)", (Object)this.connectionID, map);
        this.connection.setTypeMap(map);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.logger.logf(this.level, "%s.setHoldability(%s)", (Object)this.connectionID, (Object)holdability);
        this.connection.setHoldability(holdability);
    }

    @Override
    public int getHoldability() throws SQLException {
        int x = this.connection.getHoldability();
        this.logger.logf(this.level, "%s.getHoldability() = %s", (Object)this.connectionID, (Object)x);
        return x;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        Savepoint x = this.connection.setSavepoint();
        this.logger.logf(this.level, "%s.setSavepoint() = %s", (Object)this.connectionID, (Object)x);
        return x;
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        Savepoint x = this.connection.setSavepoint(name);
        this.logger.logf(this.level, "%s.setSavepoint(%s) = %s", (Object)this.connectionID, (Object)name, (Object)x);
        return x;
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.logger.logf(this.level, "%s.rollback(%s)", (Object)this.connectionID, (Object)savepoint);
        this.connection.rollback(savepoint);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.logger.logf(this.level, "%s.releaseSavepoint(%s)", (Object)this.connectionID, (Object)savepoint);
        this.connection.releaseSavepoint(savepoint);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        LoggingStatement statement = new LoggingStatement(this.connection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability), this.logger);
        this.logger.logf(this.level, "%s.createStatement(%s, %s, %s) = %s", new Object[]{this.connectionID, resultSetType, resultSetConcurrency, resultSetHoldability, statement.getStatementID()});
        return statement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        LoggingPreparedStatement statement = new LoggingPreparedStatement(this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability), this.logger);
        this.logger.logf(this.level, "%s.prepareStatement(%s, %s, %s, %s) = %s", new Object[]{this.connectionID, sql, resultSetType, resultSetConcurrency, resultSetHoldability, statement.getStatementID()});
        return statement;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        CallableStatement statement = this.connection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.logger.logf(this.level, "%s.prepareCall(%s, %s, %s, %s) = %s", new Object[]{this.connectionID, sql, resultSetType, resultSetConcurrency, resultSetHoldability, LoggingUtil.getID(statement)});
        return statement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        LoggingPreparedStatement preparedStatement = new LoggingPreparedStatement(this.connection.prepareStatement(sql, autoGeneratedKeys), this.logger);
        this.logger.logf(this.level, "%s.prepareStatement(%s, %s) = %s", new Object[]{this.connectionID, sql, autoGeneratedKeys, preparedStatement.getStatementID()});
        return preparedStatement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        LoggingPreparedStatement statement = new LoggingPreparedStatement(this.connection.prepareStatement(sql, columnIndexes), this.logger);
        this.logger.logf(this.level, "%s.prepareStatement(%s, %s) = %s", new Object[]{this.connectionID, sql, Arrays.toString(columnIndexes), statement.getStatementID()});
        return statement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        LoggingPreparedStatement statement = new LoggingPreparedStatement(this.connection.prepareStatement(sql, columnNames), this.logger);
        this.logger.logf(this.level, "%s.prepareStatement(%s, %s) = %s", new Object[]{this.connectionID, sql, Arrays.toString(columnNames), statement.getStatementID()});
        return statement;
    }

    @Override
    public Clob createClob() throws SQLException {
        Clob x = this.connection.createClob();
        this.logger.logf(this.level, "%s.createClob() = %s", (Object)this.connectionID, (Object)x);
        return x;
    }

    @Override
    public Blob createBlob() throws SQLException {
        Blob x = this.connection.createBlob();
        this.logger.logf(this.level, "%s.createBlob() = %s", (Object)this.connectionID, (Object)x);
        return x;
    }

    @Override
    public NClob createNClob() throws SQLException {
        NClob x = this.connection.createNClob();
        this.logger.logf(this.level, "%s.createNClob() = %s", (Object)this.connectionID, (Object)x);
        return x;
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        SQLXML x = this.connection.createSQLXML();
        this.logger.logf(this.level, "%s.createSQLXML() = %s", (Object)this.connectionID, (Object)x);
        return x;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        boolean x = this.connection.isValid(timeout);
        this.logger.logf(this.level, "%s.isValid(%s) = %s", (Object)this.connectionID, (Object)timeout, (Object)x);
        return x;
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.logger.logf(this.level, "%s.setClientInfo(%s, %s)", (Object)this.connectionID, (Object)name, (Object)value);
        this.connection.setClientInfo(name, value);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.logger.logf(this.level, "%s.setClientInfo(%s)", (Object)this.connectionID, (Object)properties);
        this.connection.setClientInfo(properties);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        String x = this.connection.getClientInfo(name);
        this.logger.logf(this.level, "%s.getClientInfo(%s) = %s", (Object)this.connectionID, (Object)name, (Object)x);
        return x;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        Properties x = this.connection.getClientInfo();
        this.logger.logf(this.level, "%s.getClientInfo() = %s", (Object)this.connectionID, (Object)x);
        return x;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        Array x = this.connection.createArrayOf(typeName, elements);
        this.logger.logf(this.level, "%s.createArrayOf(%s, %s) = %s", new Object[]{this.connectionID, typeName, Arrays.toString(elements), x});
        return x;
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        Struct x = this.connection.createStruct(typeName, attributes);
        this.logger.logf(this.level, "%s.createStruct(%s, %s) = %s", new Object[]{this.connectionID, typeName, Arrays.toString(attributes), x});
        return x;
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.logger.logf(this.level, "%s.setSchema(%s)", (Object)this.connectionID, (Object)schema);
        this.connection.setSchema(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        String x = this.connection.getSchema();
        this.logger.logf(this.level, "%s.getSchema() = %s", (Object)this.connectionID, (Object)x);
        return x;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.logger.logf(this.level, "%s.abort(%s)", (Object)this.connectionID, (Object)executor);
        this.connection.abort(executor);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.logger.logf(this.level, "%s.setNetworkTimeout(%s, %d)", (Object)this.connectionID, (Object)executor, (Object)milliseconds);
        this.connection.setNetworkTimeout(executor, milliseconds);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        int x = this.connection.getNetworkTimeout();
        this.logger.logf(this.level, "%s.getNetworkTimeout() = %s", (Object)this.connectionID, (Object)x);
        return x;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        T x = this.connection.unwrap(iface);
        this.logger.logf(this.level, "%s.unwrap(%s) = %s", (Object)this.connectionID, iface, x);
        return x;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        boolean x = this.connection.isWrapperFor(iface);
        this.logger.logf(this.level, "%s.isWrapperFor() = %s", (Object)this.connectionID, iface, (Object)x);
        return x;
    }
}

