/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.wildfly;

import io.undertow.security.api.AuthenticationMechanismFactory;
import io.undertow.servlet.ServletExtension;
import io.undertow.servlet.api.AuthMethodConfig;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.LoginConfig;
import java.util.List;
import javax.servlet.ServletContext;
import org.picketlink.identity.federation.bindings.wildfly.PicketLinkAuthenticator;

public class PicketLinkAuthenticatorServletExtension
implements ServletExtension {
    static final String AUTH_METHOD_NAME = "SECURITY_DOMAIN";

    public void handleDeployment(DeploymentInfo deploymentInfo, ServletContext servletContext) {
        List authMethods;
        LoginConfig loginConfig = deploymentInfo.getLoginConfig();
        if (loginConfig != null && (authMethods = loginConfig.getAuthMethods()) != null) {
            for (AuthMethodConfig method : authMethods) {
                if (!method.getName().equals(AUTH_METHOD_NAME)) continue;
                deploymentInfo.addAuthenticationMechanism(AUTH_METHOD_NAME, (AuthenticationMechanismFactory)new PicketLinkAuthenticator.Factory(deploymentInfo.getIdentityManager()));
            }
        }
    }
}

