/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.vault;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.as.security.vault.VaultLogger;
import org.jboss.as.server.services.security.VaultReaderException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.security.vault.SecurityVaultException;

public class VaultLogger_$logger
extends DelegatingBasicLogger
implements VaultLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = VaultLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public VaultLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String runtimeException$str() {
        return "WFLYSEC0007: Runtime Exception:";
    }

    @Override
    public final RuntimeException runtimeException(Throwable e) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.runtimeException$str(), new Object[0]), e);
        VaultLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String securityException$str() {
        return "WFLYSEC0015: Security Exception";
    }

    @Override
    public final SecurityException securityException(Throwable t) {
        SecurityException result = new SecurityException(String.format(this.getLoggingLocale(), this.securityException$str(), new Object[0]), t);
        VaultLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String vaultReaderException$str() {
        return "WFLYSEC0017: Vault Reader Exception:";
    }

    @Override
    public final VaultReaderException vaultReaderException(Throwable t) {
        VaultReaderException result = new VaultReaderException(String.format(this.getLoggingLocale(), this.vaultReaderException$str(), new Object[0]), t);
        VaultLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String vaultNotInitializedException$str() {
        return "WFLYSEC0026: Vault is not initialized";
    }

    @Override
    public final SecurityException vaultNotInitializedException() {
        SecurityException result = new SecurityException(String.format(this.getLoggingLocale(), this.vaultNotInitializedException$str(), new Object[0]));
        VaultLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String keyStoreDoesnotExistWithExample$str() {
        return "WFLYSEC0037: Keystore '%s' doesn't exist.\nkeystore could be created: keytool -genseckey -alias Vault -storetype jceks -keyalg AES -keysize 128 -storepass secretsecret -keypass secretsecret -keystore %s";
    }

    @Override
    public final Exception keyStoreDoesnotExistWithExample(String keystoreURL, String keystoreURLExample) {
        Exception result = new Exception(String.format(this.getLoggingLocale(), this.keyStoreDoesnotExistWithExample$str(), keystoreURL, keystoreURLExample));
        VaultLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String keyStoreNotWritable$str() {
        return "WFLYSEC0038: Keystore [%s] is not writable or not a file.";
    }

    @Override
    public final Exception keyStoreNotWritable(String keystoreURL) {
        Exception result = new Exception(String.format(this.getLoggingLocale(), this.keyStoreNotWritable$str(), keystoreURL));
        VaultLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String keyStorePasswordNotSpecified$str() {
        return "WFLYSEC0039: Keystore password has to be specified.";
    }

    @Override
    public final Exception keyStorePasswordNotSpecified() {
        Exception result = new Exception(String.format(this.getLoggingLocale(), this.keyStorePasswordNotSpecified$str(), new Object[0]));
        VaultLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String encryptionDirectoryDoesNotExist$str() {
        return "WFLYSEC0041: Encryption directory is not a directory or doesn't exist. (%s)";
    }

    @Override
    public final Exception encryptionDirectoryDoesNotExist(String directory) {
        Exception result = new Exception(String.format(this.getLoggingLocale(), this.encryptionDirectoryDoesNotExist$str(), directory));
        VaultLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotCreateEncryptionDirectory$str() {
        return "WFLYSEC0042: Cannot create encryption directory %s";
    }

    @Override
    public final Exception cannotCreateEncryptionDirectory(String directory) {
        Exception result = new Exception(String.format(this.getLoggingLocale(), this.cannotCreateEncryptionDirectory$str(), directory));
        VaultLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String iterationCountOutOfRange$str() {
        return "WFLYSEC0043: Iteration count has to be within 1 - 2147483647, but it is %s.";
    }

    @Override
    public final Exception iterationCountOutOfRange(String iteration) {
        Exception result = new Exception(String.format(this.getLoggingLocale(), this.iterationCountOutOfRange$str(), iteration));
        VaultLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String saltWrongLength$str() {
        return "WFLYSEC0044: Salt has to be exactly 8 characters long.";
    }

    @Override
    public final Exception saltWrongLength() {
        Exception result = new Exception(String.format(this.getLoggingLocale(), this.saltWrongLength$str(), new Object[0]));
        VaultLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String securityVaultException$str() {
        return "WFLYSEC0045: Exception encountered:";
    }

    @Override
    public final Exception securityVaultException(SecurityVaultException cause) {
        Exception result = new Exception(String.format(this.getLoggingLocale(), this.securityVaultException$str(), new Object[0]), cause);
        VaultLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String vaultAliasNotSpecified$str() {
        return "WFLYSEC0046: Vault alias has to be specified.";
    }

    @Override
    public final Exception vaultAliasNotSpecified() {
        Exception result = new Exception(String.format(this.getLoggingLocale(), this.vaultAliasNotSpecified$str(), new Object[0]));
        VaultLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String vaultAttributeCreateDisplay$str() {
        return "WFLYSEC0047: Secured attribute value has been stored in Vault.\nPlease make note of the following:\n********************************************\nVault Block:%s\nAttribute Name:%s\nConfiguration should be done as follows:\n%s\n********************************************";
    }

    @Override
    public final String vaultAttributeCreateDisplay(String VaultBlock, String attributeName, String configurationString) {
        return String.format(this.getLoggingLocale(), this.vaultAttributeCreateDisplay$str(), VaultBlock, attributeName, configurationString);
    }

    protected String vaultConfigurationTitle$str() {
        return "WFLYSEC0048: Vault Configuration commands in WildFly for CLI:";
    }

    @Override
    public final String vaultConfigurationTitle() {
        return String.format(this.getLoggingLocale(), this.vaultConfigurationTitle$str(), new Object[0]);
    }

    protected String noConsole$str() {
        return "WFLYSEC0049: No console.";
    }

    @Override
    public final String noConsole() {
        return String.format(this.getLoggingLocale(), this.noConsole$str(), new Object[0]);
    }

    protected String initializingVault$str() {
        return "WFLYSEC0056: Initializing Vault";
    }

    @Override
    public final String initializingVault() {
        return String.format(this.getLoggingLocale(), this.initializingVault$str(), new Object[0]);
    }

    protected String vaultInitialized$str() {
        return "WFLYSEC0057: Vault is initialized and ready for use";
    }

    @Override
    public final String vaultInitialized() {
        return String.format(this.getLoggingLocale(), this.vaultInitialized$str(), new Object[0]);
    }

    protected String handshakeComplete$str() {
        return "WFLYSEC0058: Handshake with Vault complete";
    }

    @Override
    public final String handshakeComplete() {
        return String.format(this.getLoggingLocale(), this.handshakeComplete$str(), new Object[0]);
    }

    protected String exceptionEncountered$str() {
        return "WFLYSEC0059: Exception encountered:";
    }

    @Override
    public final String exceptionEncountered() {
        return String.format(this.getLoggingLocale(), this.exceptionEncountered$str(), new Object[0]);
    }

    protected String problemParsingCommandLineParameters$str() {
        return "WFLYSEC0068: Problem while parsing command line parameters:";
    }

    @Override
    public final String problemParsingCommandLineParameters() {
        return String.format(this.getLoggingLocale(), this.problemParsingCommandLineParameters$str(), new Object[0]);
    }

    protected String cmdLineSecuredAttributeAlreadyExists$str() {
        return "WFLYSEC0080: Secured attribute (password) already exists.";
    }

    @Override
    public final String cmdLineSecuredAttributeAlreadyExists() {
        return String.format(this.getLoggingLocale(), this.cmdLineSecuredAttributeAlreadyExists$str(), new Object[0]);
    }

    protected String cmdLineSecuredAttributeDoesNotExist$str() {
        return "WFLYSEC0081: Secured attribute (password) doesn't exist.";
    }

    @Override
    public final String cmdLineSecuredAttributeDoesNotExist() {
        return String.format(this.getLoggingLocale(), this.cmdLineSecuredAttributeDoesNotExist$str(), new Object[0]);
    }

    protected String enterEncryptionDirectory$str() {
        return "Enter directory to store encrypted files:";
    }

    @Override
    public final String enterEncryptionDirectory() {
        return String.format(this.getLoggingLocale(), this.enterEncryptionDirectory$str(), new Object[0]);
    }

    protected String enterKeyStoreURL$str() {
        return "Enter Keystore URL:";
    }

    @Override
    public final String enterKeyStoreURL() {
        return String.format(this.getLoggingLocale(), this.enterKeyStoreURL$str(), new Object[0]);
    }

    protected String enterKeyStorePassword$str() {
        return "Enter Keystore password:";
    }

    @Override
    public final String enterKeyStorePassword() {
        return String.format(this.getLoggingLocale(), this.enterKeyStorePassword$str(), new Object[0]);
    }

    protected String enterKeyStorePasswordAgain$str() {
        return "Enter Keystore password again:";
    }

    @Override
    public final String enterKeyStorePasswordAgain() {
        return String.format(this.getLoggingLocale(), this.enterKeyStorePasswordAgain$str(), new Object[0]);
    }

    protected String enterSalt$str() {
        return "Enter 8 character salt:";
    }

    @Override
    public final String enterSalt() {
        return String.format(this.getLoggingLocale(), this.enterSalt$str(), new Object[0]);
    }

    protected String enterIterationCount$str() {
        return "Enter iteration count as a number (e.g.: 44):";
    }

    @Override
    public final String enterIterationCount() {
        return String.format(this.getLoggingLocale(), this.enterIterationCount$str(), new Object[0]);
    }

    protected String enterKeyStoreAlias$str() {
        return "Enter Keystore Alias:";
    }

    @Override
    public final String enterKeyStoreAlias() {
        return String.format(this.getLoggingLocale(), this.enterKeyStoreAlias$str(), new Object[0]);
    }

    protected String enterYourPassword$str() {
        return "Enter your password:";
    }

    @Override
    public final String enterYourPassword() {
        return String.format(this.getLoggingLocale(), this.enterYourPassword$str(), new Object[0]);
    }

    protected String enterYourPasswordAgain$str() {
        return "Enter your password again:";
    }

    @Override
    public final String enterYourPasswordAgain() {
        return String.format(this.getLoggingLocale(), this.enterYourPasswordAgain$str(), new Object[0]);
    }

    protected String passwordsDoNotMatch$str() {
        return "Values entered don't match";
    }

    @Override
    public final String passwordsDoNotMatch() {
        return String.format(this.getLoggingLocale(), this.passwordsDoNotMatch$str(), new Object[0]);
    }

    protected String passwordsMatch$str() {
        return "Values match";
    }

    @Override
    public final String passwordsMatch() {
        return String.format(this.getLoggingLocale(), this.passwordsMatch$str(), new Object[0]);
    }

    protected String interactionCommandOptions$str() {
        return "Please enter a Digit::  0: Store a secured attribute  1: Check whether a secured attribute exists  2: Remove secured attribute  3: Exit";
    }

    @Override
    public final String interactionCommandOptions() {
        return String.format(this.getLoggingLocale(), this.interactionCommandOptions$str(), new Object[0]);
    }

    protected String taskStoreSecuredAttribute$str() {
        return "Task: Store a secured attribute";
    }

    @Override
    public final String taskStoreSecuredAttribute() {
        return String.format(this.getLoggingLocale(), this.taskStoreSecuredAttribute$str(), new Object[0]);
    }

    protected String interactivePromptSecureAttributeValue$str() {
        return "Please enter secured attribute value (such as password)";
    }

    @Override
    public final String interactivePromptSecureAttributeValue() {
        return String.format(this.getLoggingLocale(), this.interactivePromptSecureAttributeValue$str(), new Object[0]);
    }

    protected String interactivePromptVaultBlock$str() {
        return "Enter Vault Block:";
    }

    @Override
    public final String interactivePromptVaultBlock() {
        return String.format(this.getLoggingLocale(), this.interactivePromptVaultBlock$str(), new Object[0]);
    }

    protected String interactivePromptAttributeName$str() {
        return "Enter Attribute Name:";
    }

    @Override
    public final String interactivePromptAttributeName() {
        return String.format(this.getLoggingLocale(), this.interactivePromptAttributeName$str(), new Object[0]);
    }

    protected String problemOcurred$str() {
        return "Problem occurred:";
    }

    @Override
    public final String problemOcurred() {
        return String.format(this.getLoggingLocale(), this.problemOcurred$str(), new Object[0]);
    }

    protected String interactiveCommandString$str() {
        return "Please enter a Digit::   0: Start Interactive Session   1: Remove Interactive Session  2: Exit";
    }

    @Override
    public final String interactiveCommandString() {
        return String.format(this.getLoggingLocale(), this.interactiveCommandString$str(), new Object[0]);
    }

    protected String startingInteractiveSession$str() {
        return "Starting an interactive session";
    }

    @Override
    public final String startingInteractiveSession() {
        return String.format(this.getLoggingLocale(), this.startingInteractiveSession$str(), new Object[0]);
    }

    protected String removingInteractiveSession$str() {
        return "Removing the current interactive session";
    }

    @Override
    public final String removingInteractiveSession() {
        return String.format(this.getLoggingLocale(), this.removingInteractiveSession$str(), new Object[0]);
    }

    protected String cmdLineKeyStoreURL$str() {
        return "Keystore URL";
    }

    @Override
    public final String cmdLineKeyStoreURL() {
        return String.format(this.getLoggingLocale(), this.cmdLineKeyStoreURL$str(), new Object[0]);
    }

    protected String cmdLineKeyStorePassword$str() {
        return "Keystore password";
    }

    @Override
    public final String cmdLineKeyStorePassword() {
        return String.format(this.getLoggingLocale(), this.cmdLineKeyStorePassword$str(), new Object[0]);
    }

    protected String cmdLineEncryptionDirectory$str() {
        return "Directory containing encrypted files";
    }

    @Override
    public final String cmdLineEncryptionDirectory() {
        return String.format(this.getLoggingLocale(), this.cmdLineEncryptionDirectory$str(), new Object[0]);
    }

    protected String cmdLineSalt$str() {
        return "8 character salt";
    }

    @Override
    public final String cmdLineSalt() {
        return String.format(this.getLoggingLocale(), this.cmdLineSalt$str(), new Object[0]);
    }

    protected String cmdLineIterationCount$str() {
        return "Iteration count";
    }

    @Override
    public final String cmdLineIterationCount() {
        return String.format(this.getLoggingLocale(), this.cmdLineIterationCount$str(), new Object[0]);
    }

    protected String cmdLineVaultKeyStoreAlias$str() {
        return "Vault keystore alias";
    }

    @Override
    public final String cmdLineVaultKeyStoreAlias() {
        return String.format(this.getLoggingLocale(), this.cmdLineVaultKeyStoreAlias$str(), new Object[0]);
    }

    protected String cmdLineVaultBlock$str() {
        return "Vault block";
    }

    @Override
    public final String cmdLineVaultBlock() {
        return String.format(this.getLoggingLocale(), this.cmdLineVaultBlock$str(), new Object[0]);
    }

    protected String cmdLineAttributeName$str() {
        return "Attribute name";
    }

    @Override
    public final String cmdLineAttributeName() {
        return String.format(this.getLoggingLocale(), this.cmdLineAttributeName$str(), new Object[0]);
    }

    protected String cmdLineAutomaticallyCreateKeystore$str() {
        return "Automatically create keystore when it doesn't exist";
    }

    @Override
    public final String cmdLineAutomaticallyCreateKeystore() {
        return String.format(this.getLoggingLocale(), this.cmdLineAutomaticallyCreateKeystore$str(), new Object[0]);
    }

    protected String cmdLineSecuredAttribute$str() {
        return "Secured attribute value (such as password) to store";
    }

    @Override
    public final String cmdLineSecuredAttribute() {
        return String.format(this.getLoggingLocale(), this.cmdLineSecuredAttribute$str(), new Object[0]);
    }

    protected String cmdLineCheckAttribute$str() {
        return "Check whether the secured attribute already exists in the Vault";
    }

    @Override
    public final String cmdLineCheckAttribute() {
        return String.format(this.getLoggingLocale(), this.cmdLineCheckAttribute$str(), new Object[0]);
    }

    protected String cmdLineRemoveSecuredAttribute$str() {
        return "Remove secured attribute from the Vault";
    }

    @Override
    public final String cmdLineRemoveSecuredAttribute() {
        return String.format(this.getLoggingLocale(), this.cmdLineRemoveSecuredAttribute$str(), new Object[0]);
    }

    protected String cmdLineHelp$str() {
        return "Help";
    }

    @Override
    public final String cmdLineHelp() {
        return String.format(this.getLoggingLocale(), this.cmdLineHelp$str(), new Object[0]);
    }

    protected String messageAttributeRemovedSuccessfuly$str() {
        return "Secured attribute %s has been successfuly removed from vault";
    }

    @Override
    public final String messageAttributeRemovedSuccessfuly(String displayFormattedAttribute) {
        return String.format(this.getLoggingLocale(), this.messageAttributeRemovedSuccessfuly$str(), displayFormattedAttribute);
    }

    protected String messageAttributeNotRemoved$str() {
        return "Secured attribute %s was not removed from vault, check whether it exist";
    }

    @Override
    public final String messageAttributeNotRemoved(String displayFormattedAttribute) {
        return String.format(this.getLoggingLocale(), this.messageAttributeNotRemoved$str(), displayFormattedAttribute);
    }

    protected String actionNotSpecified$str() {
        return "Action not specified";
    }

    @Override
    public final String actionNotSpecified() {
        return String.format(this.getLoggingLocale(), this.actionNotSpecified$str(), new Object[0]);
    }

    protected String interactivePromptSecureAttributeValueAgain$str() {
        return "Please enter secured attribute value again";
    }

    @Override
    public final String interactivePromptSecureAttributeValueAgain() {
        return String.format(this.getLoggingLocale(), this.interactivePromptSecureAttributeValueAgain$str(), new Object[0]);
    }

    protected String taskVerifySecuredAttributeExists$str() {
        return "Task: Verify whether a secured attribute exists";
    }

    @Override
    public final String taskVerifySecuredAttributeExists() {
        return String.format(this.getLoggingLocale(), this.taskVerifySecuredAttributeExists$str(), new Object[0]);
    }

    protected String interactiveMessageNoValueStored$str() {
        return "No value has been stored for %s";
    }

    @Override
    public final String interactiveMessageNoValueStored(String displayFormattedAttribute) {
        return String.format(this.getLoggingLocale(), this.interactiveMessageNoValueStored$str(), displayFormattedAttribute);
    }

    protected String interactiveMessageValueStored$str() {
        return "A value exists for %s";
    }

    @Override
    public final String interactiveMessageValueStored(String displayFormattedAttribute) {
        return String.format(this.getLoggingLocale(), this.interactiveMessageValueStored$str(), displayFormattedAttribute);
    }

    protected String taskRemoveSecuredAttribute$str() {
        return "Task: Remove secured attribute";
    }

    @Override
    public final String taskRemoveSecuredAttribute() {
        return String.format(this.getLoggingLocale(), this.taskRemoveSecuredAttribute$str(), new Object[0]);
    }
}

