/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl.aesh.cmd.deployment;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.impl.aesh.cmd.AbstractCompleter;
import org.jboss.as.cli.impl.aesh.cmd.HeadersCompleter;
import org.jboss.as.cli.impl.aesh.cmd.HeadersConverter;
import org.jboss.as.cli.impl.aesh.cmd.deployment.EnableCommand;
import org.jboss.as.cli.impl.aesh.cmd.deployment.security.AccessRequirements;
import org.jboss.as.cli.impl.aesh.cmd.deployment.security.CommandWithPermissions;
import org.jboss.as.cli.impl.aesh.cmd.deployment.security.OptionActivators;
import org.jboss.as.cli.impl.aesh.cmd.deployment.security.Permissions;
import org.jboss.as.cli.impl.aesh.cmd.security.ControlledCommandActivator;
import org.jboss.as.cli.util.SimpleTable;
import org.jboss.as.cli.util.StrictSizeTable;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.wildfly.core.cli.command.DMRCommand;
import org.wildfly.core.cli.command.aesh.CLICommandInvocation;
import org.wildfly.core.cli.command.aesh.CLICompleterInvocation;
import org.wildfly.core.cli.command.aesh.activator.HideOptionActivator;

@CommandDefinition(name="info", description="", activator=ControlledCommandActivator.class)
public class InfoCommand
extends CommandWithPermissions
implements DMRCommand {
    private static final String ADDED = "added";
    private static final String ENABLED = "ENABLED";
    private static final String NAME = "NAME";
    private static final String PERSISTENT = "PERSISTENT";
    private static final String RUNTIME_NAME = "RUNTIME-NAME";
    private static final String NOT_ADDED = "not added";
    private static final String N_A = "n/a";
    private static final String SERVER_GROUP = "SERVER-GROUP";
    private static final String STATE = "STATE";
    private static final String STATUS = "STATUS";
    @Deprecated
    @Option(hasValue=false, activator=HideOptionActivator.class)
    protected boolean help;
    @Argument(completer=EnableCommand.NameCompleter.class, activator=OptionActivators.InfoNameActivator.class)
    public String deploymentName;
    @Option(converter=HeadersConverter.class, completer=HeadersCompleter.class, required=false)
    public ModelNode headers;
    @Option(name="server-group", activator=OptionActivators.InfoServerGroupActivator.class, completer=ServerGroupCompleter.class, required=false)
    public String serverGroup;
    private List<String> addedServerGroups;
    private List<String> otherServerGroups;

    public InfoCommand(CommandContext ctx, Permissions permissions) {
        super(ctx, AccessRequirements.infoAccess(permissions), permissions);
    }

    @Deprecated
    public InfoCommand(CommandContext ctx) {
        this(ctx, (Permissions)null);
    }

    private String getName() {
        return this.deploymentName;
    }

    public CommandResult execute(CLICommandInvocation commandInvocation) throws CommandException, InterruptedException {
        if (this.help) {
            commandInvocation.println(commandInvocation.getHelpInfo("deployment info"));
            return CommandResult.SUCCESS;
        }
        try {
            ModelNode request = this.buildRequest(commandInvocation.getCommandContext());
            ModelNode result = commandInvocation.getCommandContext().getModelControllerClient().execute(request);
            if (!Util.isSuccess(result)) {
                throw new CommandException(Util.getFailureDescription(result));
            }
            this.handleResponse(commandInvocation.getCommandContext(), result);
        }
        catch (IOException e) {
            throw new CommandException("Failed to deploy", (Throwable)e);
        }
        catch (CommandFormatException ex) {
            throw new CommandException((Throwable)ex);
        }
        return CommandResult.SUCCESS;
    }

    @Override
    public ModelNode buildRequest(CommandContext ctx) throws CommandFormatException {
        String deploymentName = this.getName();
        if (ctx.isDomainMode() && deploymentName == null && (this.serverGroup == null || this.serverGroup.isEmpty())) {
            throw new CommandFormatException("Either a name or --server-group is required.");
        }
        ModelNode request = new ModelNode();
        if (ctx.isDomainMode()) {
            List<String> serverGroups = Util.getServerGroups(ctx.getModelControllerClient());
            this.addedServerGroups = null;
            this.otherServerGroups = null;
            if (this.serverGroup == null) {
                ModelNode response;
                if (deploymentName == null || deploymentName.indexOf(42) >= 0) {
                    throw new CommandFormatException("If --server-group  is not specified, a name  must be set to a specific deployment name, wildcards are allowed only when --server-group is provided.");
                }
                ModelNode validateRequest = new ModelNode();
                validateRequest.get("operation").set("composite");
                validateRequest.get("address").setEmptyList();
                ModelNode steps = validateRequest.get("steps");
                for (String serverGroup : serverGroups) {
                    ModelNode step = new ModelNode();
                    step.get("address").setEmptyList();
                    step.get("operation").set("validate-address");
                    ModelNode value = step.get("value");
                    value.add("server-group", serverGroup);
                    value.add("deployment", deploymentName);
                    steps.add(step);
                }
                ModelControllerClient client = ctx.getModelControllerClient();
                try {
                    response = client.execute(validateRequest);
                }
                catch (IOException e) {
                    throw new CommandFormatException("Failed to query server groups for deployment " + deploymentName, e);
                }
                if (!response.hasDefined("result")) {
                    throw new CommandFormatException("The validation response came back w/o result: " + response);
                }
                ModelNode result = response.get("result");
                if (result.hasDefined("domain-results")) {
                    result = result.get("domain-results");
                }
                List stepResponses = result.asPropertyList();
                for (int i = 0; i < serverGroups.size(); ++i) {
                    Property prop = (Property)stepResponses.get(i);
                    ModelNode stepResponse = prop.getValue();
                    if (stepResponse.has(prop.getName())) {
                        stepResponse = stepResponse.get(prop.getName());
                    }
                    if (stepResponse.hasDefined("result")) {
                        ModelNode stepResult = stepResponse.get("result");
                        if (stepResult.hasDefined("valid") && stepResult.get("valid").asBoolean()) {
                            if (this.addedServerGroups == null) {
                                this.addedServerGroups = new ArrayList<String>();
                            }
                            this.addedServerGroups.add(serverGroups.get(i));
                            continue;
                        }
                        if (this.otherServerGroups == null) {
                            this.otherServerGroups = new ArrayList<String>();
                        }
                        this.otherServerGroups.add(serverGroups.get(i));
                        continue;
                    }
                    if (this.otherServerGroups == null) {
                        this.otherServerGroups = new ArrayList<String>();
                    }
                    this.otherServerGroups.add(serverGroups.get(i));
                }
                request.get("operation").set("composite");
                request.get("address").setEmptyList();
                steps = request.get("steps");
                ModelNode step = new ModelNode();
                ModelNode address = step.get("address");
                address.add("deployment", deploymentName);
                step.get("operation").set("read-resource");
                steps.add(step);
                if (this.addedServerGroups != null) {
                    for (String serverGroup : this.addedServerGroups) {
                        step = new ModelNode();
                        address = step.get("address");
                        address.add("server-group", serverGroup);
                        address.add("deployment", deploymentName);
                        step.get("operation").set("read-resource");
                        steps.add(step);
                    }
                }
            } else {
                if (this.serverGroup.indexOf(42) >= 0) {
                    throw new CommandFormatException("Wildcards are not allowed here, please give a valid server-group name.");
                }
                request.get("operation").set("composite");
                request.get("address").setEmptyList();
                ModelNode steps = request.get("steps");
                ModelNode step = new ModelNode();
                step.get("operation").set("read-children-resources");
                step.get("child-type").set("deployment");
                step.get("include-runtime").set("true");
                steps.add(step);
                step = new ModelNode();
                step.get("operation").set("read-children-resources");
                step.get("address").add("server-group", this.serverGroup);
                step.get("child-type").set("deployment");
                step.get("include-runtime").set("true");
                steps.add(step);
            }
        } else if (deploymentName == null || deploymentName.indexOf(42) >= 0) {
            request.get("operation").set("read-children-resources");
            request.get("child-type").set("deployment");
            request.get("include-runtime").set("true");
        } else {
            ModelNode address = request.get("address");
            address.add("deployment", deploymentName);
            request.get("operation").set("read-resource");
            request.get("include-runtime").set(true);
        }
        if (this.headers != null) {
            ModelNode opHeaders = request.get("operation-headers");
            opHeaders.set(this.headers);
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleResponse(CommandContext ctx, ModelNode response) throws CommandFormatException {
        try {
            if (!response.hasDefined("result")) {
                throw new CommandFormatException("The operation response came back w/o result: " + response);
            }
            ModelNode result = response.get("result");
            if (ctx.isDomainMode()) {
                Iterator steps;
                if (result.hasDefined("domain-results")) {
                    result = result.get("domain-results");
                }
                if (!(steps = result.asPropertyList().iterator()).hasNext()) {
                    throw new CommandFormatException("Response for the main resource info of the deployment is missing: " + result);
                }
                ModelNode step = ((Property)steps.next()).getValue();
                if (step.has("step-1")) {
                    step = step.get("step-1");
                }
                if (!step.has("result")) {
                    throw new CommandFormatException("Failed to read the main resource info of the deployment: " + Util.getFailureDescription(step));
                }
                ModelNode stepResponse = step.get("result");
                if (this.serverGroup != null) {
                    step = result.get("step-1");
                    if (!step.isDefined()) {
                        throw new CommandFormatException("No step outcome for deployment resources (step-1): " + result);
                    }
                    ModelNode allDeployments = step.get("result");
                    if (!allDeployments.isDefined()) {
                        throw new CommandFormatException("No result for deployment resources (step-1): " + result);
                    }
                    step = result.get("step-2");
                    if (!step.isDefined()) {
                        throw new CommandFormatException("No step outcome for server-group deployment resources (step-2): " + result);
                    }
                    ModelNode sgDeployments = step.get("result");
                    if (!sgDeployments.isDefined()) {
                        throw new CommandFormatException("No result for server-group deployment resources (step-2): " + result);
                    }
                    String deploymentName = this.getName();
                    Pattern pattern = Pattern.compile(Util.wildcardToJavaRegex(deploymentName == null ? "*" : deploymentName));
                    SimpleTable table = new SimpleTable(new String[]{NAME, RUNTIME_NAME, STATE}, ctx.getTerminalWidth());
                    for (String name : allDeployments.keys()) {
                        if (!pattern.matcher(name).matches()) continue;
                        if (sgDeployments.hasDefined(name)) {
                            ModelNode node = sgDeployments.get(name);
                            table.addLine(node.get("name").asString(), node.get("runtime-name").asString(), node.get("enabled").asBoolean() ? "enabled" : ADDED);
                            continue;
                        }
                        ModelNode resource = allDeployments.get(name);
                        table.addLine(resource.get("name").asString(), resource.get("runtime-name").asString(), NOT_ADDED);
                    }
                    if (!table.isEmpty()) {
                        ctx.printLine(table.toString(true));
                    }
                } else {
                    StrictSizeTable table = new StrictSizeTable(1);
                    table.addCell("name", stepResponse.get("name").asString());
                    table.addCell("runtime-name", stepResponse.get("runtime-name").asString());
                    ctx.printLine(table.toString());
                    SimpleTable groups = new SimpleTable(new String[]{SERVER_GROUP, STATE}, ctx.getTerminalWidth());
                    if (this.addedServerGroups == null) {
                        if (steps.hasNext()) {
                            throw new CommandFormatException("Didn't expect results for server groups but received " + (result.asPropertyList().size() - 1) + " more steps.");
                        }
                    } else {
                        for (String sg : this.addedServerGroups) {
                            Property prop = (Property)steps.next();
                            stepResponse = prop.getValue();
                            if (stepResponse.has(prop.getName())) {
                                stepResponse = stepResponse.get(prop.getName());
                            }
                            if (stepResponse.hasDefined("result")) {
                                ModelNode stepResult = stepResponse.get("result");
                                if (stepResult.hasDefined("enabled")) {
                                    groups.addLine(sg, stepResult.get("enabled").asBoolean() ? "enabled" : ADDED);
                                    continue;
                                }
                                groups.addLine(sg, N_A);
                                continue;
                            }
                            groups.addLine(sg, "no response");
                        }
                    }
                    if (this.otherServerGroups != null) {
                        for (String sg : this.otherServerGroups) {
                            groups.addLine(sg, NOT_ADDED);
                        }
                    }
                    ctx.printLine(groups.toString(true));
                }
            } else {
                SimpleTable table = new SimpleTable(new String[]{NAME, RUNTIME_NAME, PERSISTENT, ENABLED, STATUS}, ctx.getTerminalWidth());
                String deploymentName = this.getName();
                if (deploymentName == null || deploymentName.indexOf(42) >= 0) {
                    List list = result.asPropertyList();
                    if (!list.isEmpty()) {
                        Pattern pattern = Pattern.compile(Util.wildcardToJavaRegex(deploymentName == null ? "*" : deploymentName));
                        for (Property p : list) {
                            ModelNode node = p.getValue();
                            String name = node.get("name").asString();
                            if (!pattern.matcher(name).matches()) continue;
                            table.addLine(name, node.get("runtime-name").asString(), node.get("persistent").asString(), node.get("enabled").asString(), node.get("status").asString());
                        }
                    }
                } else {
                    table.addLine(result.get("name").asString(), result.get("runtime-name").asString(), result.get("persistent").asString(), result.get("enabled").asString(), result.get("status").asString());
                }
                if (!table.isEmpty()) {
                    ctx.printLine(table.toString());
                }
            }
        }
        finally {
            this.addedServerGroups = null;
            this.otherServerGroups = null;
        }
    }

    public static class ServerGroupCompleter
    extends AbstractCompleter {
        @Override
        protected List<String> getItems(CLICompleterInvocation completerInvocation) {
            List<String> groups = Collections.emptyList();
            if (completerInvocation.getCommandContext().getModelControllerClient() != null) {
                CommandWithPermissions rc = (CommandWithPermissions)completerInvocation.getCommand();
                return rc.getPermissions().getServerGroupAddPermission().getAllowedOn(completerInvocation.getCommandContext());
            }
            return groups;
        }
    }
}

