/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.time;

import java.io.IOException;
import java.time.Duration;
import org.wildfly.clustering.marshalling.protostream.FieldSetMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

public enum DurationMarshaller implements FieldSetMarshaller<Duration, Duration>
{
    INSTANCE;

    private static final int POSITIVE_SECONDS_INDEX = 0;
    private static final int NEGATIVE_SECONDS_INDEX = 1;
    private static final int MILLIS_INDEX = 2;
    private static final int NANOS_INDEX = 3;
    private static final int FIELDS = 4;

    @Override
    public Duration getBuilder() {
        return Duration.ZERO;
    }

    @Override
    public int getFields() {
        return 4;
    }

    @Override
    public Duration readField(ProtoStreamReader reader, int index, Duration duration) throws IOException {
        switch (index) {
            case 0: {
                return duration.withSeconds(reader.readUInt64());
            }
            case 1: {
                return duration.withSeconds(0L - reader.readUInt64());
            }
            case 2: {
                return duration.withNanos(reader.readUInt32() * 1000000);
            }
            case 3: {
                return duration.withNanos(reader.readUInt32());
            }
        }
        return duration;
    }

    @Override
    public void writeFields(ProtoStreamWriter writer, int startIndex, Duration duration) throws IOException {
        long seconds = duration.getSeconds();
        if (seconds > 0L) {
            writer.writeUInt64(startIndex + 0, seconds);
        } else if (seconds < 0L) {
            writer.writeUInt64(startIndex + 1, 0L - seconds);
        }
        int nanos = duration.getNano();
        if (nanos > 0) {
            if (nanos % 1000000 == 0) {
                writer.writeUInt32(startIndex + 2, nanos / 1000000);
            } else {
                writer.writeUInt32(startIndex + 3, nanos);
            }
        }
    }
}

