/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.spec;

import java.io.Serializable;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import org.wildfly.common.Assert;

public final class IteratedSaltedPasswordAlgorithmSpec
implements AlgorithmParameterSpec,
Serializable {
    private static final long serialVersionUID = -13504632816489169L;
    private final int iterationCount;
    private final byte[] salt;

    public IteratedSaltedPasswordAlgorithmSpec(int iterationCount, byte[] salt) {
        Assert.checkNotNullParam("salt", salt);
        this.iterationCount = iterationCount;
        this.salt = salt;
    }

    public int getIterationCount() {
        return this.iterationCount;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public boolean equals(Object other) {
        if (!(other instanceof IteratedSaltedPasswordAlgorithmSpec)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        IteratedSaltedPasswordAlgorithmSpec otherSpec = (IteratedSaltedPasswordAlgorithmSpec)other;
        return this.iterationCount == otherSpec.iterationCount && Arrays.equals(this.salt, otherSpec.salt);
    }

    public int hashCode() {
        return this.iterationCount * 31 + Arrays.hashCode(this.salt);
    }
}

