/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.protostream.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.infinispan.commons.GlobalContextInitializerImpl;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.UserContextInitializerImpl;
import org.infinispan.commons.util.ServiceFinder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.marshall.persistence.impl.PersistenceContextInitializer;
import org.infinispan.marshall.persistence.impl.PersistenceContextInitializerImpl;
import org.infinispan.marshall.protostream.impl.MarshallableUserObject;
import org.infinispan.marshall.protostream.impl.SerializationContextRegistry;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.protostream.types.java.CommonContainerTypesSchema;
import org.infinispan.protostream.types.java.CommonTypesSchema;

@Scope(value=Scopes.GLOBAL)
public class SerializationContextRegistryImpl
implements SerializationContextRegistry {
    @Inject
    GlobalConfiguration globalConfig;
    @Inject
    @ComponentName(value="org.infinispan.marshaller.user")
    ComponentRef<Marshaller> userMarshaller;
    private final MarshallerContext global = new MarshallerContext();
    private final MarshallerContext persistence = new MarshallerContext();
    private final SerializationContext user = ProtobufUtil.newSerializationContext();

    @Start
    public void start() {
        CommonTypesSchema commonTypesSchema = new CommonTypesSchema();
        SerializationContextRegistryImpl.register((SerializationContextInitializer)commonTypesSchema, this.user);
        CommonContainerTypesSchema commonContainerTypesSchema = new CommonContainerTypesSchema();
        SerializationContextRegistryImpl.register((SerializationContextInitializer)commonContainerTypesSchema, this.user);
        UserContextInitializerImpl userContextInitializer = new UserContextInitializerImpl();
        SerializationContextRegistryImpl.register((SerializationContextInitializer)userContextInitializer, this.user);
        Collection<Object> initializers = this.globalConfig.serialization().contextInitializers();
        if (initializers == null || initializers.isEmpty()) {
            initializers = ServiceFinder.load(SerializationContextInitializer.class, (ClassLoader[])new ClassLoader[]{this.globalConfig.classLoader()});
        }
        initializers.forEach(sci -> SerializationContextRegistryImpl.register(sci, this.user));
        String messageName = PersistenceContextInitializer.getFqTypeName(MarshallableUserObject.class);
        MarshallableUserObject.Marshaller userObjectMarshaller = new MarshallableUserObject.Marshaller(messageName, this.userMarshaller.wired());
        this.update(SerializationContextRegistry.MarshallerType.GLOBAL, arg_0 -> SerializationContextRegistryImpl.lambda$start$1((BaseMarshaller)userObjectMarshaller, arg_0));
        this.update(SerializationContextRegistry.MarshallerType.PERSISTENCE, arg_0 -> SerializationContextRegistryImpl.lambda$start$2((BaseMarshaller)userObjectMarshaller, arg_0));
    }

    @Override
    public ImmutableSerializationContext getGlobalCtx() {
        return this.global.ctx;
    }

    @Override
    public ImmutableSerializationContext getPersistenceCtx() {
        return this.persistence.ctx;
    }

    @Override
    public ImmutableSerializationContext getUserCtx() {
        return this.user;
    }

    @Override
    public void addContextInitializer(SerializationContextRegistry.MarshallerType type, SerializationContextInitializer sci) {
        this.update(type, ctx -> ctx.addContextInitializer(sci).update());
    }

    @Override
    public void addProtoFile(SerializationContextRegistry.MarshallerType type, FileDescriptorSource fileDescriptorSource) {
        this.update(type, ctx -> ctx.addProtoFile(fileDescriptorSource).update());
    }

    @Override
    public void addMarshaller(SerializationContextRegistry.MarshallerType type, BaseMarshaller marshaller) {
        this.update(type, ctx -> ctx.addMarshaller(marshaller).update());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(SerializationContextRegistry.MarshallerType type, Consumer<MarshallerContext> consumer) {
        if (type == SerializationContextRegistry.MarshallerType.GLOBAL) {
            MarshallerContext marshallerContext = this.global;
            synchronized (marshallerContext) {
                consumer.accept(this.global);
            }
        }
        MarshallerContext marshallerContext = this.persistence;
        synchronized (marshallerContext) {
            consumer.accept(this.persistence);
        }
    }

    private static void register(SerializationContextInitializer sci, SerializationContext ctx) {
        sci.registerSchema(ctx);
        sci.registerMarshallers(ctx);
    }

    private static /* synthetic */ void lambda$start$2(BaseMarshaller userObjectMarshaller, MarshallerContext ctx) {
        ctx.addContextInitializer(new PersistenceContextInitializerImpl()).addMarshaller(userObjectMarshaller).update();
    }

    private static /* synthetic */ void lambda$start$1(BaseMarshaller userObjectMarshaller, MarshallerContext ctx) {
        ctx.addContextInitializer(new PersistenceContextInitializerImpl()).addContextInitializer((SerializationContextInitializer)new GlobalContextInitializerImpl()).addMarshaller(userObjectMarshaller).update();
    }

    private static final class MarshallerContext {
        private final List<SerializationContextInitializer> initializers = new ArrayList<SerializationContextInitializer>();
        private final List<FileDescriptorSource> schemas = new ArrayList<FileDescriptorSource>();
        private final List<BaseMarshaller<?>> marshallers = new ArrayList();
        private final SerializationContext ctx = ProtobufUtil.newSerializationContext();

        private MarshallerContext() {
        }

        MarshallerContext addContextInitializer(SerializationContextInitializer sci) {
            this.initializers.add(sci);
            return this;
        }

        MarshallerContext addProtoFile(FileDescriptorSource fileDescriptorSource) {
            this.schemas.add(fileDescriptorSource);
            return this;
        }

        MarshallerContext addMarshaller(BaseMarshaller marshaller) {
            this.marshallers.add(marshaller);
            return this;
        }

        void update() {
            this.initializers.forEach(sci -> SerializationContextRegistryImpl.register(sci, this.ctx));
            this.schemas.forEach(arg_0 -> ((SerializationContext)this.ctx).registerProtoFiles(arg_0));
            this.marshallers.forEach(arg_0 -> ((SerializationContext)this.ctx).registerMarshaller(arg_0));
        }
    }
}

