/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.util.function.Function;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.common.function.ExceptionFunction;

public class FunctionalMarshaller<T, V>
implements ProtoStreamMarshaller<T> {
    private final Class<T> targetClass;
    private final Function<ImmutableSerializationContext, ProtoStreamMarshaller<V>> marshallerFactory;
    private final ExceptionFunction<T, V, IOException> function;
    private final ExceptionFunction<V, T, IOException> factory;

    public FunctionalMarshaller(Class<T> targetClass, Class<V> sourceClass, ExceptionFunction<T, V, IOException> function, ExceptionFunction<V, T, IOException> factory) {
        this(targetClass, (ImmutableSerializationContext context) -> (ProtoStreamMarshaller)context.getMarshaller(sourceClass), function, factory);
    }

    public FunctionalMarshaller(Class<T> targetClass, ProtoStreamMarshaller<V> marshaller, ExceptionFunction<T, V, IOException> function, ExceptionFunction<V, T, IOException> factory) {
        this(targetClass, (ImmutableSerializationContext context) -> marshaller, function, factory);
    }

    public FunctionalMarshaller(Class<T> targetClass, Function<ImmutableSerializationContext, ProtoStreamMarshaller<V>> marshallerFactory, ExceptionFunction<T, V, IOException> function, ExceptionFunction<V, T, IOException> factory) {
        this.targetClass = targetClass;
        this.marshallerFactory = marshallerFactory;
        this.function = function;
        this.factory = factory;
    }

    @Override
    public T readFrom(ProtoStreamReader reader) throws IOException {
        ProtoStreamMarshaller<V> marshaller = this.marshallerFactory.apply(reader.getSerializationContext());
        Object value = marshaller.readFrom(reader);
        return (T)this.factory.apply(value);
    }

    @Override
    public void writeTo(ProtoStreamWriter writer, T object) throws IOException {
        Object value = this.function.apply(object);
        ProtoStreamMarshaller<V> marshaller = this.marshallerFactory.apply(writer.getSerializationContext());
        marshaller.writeTo(writer, value);
    }

    @Override
    public Class<? extends T> getJavaClass() {
        return this.targetClass;
    }
}

