/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.metadata.impl;

import org.hibernate.search.exception.AssertionFailure;

public class BackReference<T> {
    private static final BackReference<Object> EMPTY = new BackReference();
    private boolean initialized = false;
    private T value;

    public static <T> BackReference<T> empty() {
        return EMPTY;
    }

    public T get() {
        if (!this.initialized) {
            throw new AssertionFailure("A reference has been accessed before having been initialized.");
        }
        return this.value;
    }

    void initialize(T value) {
        if (this.value != null) {
            throw new AssertionFailure("A reference has been initialized more than once.");
        }
        this.value = value;
        this.initialized = true;
    }

    public String toString() {
        if (this.initialized) {
            return String.valueOf(this.value);
        }
        return "<not initialized>";
    }

    static {
        EMPTY.initialize(null);
    }
}

