/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.api;

import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.security.auth.Subject;
import org.jboss.as.core.security.RealmGroup;
import org.jboss.as.core.security.RealmRole;
import org.jboss.as.core.security.RealmUser;
import org.jboss.as.core.security.api.RealmPrincipal;
import org.jboss.as.security.api.ContextStateCache;
import org.jboss.as.security.remoting.RemoteConnection;
import org.jboss.as.security.remoting.RemotingContext;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SecurityContextFactory;
import org.wildfly.security.auth.server.SecurityIdentity;

public class ConnectionSecurityContext {
    private ConnectionSecurityContext() {
    }

    public static Collection<Principal> getConnectionPrincipals() {
        RemoteConnection con = RemotingContext.getRemoteConnection();
        if (con != null) {
            HashSet<Principal> principals = new HashSet<Principal>();
            SecurityIdentity localIdentity = con.getSecurityIdentity();
            if (localIdentity != null) {
                Principal principal = localIdentity.getPrincipal();
                String realm = principal instanceof RealmPrincipal ? ((RealmPrincipal)principal).getRealm() : null;
                principals.add((Principal)(realm == null ? new RealmUser(principal.getName()) : new RealmUser(realm, principal.getName())));
                for (String role : localIdentity.getRoles()) {
                    principals.add((Principal)new RealmGroup(role));
                    principals.add((Principal)new RealmRole(role));
                }
                return principals;
            }
            return Collections.emptySet();
        }
        return null;
    }

    public static ContextStateCache pushIdentity(Principal principal, Object credential) throws Exception {
        SecurityContext current = SecurityContextAssociation.getSecurityContext();
        SecurityContext nextContext = SecurityContextFactory.createSecurityContext((Principal)principal, (Object)credential, (Subject)new Subject(), (String)"USER_DELEGATION");
        SecurityContextAssociation.setSecurityContext((SecurityContext)nextContext);
        RemoteConnection con = RemotingContext.getRemoteConnection();
        RemotingContext.clear();
        return new ContextStateCache(con, current);
    }

    public static void popIdentity(ContextStateCache stateCache) {
        RemotingContext.setConnection((RemoteConnection)stateCache.getConnection());
        SecurityContextAssociation.setSecurityContext((SecurityContext)stateCache.getSecurityContext());
    }
}

