/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr.handshake;

import io.undertow.connector.ByteBufferPool;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.protocol.version08.Hybi08Handshake;
import io.undertow.websockets.jsr.ConfiguredServerEndpoint;
import io.undertow.websockets.jsr.handshake.HandshakeUtil;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.util.Collections;
import org.xnio.StreamConnection;

public final class JsrHybi08Handshake
extends Hybi08Handshake {
    private final ConfiguredServerEndpoint config;

    public JsrHybi08Handshake(ConfiguredServerEndpoint config) {
        super(Collections.emptySet(), false);
        this.config = config;
    }

    protected void upgradeChannel(WebSocketHttpExchange exchange, byte[] data) {
        HandshakeUtil.prepareUpgrade(this.config.getEndpointConfiguration(), exchange);
        super.upgradeChannel(exchange, data);
    }

    public WebSocketChannel createChannel(WebSocketHttpExchange exchange, StreamConnection c, ByteBufferPool buffers) {
        WebSocketChannel channel = super.createChannel(exchange, c, buffers);
        HandshakeUtil.setConfig(channel, this.config);
        return channel;
    }

    public boolean matches(WebSocketHttpExchange exchange) {
        return super.matches(exchange) && HandshakeUtil.checkOrigin(this.config.getEndpointConfiguration(), exchange);
    }

    protected String supportedSubprotols(String[] requestedSubprotocolArray) {
        return HandshakeUtil.selectSubProtocol(this.config, requestedSubprotocolArray);
    }
}

