/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.auth;

import java.io.IOException;
import java.util.Collection;
import org.apache.sshd.common.CommonModuleProperties;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.auth.UserAuthInstance;
import org.apache.sshd.common.session.SessionContext;

public interface UserAuthMethodFactory<S extends SessionContext, M extends UserAuthInstance<S>>
extends NamedResource {
    public static final String PASSWORD = "password";
    public static final String PUBLIC_KEY = "publickey";
    public static final String KB_INTERACTIVE = "keyboard-interactive";
    public static final String HOST_BASED = "hostbased";

    public M createUserAuth(S var1) throws IOException;

    public static <S extends SessionContext, M extends UserAuthInstance<S>> M createUserAuth(S session, Collection<? extends UserAuthMethodFactory<S, M>> factories, String name) throws IOException {
        UserAuthMethodFactory<S, M> f = NamedResource.findByName(name, String.CASE_INSENSITIVE_ORDER, factories);
        if (f != null) {
            return f.createUserAuth(session);
        }
        return null;
    }

    public static boolean isSecureAuthenticationTransport(SessionContext session) {
        if (session == null) {
            return false;
        }
        boolean allowInsecure = CommonModuleProperties.ALLOW_INSECURE_AUTH.getRequired(session);
        if (allowInsecure) {
            return true;
        }
        return SessionContext.isSecureSessionTransport((SessionContext)session);
    }

    public static boolean isDataIntegrityAuthenticationTransport(SessionContext session) {
        if (session == null) {
            return false;
        }
        boolean allowNonValidated = CommonModuleProperties.ALLOW_NON_INTEGRITY_AUTH.getRequired(session);
        if (allowNonValidated) {
            return true;
        }
        return SessionContext.isDataIntegrityTransport((SessionContext)session);
    }
}

