/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.OptionalInt;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshalledValue;
import org.wildfly.clustering.marshalling.spi.IndexSerializer;

public class ByteBufferMarshalledValueExternalizer
implements Externalizer<ByteBufferMarshalledValue<Object>> {
    static ByteBuffer readBuffer(ObjectInput input) throws IOException {
        byte[] bytes;
        int size = IndexSerializer.VARIABLE.readInt(input);
        byte[] byArray = bytes = size > 0 ? new byte[size] : null;
        if (bytes != null) {
            input.readFully(bytes);
        }
        return bytes != null ? ByteBuffer.wrap(bytes) : null;
    }

    static void writeBuffer(ObjectOutput output, ByteBuffer buffer) throws IOException {
        int length = buffer != null ? buffer.limit() - buffer.arrayOffset() : 0;
        IndexSerializer.VARIABLE.writeInt(output, length);
        if (length > 0) {
            output.write(buffer.array(), buffer.arrayOffset(), length);
        }
    }

    public ByteBufferMarshalledValue<Object> readObject(ObjectInput input) throws IOException {
        return new ByteBufferMarshalledValue<Object>(ByteBufferMarshalledValueExternalizer.readBuffer(input));
    }

    public void writeObject(ObjectOutput output, ByteBufferMarshalledValue<Object> object) throws IOException {
        ByteBufferMarshalledValueExternalizer.writeBuffer(output, object.getBuffer());
    }

    public Class<ByteBufferMarshalledValue<Object>> getTargetClass() {
        return ByteBufferMarshalledValue.class;
    }

    public OptionalInt size(ByteBufferMarshalledValue<Object> value) {
        try {
            ByteBuffer buffer = value.getBuffer();
            int length = buffer != null ? buffer.limit() - buffer.arrayOffset() : 0;
            return OptionalInt.of(IndexSerializer.VARIABLE.size(length) + length);
        }
        catch (IOException e) {
            return OptionalInt.empty();
        }
    }
}

