/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.core.jgroups;

import java.util.HashMap;
import java.util.Map;
import org.apache.activemq.artemis.api.core.JGroupsBroadcastEndpoint;
import org.apache.activemq.artemis.api.core.jgroups.JChannelWrapper;
import org.jboss.logging.Logger;

public class JChannelManager {
    private static final JChannelManager theInstance = new JChannelManager();
    private boolean loopbackMessages = false;
    private final Logger logger = Logger.getLogger(JChannelManager.class);
    private static final Map<String, JChannelWrapper> channels = new HashMap<String, JChannelWrapper>();

    public static JChannelManager getInstance() {
        return theInstance;
    }

    private JChannelManager() {
    }

    public synchronized JChannelManager clear() {
        for (JChannelWrapper wrapper : channels.values()) {
            wrapper.closeChannel();
        }
        channels.clear();
        this.setLoopbackMessages(false);
        return this;
    }

    public boolean isLoopbackMessages() {
        return this.loopbackMessages;
    }

    public JChannelManager setLoopbackMessages(boolean loopbackMessages) {
        this.loopbackMessages = loopbackMessages;
        return this;
    }

    public synchronized JChannelWrapper getJChannel(String channelName, JGroupsBroadcastEndpoint endpoint) throws Exception {
        JChannelWrapper wrapper = channels.get(channelName);
        if (wrapper == null) {
            wrapper = new JChannelWrapper(this, channelName, endpoint.createChannel());
            channels.put(channelName, wrapper);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Put Channel " + channelName);
            }
            return wrapper;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Add Ref Count " + channelName);
        }
        return wrapper.addRef();
    }

    public synchronized void removeChannel(String channelName) {
        channels.remove(channelName);
    }
}

