/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.ejb3.component.DefaultAccessTimeoutService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

public class DefaultSessionBeanAccessTimeoutWriteHandler
extends AbstractWriteAttributeHandler<Void> {
    private final AttributeDefinition attribute;
    private final ServiceName serviceName;

    public DefaultSessionBeanAccessTimeoutWriteHandler(AttributeDefinition attribute, ServiceName serviceName) {
        super(new AttributeDefinition[]{attribute});
        this.attribute = attribute;
        this.serviceName = serviceName;
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
        ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
        this.applyModelToRuntime(context, model);
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
        ModelNode restored = context.readResource(PathAddress.EMPTY_ADDRESS).getModel().clone();
        restored.get(attributeName).set(valueToRestore);
        this.applyModelToRuntime(context, restored);
    }

    private void applyModelToRuntime(OperationContext context, ModelNode model) throws OperationFailedException {
        DefaultAccessTimeoutService service;
        long timeout = this.attribute.resolveModelAttribute(context, model).asLong();
        ServiceRegistry serviceRegistry = context.getServiceRegistry(true);
        ServiceController controller = serviceRegistry.getService(this.serviceName);
        if (controller != null && (service = (DefaultAccessTimeoutService)controller.getValue()) != null) {
            service.setDefaultAccessTimeout(timeout);
        }
    }
}

