/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resources;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoadingException;
import org.jboss.weld.util.collections.EnumerationList;

public abstract class AbstractClassLoaderResourceLoader
implements ResourceLoader {
    private static final String ERROR_LOADING_CLASS = "Error loading class ";

    public Class<?> classForName(String name) {
        try {
            return this.classLoader().loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new ResourceLoadingException(ERROR_LOADING_CLASS + name, (Throwable)e);
        }
        catch (LinkageError e) {
            throw new ResourceLoadingException(ERROR_LOADING_CLASS + name, (Throwable)e);
        }
        catch (TypeNotPresentException e) {
            throw new ResourceLoadingException(ERROR_LOADING_CLASS + name, (Throwable)e);
        }
    }

    public URL getResource(String name) {
        return this.classLoader().getResource(name);
    }

    public Collection<URL> getResources(String name) {
        try {
            return new EnumerationList<URL>(this.classLoader().getResources(name));
        }
        catch (IOException e) {
            throw new ResourceLoadingException("Error loading resource " + name, (Throwable)e);
        }
    }

    protected abstract ClassLoader classLoader();
}

