/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment.processors;

import java.util.Collection;
import java.util.HashSet;
import javax.transaction.TransactionScoped;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.weld.CdiAnnotations;
import org.jboss.as.weld.deployment.WeldAttachments;
import org.jboss.as.weld.discovery.AnnotationType;
import org.jboss.as.weld.util.Indices;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;

public class BeanDefiningAnnotationProcessor
implements DeploymentUnitProcessor {
    private static final DotName VIEW_SCOPED_NAME = DotName.createSimple((String)"javax.faces.view.ViewScoped");
    private static final DotName FLOW_SCOPED_NAME = DotName.createSimple((String)"javax.faces.flow.FlowScoped");

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (deploymentUnit.getParent() != null) {
            return;
        }
        CompositeIndex index = (CompositeIndex)deploymentUnit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        BeanDefiningAnnotationProcessor.addAnnotations(deploymentUnit, CdiAnnotations.BEAN_DEFINING_ANNOTATIONS);
        BeanDefiningAnnotationProcessor.addAnnotation(deploymentUnit, new AnnotationType(CdiAnnotations.MODEL.getDotName(), false));
        BeanDefiningAnnotationProcessor.addAnnotation(deploymentUnit, new AnnotationType(TransactionScoped.class));
        BeanDefiningAnnotationProcessor.addAnnotation(deploymentUnit, new AnnotationType(VIEW_SCOPED_NAME, true));
        BeanDefiningAnnotationProcessor.addAnnotation(deploymentUnit, new AnnotationType(FLOW_SCOPED_NAME, true));
        for (AnnotationType annotationType : CdiAnnotations.BEAN_DEFINING_META_ANNOTATIONS) {
            BeanDefiningAnnotationProcessor.addAnnotations(deploymentUnit, this.getAnnotationsAnnotatedWith(index, annotationType.getName()));
        }
    }

    private static void addAnnotations(DeploymentUnit deploymentUnit, Collection<AnnotationType> annotations) {
        for (AnnotationType annotation : annotations) {
            BeanDefiningAnnotationProcessor.addAnnotation(deploymentUnit, annotation);
        }
    }

    private static void addAnnotation(DeploymentUnit deploymentUnit, AnnotationType annotation) {
        deploymentUnit.addToAttachmentList(WeldAttachments.BEAN_DEFINING_ANNOTATIONS, (Object)annotation);
    }

    private Collection<AnnotationType> getAnnotationsAnnotatedWith(CompositeIndex index, DotName annotationName) {
        HashSet<AnnotationType> annotations = new HashSet<AnnotationType>();
        for (ClassInfo classInfo : Indices.getAnnotatedClasses(index.getAnnotations(annotationName))) {
            if (!Indices.ANNOTATION_PREDICATE.test(classInfo)) continue;
            annotations.add(AnnotationType.FOR_CLASSINFO.apply(classInfo));
        }
        return annotations;
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
        deploymentUnit.removeAttachment(WeldAttachments.BEAN_DEFINING_ANNOTATIONS);
    }
}

