/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.scanner;

import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import org.jboss.as.server.deployment.scanner.logging.DeploymentScannerLogger;

public class ZipCompletionScanner {
    public static final long LOCSIG = 67324752L;
    public static final long EXTSIG = 134695760L;
    public static final long CENSIG = 33639248L;
    public static final long ENDSIG = 101010256L;
    public static final int LOCLEN = 30;
    public static final int CENLEN = 46;
    public static final int ENDLEN = 22;
    public static final int LOC_FILENAMELEN = 26;
    public static final int LOC_EXTFLDLEN = 28;
    public static final int CENSIZ = 20;
    public static final int CEN_LOC_OFFSET = 32;
    public static final int END_CENSTART = 16;
    public static final long ZIP64_MARKER = 0xFFFFFFFFL;
    public static final int END_COMMENTLEN = 20;
    private static final int MAX_REVERSE_SCAN = 65558;
    private static final int CHUNK_SIZE = 4096;
    private static final int ALPHABET_SIZE = 256;
    private static final byte[] ENDSIG_PATTERN = new byte[]{6, 5, 75, 80};
    private static final int SIG_PATTERN_LENGTH = 4;
    private static final int[] END_BAD_BYTE_SKIP = new int[256];
    private static final byte[] LOCSIG_PATTERN = new byte[]{80, 75, 3, 4};
    private static final int[] LOC_BAD_BYTE_SKIP = new int[256];

    private ZipCompletionScanner() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCompleteZip(File file) throws IOException, NonScannableZipException {
        FileChannel channel;
        block5: {
            long size;
            block4: {
                boolean bl;
                channel = null;
                try {
                    channel = new FileInputStream(file).getChannel();
                    size = channel.size();
                    if (size >= 22L) break block4;
                    bl = false;
                }
                catch (Throwable throwable) {
                    ZipCompletionScanner.safeClose(channel);
                    throw throwable;
                }
                ZipCompletionScanner.safeClose(channel);
                return bl;
            }
            if (!ZipCompletionScanner.validateEndRecord(file, channel, size - 22L)) break block5;
            boolean bl = true;
            ZipCompletionScanner.safeClose(channel);
            return bl;
        }
        boolean bl = ZipCompletionScanner.scanForEndSig(file, channel);
        ZipCompletionScanner.safeClose(channel);
        return bl;
    }

    private static boolean validateEndRecord(File file, FileChannel channel, long startEndRecord) throws IOException, NonScannableZipException {
        try {
            channel.position(startEndRecord);
            ByteBuffer endDirHeader = ZipCompletionScanner.getByteBuffer(22);
            ZipCompletionScanner.read(endDirHeader, channel);
            if (endDirHeader.limit() < 22) {
                return false;
            }
            if (ZipCompletionScanner.getUnsignedInt(endDirHeader, 0) != 101010256L) {
                return false;
            }
            long pos = ZipCompletionScanner.getUnsignedInt(endDirHeader, 16);
            if (pos == 0xFFFFFFFFL) {
                throw new NonScannableZipException(file, true);
            }
            ByteBuffer cdfhBuffer = ZipCompletionScanner.getByteBuffer(46);
            ZipCompletionScanner.read(cdfhBuffer, channel, pos);
            long header = ZipCompletionScanner.getUnsignedInt(cdfhBuffer, 0);
            if (header == 33639248L) {
                int commentLen;
                long commentEnd;
                long firstLoc = ZipCompletionScanner.getUnsignedInt(cdfhBuffer, 32);
                long firstSize = ZipCompletionScanner.getUnsignedInt(cdfhBuffer, 20);
                if (firstLoc == 0L) {
                    if (!ZipCompletionScanner.validateLocalFileRecord(channel, 0L, firstSize)) {
                        return false;
                    }
                } else {
                    long fileFirstLoc = ZipCompletionScanner.scanForLocSig(channel);
                    if (firstLoc != fileFirstLoc) {
                        if (fileFirstLoc == 0L) {
                            return false;
                        }
                        throw new NonScannableZipException(file, false);
                    }
                }
                return (commentEnd = startEndRecord + 22L + (long)(commentLen = ZipCompletionScanner.getUnsignedShort(endDirHeader, 20))) <= channel.size();
            }
            return false;
        }
        catch (EOFException eof) {
            return false;
        }
    }

    private static boolean scanForEndSig(File file, FileChannel channel) throws IOException, NonScannableZipException {
        long channelPos;
        ByteBuffer bb = ZipCompletionScanner.getByteBuffer(4096);
        long start = channel.size();
        long end = Math.max(0L, start - 65558L);
        long lastChannelPos = channelPos = Math.max(0L, start - 4096L);
        boolean firstRead = true;
        while (lastChannelPos >= end) {
            ZipCompletionScanner.read(bb, channel, channelPos);
            int actualRead = bb.limit();
            if (firstRead) {
                long expectedRead = Math.min(4096L, start);
                if ((long)actualRead > expectedRead) {
                    return false;
                }
                firstRead = false;
            }
            int bufferPos = actualRead - 1;
            block5: while (bufferPos >= 4) {
                int patternPos;
                for (patternPos = 3; patternPos >= 0 && ENDSIG_PATTERN[patternPos] == bb.get(bufferPos - patternPos); --patternPos) {
                }
                switch (patternPos) {
                    case -1: {
                        long startEndRecord = channelPos + (long)bufferPos - 4L + 1L;
                        if (ZipCompletionScanner.validateEndRecord(file, channel, startEndRecord)) {
                            return true;
                        }
                        bufferPos -= 4;
                        continue block5;
                    }
                    case 3: {
                        int idx = bb.get(bufferPos - patternPos) - -128;
                        bufferPos -= END_BAD_BYTE_SKIP[idx];
                        continue block5;
                    }
                }
                bufferPos -= 4;
            }
            if (channelPos <= (long)bufferPos) break;
            lastChannelPos = channelPos;
            channelPos -= Math.min(channelPos - (long)bufferPos, 4096L - (long)bufferPos);
        }
        return false;
    }

    private static long scanForLocSig(FileChannel channel) throws IOException {
        channel.position(0L);
        ByteBuffer bb = ZipCompletionScanner.getByteBuffer(4096);
        long end = channel.size();
        while (channel.position() <= end) {
            ZipCompletionScanner.read(bb, channel);
            int bufferPos = 0;
            block5: while (bufferPos <= bb.limit() - 4) {
                int patternPos;
                for (patternPos = 3; patternPos >= 0 && LOCSIG_PATTERN[patternPos] == bb.get(bufferPos + patternPos); --patternPos) {
                }
                switch (patternPos) {
                    case -1: {
                        long startLocRecord = channel.position() - (long)bb.limit() + (long)bufferPos;
                        long currentPos = channel.position();
                        if (ZipCompletionScanner.validateLocalFileRecord(channel, startLocRecord, -1L)) {
                            return startLocRecord;
                        }
                        channel.position(currentPos);
                        bufferPos += 4;
                        continue block5;
                    }
                    case 3: {
                        int idx = bb.get(bufferPos + patternPos) - -128;
                        bufferPos += LOC_BAD_BYTE_SKIP[idx];
                        continue block5;
                    }
                }
                bufferPos += 4;
            }
        }
        return -1L;
    }

    private static boolean validateLocalFileRecord(FileChannel channel, long startLocRecord, long compressedSize) throws IOException {
        ByteBuffer lfhBuffer = ZipCompletionScanner.getByteBuffer(30);
        ZipCompletionScanner.read(lfhBuffer, channel, startLocRecord);
        if (lfhBuffer.limit() < 30 || ZipCompletionScanner.getUnsignedInt(lfhBuffer, 0) != 67324752L) {
            return false;
        }
        if (compressedSize == -1L) {
            return true;
        }
        int fnLen = ZipCompletionScanner.getUnsignedShort(lfhBuffer, 26);
        int extFieldLen = ZipCompletionScanner.getUnsignedShort(lfhBuffer, 28);
        long nextSigPos = startLocRecord + 30L + compressedSize + (long)fnLen + (long)extFieldLen;
        ZipCompletionScanner.read(lfhBuffer, channel, nextSigPos);
        long header = ZipCompletionScanner.getUnsignedInt(lfhBuffer, 0);
        return header == 67324752L || header == 134695760L || header == 33639248L;
    }

    private static ByteBuffer getByteBuffer(int capacity) {
        ByteBuffer b = ByteBuffer.allocate(capacity);
        b.order(ByteOrder.LITTLE_ENDIAN);
        return b;
    }

    private static void read(ByteBuffer bb, FileChannel ch) throws IOException {
        bb.clear();
        ch.read(bb);
        bb.flip();
    }

    private static void read(ByteBuffer bb, FileChannel ch, long pos) throws IOException {
        bb.clear();
        ch.read(bb, pos);
        bb.flip();
    }

    private static long getUnsignedInt(ByteBuffer bb, int offset) {
        return (long)bb.getInt(offset) & 0xFFFFFFFFL;
    }

    private static int getUnsignedShort(ByteBuffer bb, int offset) {
        return bb.getShort(offset) & 0xFFFF;
    }

    private static void computeBadByteSkipArray(byte[] pattern, int[] badByteArray) {
        for (int a = 0; a < 256; ++a) {
            badByteArray[a] = pattern.length;
        }
        for (int j = 0; j < pattern.length - 1; ++j) {
            badByteArray[pattern[j] - -128] = pattern.length - j - 1;
        }
    }

    private static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        ZipCompletionScanner.computeBadByteSkipArray(ENDSIG_PATTERN, END_BAD_BYTE_SKIP);
        ZipCompletionScanner.computeBadByteSkipArray(LOCSIG_PATTERN, LOC_BAD_BYTE_SKIP);
    }

    public static class NonScannableZipException
    extends Exception {
        private static final long serialVersionUID = -5794753842070509152L;

        private NonScannableZipException(File file, boolean zip64) {
            super(zip64 ? NonScannableZipException.getZip64Message(file) : NonScannableZipException.getNonStandardMessage(file));
        }

        private static String getNonStandardMessage(File file) {
            return DeploymentScannerLogger.ROOT_LOGGER.invalidZipFileFormat(file.getAbsolutePath());
        }

        private static String getZip64Message(File file) {
            return DeploymentScannerLogger.ROOT_LOGGER.invalidZip64FileFormat(file.getAbsolutePath());
        }
    }
}

