/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.Matchable;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.configuration.cache.XSiteStateTransferMode;
import org.infinispan.configuration.parsing.Element;

public class XSiteStateTransferConfiguration
implements Matchable<XSiteStateTransferConfiguration>,
ConfigurationInfo {
    public static final int DEFAULT_CHUNK_SIZE = 512;
    public static final long DEFAULT_TIMEOUT = TimeUnit.MINUTES.toMillis(20L);
    public static final int DEFAULT_MAX_RETRIES = 30;
    public static final long DEFAULT_WAIT_TIME = TimeUnit.SECONDS.toMillis(2L);
    public static final AttributeDefinition<Integer> CHUNK_SIZE = AttributeDefinition.builder((String)"chunkSize", (Object)512).immutable().build();
    public static final AttributeDefinition<Long> TIMEOUT = AttributeDefinition.builder((String)"timeout", (Object)DEFAULT_TIMEOUT).build();
    public static final AttributeDefinition<Integer> MAX_RETRIES = AttributeDefinition.builder((String)"maxRetries", (Object)30).build();
    public static final AttributeDefinition<Long> WAIT_TIME = AttributeDefinition.builder((String)"waitTime", (Object)DEFAULT_WAIT_TIME).build();
    public static final AttributeDefinition<XSiteStateTransferMode> MODE = AttributeDefinition.builder((String)"mode", (Object)XSiteStateTransferMode.MANUAL).build();
    static final ElementDefinition<XSiteStateTransferConfiguration> ELEMENT_DEFINITION = new DefaultElementDefinition(Element.STATE_TRANSFER.getLocalName());
    private final Attribute<Integer> chunkSize;
    private final Attribute<Long> timeout;
    private final Attribute<Integer> maxRetries;
    private final Attribute<Long> waitTime;
    private final AttributeSet attributes;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(XSiteStateTransferConfiguration.class, new AttributeDefinition[]{CHUNK_SIZE, TIMEOUT, MAX_RETRIES, WAIT_TIME, MODE});
    }

    public ElementDefinition<XSiteStateTransferConfiguration> getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    public XSiteStateTransferConfiguration(AttributeSet attributes) {
        this.attributes = attributes.checkProtection();
        this.chunkSize = attributes.attribute(CHUNK_SIZE);
        this.timeout = attributes.attribute(TIMEOUT);
        this.maxRetries = attributes.attribute(MAX_RETRIES);
        this.waitTime = attributes.attribute(WAIT_TIME);
    }

    public int chunkSize() {
        return (Integer)this.chunkSize.get();
    }

    public long timeout() {
        return (Long)this.timeout.get();
    }

    public int maxRetries() {
        return (Integer)this.maxRetries.get();
    }

    public long waitTime() {
        return (Long)this.waitTime.get();
    }

    public XSiteStateTransferMode mode() {
        return (XSiteStateTransferMode)this.attributes.attribute(MODE).get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XSiteStateTransferConfiguration that = (XSiteStateTransferConfiguration)o;
        return this.attributes.equals((Object)that.attributes);
    }

    public int hashCode() {
        return Objects.hash(this.attributes);
    }

    public String toString() {
        return "XSiteStateTransferConfiguration [attributes=" + this.attributes + "]";
    }

    public AttributeSet attributes() {
        return this.attributes;
    }
}

