/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.application;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.apache.myfaces.shared.util.ClassUtils;

public class TreeStructureManager {
    public Object buildTreeStructureToSave(UIViewRoot viewRoot) {
        return this.internalBuildTreeStructureToSave((UIComponent)viewRoot);
    }

    private TreeStructComponent internalBuildTreeStructureToSave(UIComponent component) {
        TreeStructComponent structComp = new TreeStructComponent(component.getClass().getName(), component.getId());
        if (component.getChildCount() > 0) {
            ArrayList<TreeStructComponent> structChildList = new ArrayList<TreeStructComponent>();
            int childCount = component.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                UIComponent child = (UIComponent)component.getChildren().get(i);
                if (child.isTransient()) continue;
                TreeStructComponent structChild = this.internalBuildTreeStructureToSave(child);
                structChildList.add(structChild);
            }
            TreeStructComponent[] childArray = structChildList.toArray(new TreeStructComponent[structChildList.size()]);
            structComp.setChildren(childArray);
        }
        if (component.getFacetCount() > 0) {
            Map facetMap = component.getFacets();
            ArrayList<Object[]> structFacetList = new ArrayList<Object[]>();
            for (Map.Entry entry : facetMap.entrySet()) {
                UIComponent child = (UIComponent)entry.getValue();
                if (child.isTransient()) continue;
                String facetName = (String)entry.getKey();
                TreeStructComponent structChild = this.internalBuildTreeStructureToSave(child);
                structFacetList.add(new Object[]{facetName, structChild});
            }
            Object[] facetArray = structFacetList.toArray(new Object[structFacetList.size()]);
            structComp.setFacets(facetArray);
        }
        return structComp;
    }

    public UIViewRoot restoreTreeStructure(Object treeStructRoot) {
        if (treeStructRoot instanceof TreeStructComponent) {
            return (UIViewRoot)this.internalRestoreTreeStructure((TreeStructComponent)treeStructRoot, true);
        }
        throw new IllegalArgumentException("TreeStructure of type " + treeStructRoot.getClass().getName() + " is not supported.");
    }

    private UIComponent internalRestoreTreeStructure(TreeStructComponent treeStructComp, boolean checkViewRoot) {
        Object[] facetArray;
        TreeStructComponent[] childArray;
        String compClass = treeStructComp.getComponentClass();
        String compId = treeStructComp.getComponentId();
        UIComponent component = (UIComponent)ClassUtils.newInstance(compClass);
        component.setId(compId);
        if (checkViewRoot && component instanceof UIViewRoot) {
            FacesContext.getCurrentInstance().setViewRoot((UIViewRoot)component);
        }
        if ((childArray = treeStructComp.getChildren()) != null) {
            List childList = component.getChildren();
            int len = childArray.length;
            for (int i = 0; i < len; ++i) {
                UIComponent child = this.internalRestoreTreeStructure(childArray[i], false);
                childList.add(child);
            }
        }
        if ((facetArray = treeStructComp.getFacets()) != null) {
            Map facetMap = component.getFacets();
            int len = facetArray.length;
            for (int i = 0; i < len; ++i) {
                Object[] tuple = (Object[])facetArray[i];
                String facetName = (String)tuple[0];
                TreeStructComponent structChild = (TreeStructComponent)tuple[1];
                UIComponent child = this.internalRestoreTreeStructure(structChild, false);
                facetMap.put(facetName, child);
            }
        }
        return component;
    }

    public static class TreeStructComponent
    implements Serializable {
        private static final long serialVersionUID = 5069109074684737231L;
        private String _componentClass;
        private String _componentId;
        private TreeStructComponent[] _children = null;
        private Object[] _facets = null;

        TreeStructComponent(String componentClass, String componentId) {
            this._componentClass = componentClass;
            this._componentId = componentId;
        }

        public String getComponentClass() {
            return this._componentClass;
        }

        public String getComponentId() {
            return this._componentId;
        }

        void setChildren(TreeStructComponent[] children) {
            this._children = children;
        }

        TreeStructComponent[] getChildren() {
            return this._children;
        }

        Object[] getFacets() {
            return this._facets;
        }

        void setFacets(Object[] facets) {
            this._facets = facets;
        }
    }
}

