/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.mail.extension;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.mail.Session;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ServiceRemoveStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.access.constraint.ApplicationTypeConfig;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.ApplicationTypeAccessConstraintDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.mail.extension.MailExtension;
import org.jboss.as.mail.extension.MailServerDefinition;
import org.jboss.as.mail.extension.MailServerWriteAttributeHandler;
import org.jboss.as.mail.extension.MailSessionAdd;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

class MailSessionDefinition
extends PersistentResourceDefinition {
    static final RuntimeCapability<Void> SESSION_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.mail.session", (boolean)true, Session.class).build();
    private final List<AccessConstraintDefinition> accessConstraints;
    protected static final SimpleAttributeDefinition JNDI_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("jndi-name", ModelType.STRING, false).setAllowExpression(true)).setRestartAllServices()).build();
    protected static final SimpleAttributeDefinition FROM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("from", ModelType.STRING, true).setRestartAllServices()).setAllowExpression(true)).setRequired(false)).build();
    protected static final SimpleAttributeDefinition DEBUG = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("debug", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(ModelNode.FALSE)).setRestartAllServices()).build();
    static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{DEBUG, JNDI_NAME, FROM};
    private static final List<MailServerDefinition> CHILDREN = Arrays.asList(MailServerDefinition.INSTANCE_IMAP, MailServerDefinition.INSTANCE_POP3, MailServerDefinition.INSTANCE_SMTP, MailServerDefinition.INSTANCE_CUSTOM);
    static final MailSessionDefinition INSTANCE = new MailSessionDefinition();

    private MailSessionDefinition() {
        super(new PersistentResourceDefinition.Parameters(MailExtension.MAIL_SESSION_PATH, (ResourceDescriptionResolver)MailExtension.getResourceDescriptionResolver("mail-session")).setAddHandler((OperationStepHandler)MailSessionAdd.INSTANCE).setRemoveHandler((OperationStepHandler)new ServiceRemoveStepHandler(SESSION_CAPABILITY.getCapabilityServiceName(), (AbstractAddStepHandler)MailSessionAdd.INSTANCE)).setCapabilities(new RuntimeCapability[]{SESSION_CAPABILITY}));
        ApplicationTypeConfig atc = new ApplicationTypeConfig("mail", "mail-session");
        this.accessConstraints = new ApplicationTypeAccessConstraintDefinition(atc).wrapAsList();
    }

    public void registerAttributes(ManagementResourceRegistration rootResourceRegistration) {
        MailServerWriteAttributeHandler handler = new MailServerWriteAttributeHandler(ATTRIBUTES);
        for (AttributeDefinition attr : ATTRIBUTES) {
            rootResourceRegistration.registerReadWriteAttribute(attr, null, (OperationStepHandler)handler);
        }
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(ATTRIBUTES);
    }

    protected List<? extends PersistentResourceDefinition> getChildren() {
        return CHILDREN;
    }

    public List<AccessConstraintDefinition> getAccessConstraints() {
        return this.accessConstraints;
    }
}

