/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.HttpUpgradeHandshake;
import io.undertow.util.FlexBase64;
import io.undertow.util.HttpString;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.jboss.as.remoting.logging.RemotingLogger;

public class SimpleHttpUpgradeHandshake
implements HttpUpgradeHandshake {
    private final String keyHeader;
    private final String magicNumber;
    private final String acceptHeader;

    public SimpleHttpUpgradeHandshake(String magicNumber, String keyHeader, String acceptHeader) {
        this.keyHeader = keyHeader;
        this.magicNumber = magicNumber;
        this.acceptHeader = acceptHeader;
    }

    public boolean handleUpgrade(HttpServerExchange exchange) throws IOException {
        String secretKey = exchange.getRequestHeaders().getFirst(this.keyHeader);
        if (secretKey == null) {
            throw RemotingLogger.ROOT_LOGGER.upgradeRequestMissingKey();
        }
        String response = this.createExpectedResponse(this.magicNumber, secretKey);
        exchange.getResponseHeaders().put(HttpString.tryFromString((String)this.acceptHeader), response);
        return true;
    }

    private String createExpectedResponse(String magicNumber, String secretKey) throws IOException {
        try {
            String concat = secretKey + magicNumber;
            MessageDigest digest = MessageDigest.getInstance("SHA1");
            digest.update(concat.getBytes(StandardCharsets.UTF_8));
            byte[] bytes = digest.digest();
            return FlexBase64.encodeString((byte[])bytes, (boolean)false);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
    }
}

