/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.orbportability;

import com.arjuna.orbportability.ORBData;
import com.arjuna.orbportability.ORBType;
import com.arjuna.orbportability.common.opPropertyManager;
import com.arjuna.orbportability.internal.utils.SimpleXMLParser;
import com.arjuna.orbportability.logging.opLogger;

public class ORBInfo {
    private static final String NAME_ELEMENT = "name";
    private static final String VERSION_ELEMENT = "version";
    private static final String CORBA_VERSION_ELEMENT = "corba-version";
    private static final String MAJOR_ELEMENT = "major";
    private static final String MINOR_ELEMENT = "minor";
    private static ORBData _theData = null;
    private static SimpleXMLParser _xml = null;

    public static final String getInfo() {
        return _theData.getORBdata();
    }

    public static final int getOrbEnumValue() {
        return ORBType.getORBEnum(ORBInfo.getOrbName());
    }

    public static final String getOrbName() {
        String name = "";
        try {
            name = _xml.getElementString(NAME_ELEMENT);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return name;
    }

    public static final int getOrbMajorVersion() {
        int majorVersion = -1;
        try {
            SimpleXMLParser versionParser = _xml.getElementParser(VERSION_ELEMENT);
            majorVersion = Integer.parseInt(versionParser.getElementString(MAJOR_ELEMENT));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return majorVersion;
    }

    public static final int getOrbMinorVersion() {
        int minorVersion = -1;
        try {
            SimpleXMLParser versionParser = _xml.getElementParser(VERSION_ELEMENT);
            minorVersion = Integer.parseInt(versionParser.getElementString(MINOR_ELEMENT));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return minorVersion;
    }

    public static final int getCorbaMajorVersion() {
        int majorVersion = -1;
        try {
            SimpleXMLParser versionParser = _xml.getElementParser(CORBA_VERSION_ELEMENT);
            majorVersion = Integer.parseInt(versionParser.getElementString(MAJOR_ELEMENT));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return majorVersion;
    }

    public static final int getCorbaMinorVersion() {
        int minorVersion = -1;
        try {
            SimpleXMLParser versionParser = _xml.getElementParser(CORBA_VERSION_ELEMENT);
            minorVersion = Integer.parseInt(versionParser.getElementString(MINOR_ELEMENT));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return minorVersion;
    }

    static {
        try {
            _theData = opPropertyManager.getOrbPortabilityEnvironmentBean().getOrbData();
            _xml = new SimpleXMLParser(_theData.getORBdata());
        }
        catch (Exception e) {
            opLogger.i18NLogger.fatal_ORBInfo_creationfailed(e);
            throw new ExceptionInInitializerError(e);
        }
    }
}

