/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remotingjmx.protocol.v2;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

class ClientExecutorManager {
    private static final String REMOTING_JMX = "remoting-jmx";
    private static final String CLIENT_THREAD = "client-thread-";
    private static final AtomicInteger THREAD_NUMBER = new AtomicInteger(1);
    private boolean manageExecutor = false;
    private final Executor executor;
    static final ThreadGroup THREAD_GROUP = AccessController.doPrivileged(new PrivilegedAction<ThreadGroup>(){

        @Override
        public ThreadGroup run() {
            ThreadGroup t = Thread.currentThread().getThreadGroup();
            while (t.getParent() != null) {
                t = t.getParent();
            }
            return t;
        }
    });

    ClientExecutorManager(Map<String, ?> environment) {
        if (environment != null && environment.containsKey(Executor.class.getName())) {
            this.executor = (Executor)environment.get(Executor.class.getName());
        } else {
            this.executor = Executors.newCachedThreadPool(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    return new Thread(THREAD_GROUP, r, "remoting-jmx client-thread-" + THREAD_NUMBER.getAndIncrement());
                }
            });
            this.manageExecutor = true;
        }
    }

    void execute(Runnable runnable) {
        this.executor.execute(runnable);
    }

    void close() {
        if (this.manageExecutor && this.executor instanceof ExecutorService) {
            ((ExecutorService)this.executor).shutdown();
        }
    }
}

