/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import java.util.Collection;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.messaging.activemq.MessagingServices;

public interface ActiveMQReloadRequiredHandlers {
    public static boolean isServiceInstalled(OperationContext context) {
        ServiceName serviceName;
        if (context.isNormalServer() && (serviceName = MessagingServices.getActiveMQServiceName(context.getCurrentAddress())) != null) {
            return context.getServiceRegistry(false).getService(serviceName) != null;
        }
        return false;
    }

    public static class WriteAttributeHandler
    extends AbstractWriteAttributeHandler<Void> {
        public WriteAttributeHandler(Collection<? extends AttributeDefinition> definitions) {
            super(definitions.toArray(new AttributeDefinition[definitions.size()]));
        }

        public WriteAttributeHandler(AttributeDefinition ... definitions) {
            super(definitions);
        }

        protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
            return ActiveMQReloadRequiredHandlers.isServiceInstalled(context);
        }

        protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
            if (ActiveMQReloadRequiredHandlers.isServiceInstalled(context)) {
                context.revertReloadRequired();
            }
        }
    }

    public static final class RemoveStepHandler
    extends AbstractRemoveStepHandler {
        private boolean reloadRequired = false;

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            if (ActiveMQReloadRequiredHandlers.isServiceInstalled(context)) {
                context.reloadRequired();
                this.reloadRequired = true;
            }
        }

        protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            if (this.reloadRequired && ActiveMQReloadRequiredHandlers.isServiceInstalled(context)) {
                context.revertReloadRequired();
            }
        }
    }

    public static class AddStepHandler
    extends AbstractAddStepHandler {
        private boolean reloadRequired = false;

        public AddStepHandler(Collection<? extends AttributeDefinition> attributes) {
            super(attributes);
        }

        public AddStepHandler(AttributeDefinition ... attributes) {
            super(attributes);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            if (ActiveMQReloadRequiredHandlers.isServiceInstalled(context)) {
                context.reloadRequired();
                this.reloadRequired = true;
            }
        }

        protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
            if (this.reloadRequired && ActiveMQReloadRequiredHandlers.isServiceInstalled(context)) {
                context.revertReloadRequired();
            }
        }
    }
}

