/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend;

import java.io.Serializable;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.hibernate.search.backend.IndexWorkVisitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.spi.IndexedTypeIdentifier;

public class AddLuceneWork
extends LuceneWork {
    private final Map<String, String> fieldToAnalyzerMap;

    public AddLuceneWork(Serializable id, String idInString, IndexedTypeIdentifier entityType, Document document) {
        this(null, id, idInString, entityType, document, null);
    }

    public AddLuceneWork(String tenantId, Serializable id, String idInString, IndexedTypeIdentifier entityType, Document document) {
        this(tenantId, id, idInString, entityType, document, null);
    }

    public AddLuceneWork(Serializable id, String idInString, IndexedTypeIdentifier entityType, Document document, Map<String, String> fieldToAnalyzerMap) {
        this(null, id, idInString, entityType, document, fieldToAnalyzerMap);
    }

    public AddLuceneWork(String tenantId, Serializable id, String idInString, IndexedTypeIdentifier entityType, Document document, Map<String, String> fieldToAnalyzerMap) {
        super(tenantId, id, idInString, entityType, document);
        this.fieldToAnalyzerMap = fieldToAnalyzerMap;
    }

    @Override
    public Map<String, String> getFieldToAnalyzerMap() {
        return this.fieldToAnalyzerMap;
    }

    @Override
    public <P, R> R acceptIndexWorkVisitor(IndexWorkVisitor<P, R> visitor, P p) {
        return visitor.visitAddWork(this, p);
    }

    public String toString() {
        String tenant = this.getTenantId() == null ? "" : " [" + this.getTenantId() + "] ";
        return "AddLuceneWork" + tenant + ": " + this.getEntityType().getName() + "#" + this.getIdInString();
    }
}

