/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.invocation;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.util.Collection;
import javax.management.MBeanException;
import javax.transaction.Transaction;
import javax.xml.ws.soap.SOAPFaultException;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.webservices.injection.WSComponent;
import org.jboss.as.webservices.logging.WSLogger;
import org.jboss.as.webservices.metadata.model.AbstractEndpoint;
import org.jboss.as.webservices.util.ASHelper;
import org.jboss.invocation.InterceptorContext;
import org.jboss.msc.service.ServiceName;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.EndpointState;
import org.jboss.wsf.spi.deployment.EndpointType;
import org.jboss.wsf.spi.invocation.Invocation;
import org.jboss.wsf.spi.security.SecurityDomainContext;
import org.wildfly.transaction.client.ContextTransactionManager;
import org.wildfly.transaction.client.LocalTransactionContext;

abstract class AbstractInvocationHandler
extends org.jboss.ws.common.invocation.AbstractInvocationHandler {
    private volatile ServiceName componentViewName;
    private volatile ComponentView componentView;
    protected volatile ManagedReference reference;

    AbstractInvocationHandler() {
    }

    public void init(Endpoint endpoint) {
        this.componentViewName = (ServiceName)endpoint.getProperty(AbstractEndpoint.COMPONENT_VIEW_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ComponentView getComponentView() {
        ComponentView cv = this.componentView;
        if (cv == null) {
            AbstractInvocationHandler abstractInvocationHandler = this;
            synchronized (abstractInvocationHandler) {
                cv = this.componentView;
                if (cv == null) {
                    SecurityManager sm = System.getSecurityManager();
                    cv = sm == null ? ASHelper.getMSCService(this.componentViewName, ComponentView.class) : AccessController.doPrivileged(() -> ASHelper.getMSCService(this.componentViewName, ComponentView.class));
                    if (cv == null) {
                        throw WSLogger.ROOT_LOGGER.cannotFindComponentView(this.componentViewName);
                    }
                    this.componentView = cv;
                }
            }
        }
        return cv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Endpoint endpoint, Invocation wsInvocation) throws Exception {
        try {
            if (!EndpointState.STARTED.equals((Object)endpoint.getState())) {
                throw WSLogger.ROOT_LOGGER.endpointAlreadyStopped(endpoint.getShortName());
            }
            SecurityDomainContext securityDomainContext = endpoint.getSecurityDomainContext();
            if (securityDomainContext != null) {
                securityDomainContext.runAs(() -> {
                    this.invokeInternal(endpoint, wsInvocation);
                    return null;
                });
            } else {
                this.invokeInternal(endpoint, wsInvocation);
            }
        }
        catch (Throwable t) {
            this.handleInvocationException(t);
        }
        finally {
            this.onAfterInvocation(wsInvocation);
        }
    }

    public void invokeInternal(Endpoint endpoint, final Invocation wsInvocation) throws Exception {
        boolean isWeldDeployment;
        this.onBeforeInvocation(wsInvocation);
        ComponentView componentView = this.getComponentView();
        Component component = componentView.getComponent();
        boolean forceTargetBean = wsInvocation.getInvocationContext().getProperty("forceTargetBean") != null;
        boolean bl = isWeldDeployment = endpoint.getProperty(AbstractEndpoint.WELD_DEPLOYMENT) == null ? false : (Boolean)endpoint.getProperty(AbstractEndpoint.WELD_DEPLOYMENT);
        if (forceTargetBean || !isWeldDeployment && endpoint.getType() == EndpointType.JAXWS_JSE) {
            this.reference = new ManagedReference(){

                public void release() {
                }

                public Object getInstance() {
                    return wsInvocation.getInvocationContext().getTargetBean();
                }
            };
            if (component instanceof WSComponent) {
                ((WSComponent)component).setReference(this.reference);
            }
        }
        Method method = this.getComponentViewMethod(wsInvocation.getJavaMethod(), componentView.getViewMethods());
        InterceptorContext context = new InterceptorContext();
        this.prepareForInvocation(context, wsInvocation);
        context.setMethod(method);
        context.setParameters(wsInvocation.getArgs());
        context.putPrivateData(Component.class, (Object)component);
        context.putPrivateData(ComponentView.class, (Object)componentView);
        LocalTransactionContext.getCurrent().importProviderTransaction();
        context.setTransaction((Transaction)ContextTransactionManager.getInstance().getTransaction());
        if (forceTargetBean) {
            context.putPrivateData(ManagedReference.class, (Object)this.reference);
        }
        Object retObj = componentView.invoke(context);
        wsInvocation.setReturnValue(retObj);
    }

    protected void prepareForInvocation(InterceptorContext context, Invocation wsInvocation) {
    }

    protected Method getComponentViewMethod(Method seiMethod, Collection<Method> viewMethods) {
        for (Method viewMethod : viewMethods) {
            if (!this.matches(seiMethod, viewMethod)) continue;
            return viewMethod;
        }
        throw new IllegalStateException();
    }

    protected void handleInvocationException(Throwable t) throws Exception {
        if (t instanceof MBeanException) {
            throw ((MBeanException)t).getTargetException();
        }
        if (t instanceof Exception) {
            if (t instanceof InvocationTargetException) {
                throw (Exception)t;
            }
            SOAPFaultException ex = this.findSoapFaultException(t);
            if (ex != null) {
                throw new InvocationTargetException((Throwable)ex);
            }
            throw new InvocationTargetException(t);
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new UndeclaredThrowableException(t);
    }

    protected SOAPFaultException findSoapFaultException(Throwable ex) {
        if (ex instanceof SOAPFaultException) {
            return (SOAPFaultException)ex;
        }
        if (ex.getCause() != null) {
            return this.findSoapFaultException(ex.getCause());
        }
        return null;
    }

    private boolean matches(Method seiMethod, Method viewMethod) {
        Class<?>[] targetParams;
        if (!seiMethod.getName().equals(viewMethod.getName())) {
            return false;
        }
        Class<?>[] sourceParams = seiMethod.getParameterTypes();
        if (sourceParams.length != (targetParams = viewMethod.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < sourceParams.length; ++i) {
            if (sourceParams[i].equals(targetParams[i])) continue;
            return false;
        }
        return true;
    }
}

