/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.process.logging;

import java.io.EOFException;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.net.InetAddress;
import java.net.ServerSocket;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="WFLYPC", length=4)
public interface ProcessLogger
extends BasicLogger {
    public static final ProcessLogger ROOT_LOGGER = (ProcessLogger)Logger.getMessageLogger(ProcessLogger.class, (String)"org.jboss.as.process");
    public static final ProcessLogger CLIENT_LOGGER = (ProcessLogger)Logger.getMessageLogger(ProcessLogger.class, (String)"org.jboss.as.process-controller.client");
    public static final ProcessLogger PROTOCOL_LOGGER = (ProcessLogger)Logger.getMessageLogger(ProcessLogger.class, (String)"org.jboss.as.process.protocol");
    public static final ProcessLogger PROTOCOL_CLIENT_LOGGER = (ProcessLogger)Logger.getMessageLogger(ProcessLogger.class, (String)"org.jboss.as.protocol.client");
    public static final ProcessLogger PROTOCOL_CONNECTION_LOGGER = (ProcessLogger)Logger.getMessageLogger(ProcessLogger.class, (String)"org.jboss.as.protocol.connection");
    public static final ProcessLogger SERVER_LOGGER = (ProcessLogger)Logger.getMessageLogger(ProcessLogger.class, (String)"org.jboss.as.process-controller.server");

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1, value="Attempted to reconnect non-existent process '%s'")
    public void attemptToReconnectNonExistentProcess(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=2, value="Attempted to remove non-existent process '%s'")
    public void attemptToRemoveNonExistentProcess(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=3, value="Attempted to start non-existent process '%s'")
    public void attemptToStartNonExistentProcess(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=4, value="Attempted to stop non-existent process '%s'")
    public void attemptToStopNonExistentProcess(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=5, value="Attempted to register duplicate named process '%s'")
    public void duplicateProcessName(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=6, value="Failed to send authentication key to process '%s': %s")
    public void failedToSendAuthKey(String var1, Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=7, value="Failed to send data bytes to process '%s' input stream")
    public void failedToSendDataBytes(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=8, value="Failed to send reconnect message to process '%s' input stream")
    public void failedToSendReconnect(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=9, value="Failed to start process '%s'")
    public void failedToStartProcess(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=10, value="Failed to write %s message to connection: %s")
    public void failedToWriteMessage(String var1, Throwable var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=11, value="Process '%s' finished with an exit status of %d")
    public void processFinished(String var1, int var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=12, value="Received connection with invalid version from %s")
    public void receivedInvalidVersion(InetAddress var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=13, value="Received unrecognized greeting code 0x%02x from %s")
    public void receivedUnknownGreetingCode(int var1, InetAddress var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=14, value="Received connection with unknown credentials from %s")
    public void receivedUnknownCredentials(InetAddress var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=15, value="Received unknown message with code 0x%02x")
    public void receivedUnknownMessageCode(int var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=16, value="All processes finished; exiting")
    public void shutdownComplete();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=17, value="Shutting down process controller")
    public void shuttingDown();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=18, value="Starting process '%s'")
    public void startingProcess(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=19, value="Stopping process '%s'")
    public void stoppingProcess(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=20, value="Stream processing failed for process '%s': %s")
    public void streamProcessingFailed(String var1, Throwable var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=21, value="Waiting %d seconds until trying to restart process %s.")
    public void waitingToRestart(int var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=22, value="Failed to kill process '%s', trying to destroy the process instead.")
    public void failedToKillProcess(String var1);

    @Message(id=0, value="Usage: %s [args...]%nwhere args include:")
    public String argUsage(String var1);

    @Message(id=0, value="Keep a copy of the persistent domain configuration even if this host is not the Domain Controller. If ignore-unused-configuration is unset in host.xml, then the complete domain configuration will be stored, otherwise the configured value of ignore-unused-configuration will be used.")
    public String argBackup();

    @Message(id=0, value="If this host is not the Domain Controller and cannot contact the Domain Controller at boot, a locally cached copy of the domain configuration is used for boot (if available, see --backup.) The Domain Controller is background polled until it becomes available. Note that starting a host with --cached-dc when the Domain Controller is available will cache a copy of the domain configuration even if --backup is not used.")
    public String argCachedDc();

    @Message(id=0, value="Name of the domain configuration file to use (default is \"domain.xml\") (Same as -c)")
    public String argDomainConfig();

    @Message(id=0, value="Name of the domain configuration file to use (default is \"domain.xml\") (Same as --domain-config)")
    public String argShortDomainConfig();

    @Message(id=0, value="Name of the domain configuration file to use. This differs from '--domain-config', '-c' and '-domain-config' in that the initial file is never overwritten.")
    public String argReadOnlyDomainConfig();

    @Message(id=0, value="Display this message and exit")
    public String argHelp();

    @Message(id=0, value="Address on which the host controller should listen for communication from the process controller")
    public String argInterProcessHcAddress();

    @Message(id=0, value="Port on which the host controller should listen for communication from the process controller")
    public String argInterProcessHcPort();

    @Message(id=0, value="Name of the host configuration file to use (default is \"host.xml\")")
    public String argHostConfig();

    @Message(id=0, value="Name of the host configuration file to use. This differs from '--host-config' in that the initial file is never overwritten.")
    public String argReadOnlyHostConfig();

    @Message(id=0, value="Address on which the process controller listens for communication from processes it controls")
    public String argPcAddress();

    @Message(id=0, value="Port on which the process controller listens for communication from processes it controls")
    public String argPcPort();

    @Message(id=0, value="Load system properties from the given url")
    public String argProperties();

    @Message(id=0, value="Set a system property")
    public String argSystem();

    @Message(id=0, value="Print version and exit")
    public String argVersion();

    @Message(id=0, value="Set system property jboss.bind.address to the given value")
    public String argPublicBindAddress();

    @Message(id=0, value="Set system property jboss.bind.address.<interface> to the given value")
    public String argInterfaceBindAddress();

    @Message(id=0, value="Set system property jboss.default.multicast.address to the given value")
    public String argDefaultMulticastAddress();

    @Message(id=0, value="Set the host controller's running type to ADMIN_ONLY causing it to open administrative interfaces and accept management requests but not start servers or, if this host controller is the master for the domain, accept incoming connections from slave host controllers.")
    public String argAdminOnly();

    @Message(id=0, value="Set system property jboss.domain.master.address to the given value. In a default slave Host Controller config, this is used to configure the address of the master Host Controller.")
    public String argMasterAddress();

    @Message(id=0, value="Set system property jboss.domain.master.port to the given value. In a default slave Host Controller config, this is used to configure the port used for native management communication by the master Host Controller.")
    public String argMasterPort();

    @Message(id=0, value="Runs the server with a security manager installed.")
    public String argSecMgr();

    @Message(id=23, value="No value was provided for argument %s")
    public String noArgValue(String var1);

    @Message(id=25, value="Authentication key must be 24 bytes long")
    public IllegalArgumentException invalidAuthKeyLen();

    @Message(id=29, value="%s length is invalid")
    public IllegalArgumentException invalidLength(String var1);

    @Message(id=30, value="Invalid option: %s")
    public IllegalArgumentException invalidOption(String var1);

    @Message(id=31, value="Command contains a null component")
    public IllegalArgumentException nullCommandComponent();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=33, value="Failed to accept a connection")
    public void failedToAcceptConnection(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=34, value="Failed to close resource %s")
    public void failedToCloseResource(@Cause Throwable var1, Object var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=35, value="Failed to close the server socket %s")
    public void failedToCloseServerSocket(@Cause Throwable var1, ServerSocket var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=36, value="Failed to close a socket")
    public void failedToCloseSocket(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=39, value="Failed to handle incoming connection")
    public void failedToHandleIncomingConnection(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=40, value="Failed to handle socket failure condition")
    public void failedToHandleSocketFailure(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=41, value="Failed to handle socket finished condition")
    public void failedToHandleSocketFinished(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=42, value="Failed to handle socket shut down condition")
    public void failedToHandleSocketShutdown(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=43, value="Failed to read a message")
    public void failedToReadMessage(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=44, value="Leaked a message output stream; cleaning")
    public void leakedMessageOutputStream();

    @Message(id=45, value="Failed to create server thread")
    public IOException failedToCreateServerThread();

    @Message(id=46, value="Failed to read object")
    public IOException failedToReadObject(@Cause Throwable var1);

    @Message(id=47, value="Invalid byte")
    public UTFDataFormatException invalidByte();

    @Message(id=48, value="Invalid byte:%s(%d)")
    public UTFDataFormatException invalidByte(char var1, int var2);

    @Message(id=49, value="Invalid byte token.  Expecting '%s' received '%s'")
    public IOException invalidByteToken(int var1, byte var2);

    @Message(id=50, value="Invalid command byte read: %s")
    public IOException invalidCommandByte(int var1);

    @Message(id=51, value="Invalid start chunk start [%s]")
    public IOException invalidStartChunk(int var1);

    @Message(id=56, value="Read %d bytes.")
    public EOFException readBytes(int var1);

    @Message(id=58, value="Stream closed")
    public IOException streamClosed();

    @Message(id=59, value="Thread creation was refused")
    public IllegalStateException threadCreationRefused();

    @Message(id=60, value="Unexpected end of stream")
    public EOFException unexpectedEndOfStream();

    @Message(id=61, value="Write channel closed")
    public IOException writeChannelClosed();

    @Message(id=62, value="Writes are already shut down")
    public IOException writesAlreadyShutdown();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=63, value="Process '%s' did not complete normal stop within %d ms; attempting to kill process using OS calls")
    public void attemptingToKillProcess(String var1, long var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=64, value="Cannot locate process '%s' -- could not find the 'jps' command")
    public void jpsCommandNotFound(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=65, value="No process identifiable as '%s' could be found")
    public void processNotFound(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=66, value="Multiple processes identifiable as '%s' found; OS level kill cannot be safely performed")
    public void multipleProcessesFound(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=67, value="Process '%s' did not complete normal stop within %d ms; attempting to destroy process using java.lang.Process.destroyForcibly()")
    public void destroyingProcess(String var1, long var2);
}

