/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.jboss.as.cli.gui.CliGuiContext;
import org.jboss.as.cli.gui.ManagementModelNode;
import org.jboss.as.cli.gui.component.BrowsePanel;
import org.jboss.as.cli.gui.component.ListEditor;
import org.jboss.as.cli.gui.component.WordWrapLabel;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public class OperationDialog
extends JDialog {
    private CliGuiContext cliGuiCtx;
    private ManagementModelNode node;
    private String opName;
    private SortedSet<RequestProp> props;

    public OperationDialog(CliGuiContext cliGuiCtx, ManagementModelNode node, String opName, String strDescription, ModelNode requestProperties) {
        super(cliGuiCtx.getMainWindow(), opName, Dialog.ModalityType.APPLICATION_MODAL);
        this.cliGuiCtx = cliGuiCtx;
        this.node = node;
        this.opName = opName;
        try {
            this.setProps(requestProperties);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this.setDefaultCloseOperation(2);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout(10, 10));
        WordWrapLabel opDescription = new WordWrapLabel(strDescription, 400);
        JPanel opDescPanel = new JPanel();
        opDescPanel.add(opDescription);
        contentPane.add((Component)opDescPanel, "North");
        contentPane.add((Component)this.makeInputPanel(), "Center");
        contentPane.add((Component)this.makeButtonPanel(), "South");
        this.pack();
        this.setResizable(true);
    }

    @Override
    public void setVisible(boolean isVisible) {
        if (this.node.isLeaf()) {
            for (RequestProp prop : this.props) {
                if (!prop.getName().equals("value")) continue;
                prop.getValueComponent().requestFocus();
            }
        }
        super.setVisible(isVisible);
    }

    public void setValue(String propName, Object value) {
        for (RequestProp prop : this.props) {
            if (!prop.getName().equals(propName)) continue;
            JComponent valComp = prop.getValueComponent();
            if (valComp instanceof JTextComponent) {
                ((JTextComponent)valComp).setText(value.toString());
            }
            if (valComp instanceof AbstractButton) {
                ((AbstractButton)valComp).setSelected((Boolean)value);
            }
            if (valComp instanceof JComboBox) {
                ((JComboBox)valComp).setSelectedItem(value);
            }
            return;
        }
    }

    private void setProps(ModelNode requestProperties) throws Exception {
        this.props = new TreeSet<RequestProp>();
        if (this.opName.equals("add")) {
            ManagementModelNode.UserObject usrObj = (ManagementModelNode.UserObject)this.node.getUserObject();
            this.props.add(new RequestProp("/" + usrObj.getName() + "=<name>/", "Resource name for the new " + usrObj.getName(), true, ModelType.STRING));
        }
        if (this.opName.equals("write-attribute") && this.node.isLeaf()) {
            ModelNode nameNode = requestProperties.get("name");
            nameNode.get("type").set(ModelType.UNDEFINED);
            ManagementModelNode.UserObject usrObj = (ManagementModelNode.UserObject)this.node.getUserObject();
            ModelNode nameNodeValue = new ModelNode();
            nameNodeValue.set(usrObj.getName());
            this.props.add(new RequestProp("name", requestProperties.get("name"), nameNodeValue));
            ModelNode rscDesc = this.cliGuiCtx.getExecutor().doCommand(this.node.addressPath() + ":read-resource-description");
            ModelNode valueNode = rscDesc.get(new String[]{"result", "attributes", usrObj.getName()});
            valueNode.get("required").set(false);
            ModelNode valueNodeValue = usrObj.getBackingNode().get(usrObj.getName());
            this.props.add(new RequestProp("value", valueNode, valueNodeValue));
            return;
        }
        for (Property prop : requestProperties.asPropertyList()) {
            this.props.add(new RequestProp(prop.getName(), prop.getValue(), null));
        }
    }

    private JScrollPane makeInputPanel() {
        boolean hasRequiredFields = false;
        JPanel inputPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbConst = new GridBagConstraints();
        gbConst.anchor = 17;
        gbConst.insets = new Insets(5, 5, 5, 5);
        for (RequestProp prop : this.props) {
            JLabel label = prop.getLabel();
            gbConst.gridwidth = 1;
            inputPanel.add((Component)label, gbConst);
            inputPanel.add(Box.createHorizontalStrut(5));
            JComponent comp = prop.getValueComponent();
            gbConst.gridwidth = 0;
            inputPanel.add((Component)comp, gbConst);
            if (!prop.isRequired) continue;
            hasRequiredFields = true;
        }
        if (hasRequiredFields) {
            inputPanel.add(new JLabel(" * = Required Field"));
        }
        return new JScrollPane(inputPanel);
    }

    private JPanel makeButtonPanel() {
        JPanel buttonPanel = new JPanel();
        JButton ok = new JButton("OK");
        ok.addActionListener(new SetOperationActionListener());
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                OperationDialog.this.dispose();
            }
        });
        buttonPanel.add(ok);
        buttonPanel.add(cancel);
        return buttonPanel;
    }

    private class RequestProp
    implements Comparable {
        private final String name;
        private ModelNode props;
        private ModelType type;
        private String description;
        private boolean isRequired = false;
        private boolean nillable = false;
        private boolean expressionsAllowed = false;
        private ModelNode defaultValue = null;
        private ModelNode value = null;
        private JLabel label;
        private JComponent valueComponent;
        private boolean isResourceName = false;

        public RequestProp(String name, String description, boolean required, ModelType type) {
            this.name = name;
            this.props = new ModelNode();
            this.description = description;
            this.type = type;
            this.isRequired = required;
            this.isResourceName = true;
            this.setInputComponent();
            this.setInputComponentValue();
        }

        public RequestProp(String name, ModelNode props, ModelNode value) {
            this.name = name;
            this.props = props;
            this.value = value;
            this.type = props.get("type").asType();
            if (props.hasDefined("description")) {
                this.description = props.get("description").asString();
            }
            if (props.hasDefined("required")) {
                this.isRequired = props.get("required").asBoolean();
            }
            if (props.hasDefined("nillable")) {
                this.nillable = props.get("nillable").asBoolean();
            }
            if (props.hasDefined("expressions-allowed")) {
                this.expressionsAllowed = props.get("expressions-allowed").asBoolean();
            }
            if (props.hasDefined("default")) {
                this.defaultValue = props.get("default");
            }
            this.setInputComponent();
            this.setInputComponentValue();
        }

        public String getName() {
            return this.name;
        }

        public JComponent getValueComponent() {
            return this.valueComponent;
        }

        public JLabel getLabel() {
            return this.label;
        }

        public ModelNode getDefaultValue() {
            return this.defaultValue;
        }

        public String getValueAsString() {
            if (this.valueComponent instanceof JLabel) {
                return ((JLabel)this.valueComponent).getText();
            }
            if (this.valueComponent instanceof JTextComponent) {
                return ((JTextComponent)this.valueComponent).getText();
            }
            if (this.valueComponent instanceof AbstractButton) {
                return Boolean.toString(((AbstractButton)this.valueComponent).isSelected());
            }
            if (this.valueComponent instanceof JComboBox) {
                return ((JComboBox)this.valueComponent).getSelectedItem().toString();
            }
            if (this.valueComponent instanceof ListEditor) {
                ModelNode list = ((ListEditor)this.valueComponent).getValue();
                if (list.isDefined()) {
                    return list.asString();
                }
                return "";
            }
            if (this.valueComponent instanceof JLabel) {
                return ((JLabel)this.valueComponent).getText();
            }
            if (this.valueComponent instanceof BrowsePanel) {
                return ((BrowsePanel)this.valueComponent).getText();
            }
            return null;
        }

        private void setInputComponent() {
            this.label = this.makeLabel();
            if (this.type == ModelType.BOOLEAN && !this.expressionsAllowed) {
                this.valueComponent = new JCheckBox(this.makeLabelString(false));
                this.valueComponent.setToolTipText(this.description);
                this.label = new JLabel();
            } else if (this.type == ModelType.UNDEFINED) {
                JLabel jLabel = new JLabel();
                this.valueComponent = jLabel;
            } else if (this.props.get("allowed").isDefined()) {
                JComboBox comboBox = this.makeJComboBox(this.props.get("allowed").asList());
                this.valueComponent = comboBox;
            } else if (this.type == ModelType.LIST) {
                ListEditor listEditor = new ListEditor(OperationDialog.this);
                this.valueComponent = listEditor;
            } else if (this.type == ModelType.BYTES) {
                this.valueComponent = new BrowsePanel(OperationDialog.this);
            } else {
                JTextField textField = new JTextField(30);
                this.valueComponent = textField;
            }
        }

        private void setInputComponentValue() {
            ModelNode valueToSet = this.defaultValue;
            if (this.value != null) {
                valueToSet = this.value;
            }
            if (valueToSet == null) {
                return;
            }
            if (this.valueComponent instanceof JLabel) {
                ((JLabel)this.valueComponent).setText(valueToSet.asString());
            }
            if (this.valueComponent instanceof ListEditor) {
                ((ListEditor)this.valueComponent).setValue(valueToSet);
            }
            if (!valueToSet.isDefined()) {
                return;
            }
            if (this.valueComponent instanceof JTextComponent) {
                ((JTextComponent)this.valueComponent).setText(valueToSet.asString());
            }
            if (this.valueComponent instanceof JCheckBox) {
                ((JCheckBox)this.valueComponent).setSelected(valueToSet.asBoolean());
            }
            if (this.valueComponent instanceof JComboBox) {
                ((JComboBox)this.valueComponent).setSelectedItem(valueToSet.asString());
            }
            if (this.valueComponent instanceof BrowsePanel) {
                ((BrowsePanel)this.valueComponent).setText(valueToSet.asString());
            }
        }

        private String makeLabelString(boolean addColon) {
            String labelString = this.name;
            if (addColon) {
                labelString = labelString + ":";
            }
            if (this.isRequired) {
                labelString = labelString + " *";
            }
            return labelString;
        }

        private JLabel makeLabel() {
            JLabel label = new JLabel(this.makeLabelString(true));
            label.setToolTipText(this.description);
            return label;
        }

        private JComboBox makeJComboBox(List<ModelNode> values) {
            Vector<String> valueVector = new Vector<String>(values.size());
            if (!this.isRequired) {
                valueVector.add("");
            }
            for (ModelNode node : values) {
                valueVector.add(node.asString());
            }
            return new JComboBox(valueVector);
        }

        public int compareTo(Object t) {
            if (this.equals(t)) {
                return 0;
            }
            if (this.isResourceName) {
                return -1;
            }
            RequestProp compareTo = (RequestProp)t;
            if (this.isRequired && compareTo.isRequired) {
                return 1;
            }
            if (this.isRequired) {
                return -1;
            }
            return 1;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof RequestProp)) {
                return false;
            }
            RequestProp compareTo = (RequestProp)obj;
            return this.name.equals(compareTo.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    private class SetOperationActionListener
    implements ActionListener {
        private SetOperationActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            String addressPath = OperationDialog.this.node.addressPath();
            if (OperationDialog.this.opName.equals("add")) {
                ManagementModelNode.UserObject usrObj = (ManagementModelNode.UserObject)OperationDialog.this.node.getUserObject();
                ManagementModelNode parent = (ManagementModelNode)OperationDialog.this.node.getParent();
                RequestProp resourceProp = (RequestProp)OperationDialog.this.props.first();
                String value = resourceProp.getValueAsString();
                value = ManagementModelNode.escapeAddressElement(value);
                addressPath = parent.addressPath() + usrObj.getName() + "=" + value + "/";
                OperationDialog.this.props.remove(resourceProp);
            }
            StringBuilder command = new StringBuilder();
            command.append(addressPath);
            command.append(":");
            command.append(OperationDialog.this.opName);
            this.addRequestProps(command, OperationDialog.this.props);
            JTextComponent cmdText = OperationDialog.this.cliGuiCtx.getCommandLine().getCmdText();
            cmdText.setText(command.toString());
            OperationDialog.this.dispose();
            cmdText.requestFocus();
        }

        private void addRequestProps(StringBuilder command, SortedSet<RequestProp> reqProps) {
            boolean addedProps = false;
            command.append("(");
            for (RequestProp prop : reqProps) {
                ModelNode defaultValue;
                String submittedValue = prop.getValueAsString();
                if (submittedValue == null || submittedValue.equals("") || prop.type == ModelType.BOOLEAN && !prop.expressionsAllowed && (defaultValue = prop.getDefaultValue()) != null && defaultValue.asBoolean() == Boolean.parseBoolean(submittedValue)) continue;
                addedProps = true;
                command.append(prop.getName());
                command.append("=");
                command.append(submittedValue);
                command.append(",");
            }
            if (addedProps) {
                command.replace(command.length() - 1, command.length(), ")");
            } else {
                command.deleteCharAt(command.length() - 1);
            }
        }
    }
}

