/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.config.hosts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.sshd.client.config.hosts.HostConfigEntry;
import org.apache.sshd.client.config.hosts.HostPatternValue;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;

public abstract class HostPatternsHolder {
    public static final char WILDCARD_PATTERN = '*';
    public static final String ALL_HOSTS_PATTERN = String.valueOf('*');
    public static final char SINGLE_CHAR_PATTERN = '?';
    public static final char NEGATION_CHAR_PATTERN = '!';
    public static final String PATTERN_CHARS = new String(new char[]{'*', '?', '!'});
    public static final char PORT_VALUE_DELIMITER = ':';
    public static final char NON_STANDARD_PORT_PATTERN_ENCLOSURE_START_DELIM = '[';
    public static final char NON_STANDARD_PORT_PATTERN_ENCLOSURE_END_DELIM = ']';
    private Collection<HostPatternValue> patterns = new LinkedList<HostPatternValue>();

    protected HostPatternsHolder() {
    }

    public Collection<HostPatternValue> getPatterns() {
        return this.patterns;
    }

    public void setPatterns(Collection<HostPatternValue> patterns) {
        this.patterns = patterns;
    }

    public boolean isHostMatch(String host, int port) {
        return HostPatternsHolder.isHostMatch(host, port, this.getPatterns());
    }

    public static boolean isSpecificHostPattern(String pattern) {
        if (GenericUtils.isEmpty(pattern)) {
            return false;
        }
        for (int index = 0; index < PATTERN_CHARS.length(); ++index) {
            char ch = PATTERN_CHARS.charAt(index);
            if (pattern.indexOf(ch) < 0) continue;
            return false;
        }
        return true;
    }

    public static List<HostConfigEntry> findMatchingEntries(String host, HostConfigEntry ... entries) {
        if (GenericUtils.isEmpty(host) || GenericUtils.isEmpty(entries)) {
            return Collections.emptyList();
        }
        return HostPatternsHolder.findMatchingEntries(host, Arrays.asList(entries));
    }

    public static List<HostConfigEntry> findMatchingEntries(String host, Collection<? extends HostConfigEntry> entries) {
        if (GenericUtils.isEmpty(host) || GenericUtils.isEmpty(entries)) {
            return Collections.emptyList();
        }
        ArrayList<HostConfigEntry> matches = null;
        for (HostConfigEntry hostConfigEntry : entries) {
            if (!hostConfigEntry.isHostMatch(host, 0)) continue;
            if (matches == null) {
                matches = new ArrayList<HostConfigEntry>(entries.size());
            }
            matches.add(hostConfigEntry);
        }
        if (matches == null) {
            return Collections.emptyList();
        }
        return matches;
    }

    public static boolean isHostMatch(String host, int port, Collection<HostPatternValue> patterns) {
        if (GenericUtils.isEmpty(patterns)) {
            return false;
        }
        boolean matchFound = false;
        for (HostPatternValue pv : patterns) {
            boolean negated = pv.isNegated();
            if (matchFound && !negated || !HostPatternsHolder.isHostMatch(host, pv.getPattern()) || !HostPatternsHolder.isPortMatch(port, pv.getPort())) continue;
            if (negated) {
                return false;
            }
            matchFound = true;
        }
        return matchFound;
    }

    public static boolean isPortMatch(int port1, int port2) {
        return SshConstants.TO_EFFECTIVE_PORT.applyAsInt(port1) == SshConstants.TO_EFFECTIVE_PORT.applyAsInt(port2);
    }

    public static boolean isHostMatch(String host, Pattern pattern) {
        if (GenericUtils.isEmpty(host) || pattern == null) {
            return false;
        }
        Matcher m = pattern.matcher(host);
        return m.matches();
    }

    public static List<HostPatternValue> parsePatterns(CharSequence ... patterns) {
        return HostPatternsHolder.parsePatterns(GenericUtils.isEmpty(patterns) ? Collections.emptyList() : Arrays.asList(patterns));
    }

    public static List<HostPatternValue> parsePatterns(Collection<? extends CharSequence> patterns) {
        if (GenericUtils.isEmpty(patterns)) {
            return Collections.emptyList();
        }
        ArrayList<HostPatternValue> result = new ArrayList<HostPatternValue>(patterns.size());
        for (CharSequence charSequence : patterns) {
            result.add(ValidateUtils.checkNotNull(HostPatternsHolder.toPattern(charSequence), "No pattern for %s", (Object)charSequence));
        }
        return result;
    }

    public static HostPatternValue toPattern(CharSequence patternString) {
        String pattern = GenericUtils.replaceWhitespaceAndTrim(Objects.toString(patternString, null));
        if (GenericUtils.isEmpty(pattern)) {
            return null;
        }
        int patternLen = pattern.length();
        int port = 0;
        StringBuilder sb = new StringBuilder(patternLen);
        if (pattern.charAt(0) == '[') {
            int pos = GenericUtils.lastIndexOf(pattern, ':');
            ValidateUtils.checkTrue(pos > 0, "Missing non-standard port value delimiter in %s", (Object)pattern);
            ValidateUtils.checkTrue(pos < patternLen - 1, "Missing non-standard port value number in %s", (Object)pattern);
            ValidateUtils.checkTrue(pattern.charAt(pos - 1) == ']', "Invalid non-standard port value host pattern enclosure delimiters in %s", (Object)pattern);
            String csPort = pattern.substring(pos + 1, patternLen);
            port = Integer.parseInt(csPort);
            ValidateUtils.checkTrue(port > 0 && port <= 65535, "Invalid non-start port value (%d) in %s", port, pattern);
            pattern = pattern.substring(1, pos - 1);
            patternLen = pattern.length();
        }
        boolean negated = false;
        block6: for (int curPos = 0; curPos < patternLen; ++curPos) {
            char ch = pattern.charAt(curPos);
            ValidateUtils.checkTrue(HostPatternsHolder.isValidPatternChar(ch), "Invalid host pattern char in %s", (Object)pattern);
            switch (ch) {
                case '.': {
                    sb.append('\\').append(ch);
                    continue block6;
                }
                case '?': {
                    sb.append('.');
                    continue block6;
                }
                case '*': {
                    sb.append(".*");
                    continue block6;
                }
                case '!': {
                    ValidateUtils.checkTrue(!negated, "Double negation in %s", (Object)pattern);
                    ValidateUtils.checkTrue(curPos == 0, "Negation must be 1st char: %s", (Object)pattern);
                    negated = true;
                    continue block6;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return new HostPatternValue(Pattern.compile(sb.toString(), 2), port, negated);
    }

    public static boolean isValidPatternChar(char ch) {
        if (ch <= ' ' || ch >= '~') {
            return false;
        }
        if (ch >= 'a' && ch <= 'z') {
            return true;
        }
        if (ch >= 'A' && ch <= 'Z') {
            return true;
        }
        if (ch >= '0' && ch <= '9') {
            return true;
        }
        if ("-_.:%".indexOf(ch) >= 0) {
            return true;
        }
        return PATTERN_CHARS.indexOf(ch) >= 0;
    }
}

