/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.server.dispatcher;

import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.clustering.function.Consumers;
import org.jboss.as.clustering.function.Functions;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.server.Services;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ModularClassResolver;
import org.jboss.marshalling.ObjectTable;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jgroups.JChannel;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;
import org.wildfly.clustering.jgroups.spi.JGroupsRequirement;
import org.wildfly.clustering.marshalling.jboss.DynamicClassTable;
import org.wildfly.clustering.marshalling.jboss.ExternalizerObjectTable;
import org.wildfly.clustering.marshalling.jboss.JBossByteBufferMarshaller;
import org.wildfly.clustering.marshalling.jboss.MarshallingConfigurationRepository;
import org.wildfly.clustering.marshalling.jboss.SimpleMarshallingConfigurationRepository;
import org.wildfly.clustering.marshalling.protostream.ClassLoaderMarshaller;
import org.wildfly.clustering.marshalling.protostream.ModuleClassLoaderMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamByteBufferMarshaller;
import org.wildfly.clustering.marshalling.protostream.SerializationContextBuilder;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshaller;
import org.wildfly.clustering.server.infinispan.dispatcher.AutoCloseableCommandDispatcherFactory;
import org.wildfly.clustering.server.infinispan.dispatcher.ChannelCommandDispatcherFactory;
import org.wildfly.clustering.server.infinispan.dispatcher.ChannelCommandDispatcherFactoryConfiguration;
import org.wildfly.clustering.service.AsyncServiceConfigurator;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SimpleServiceNameProvider;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ChannelCommandDispatcherFactoryServiceConfigurator
extends SimpleServiceNameProvider
implements CapabilityServiceConfigurator,
ChannelCommandDispatcherFactoryConfiguration,
Supplier<AutoCloseableCommandDispatcherFactory>,
Function<ClassLoader, ByteBufferMarshaller>,
Predicate<ByteBuffer> {
    private final String group;
    private volatile SupplierDependency<ChannelFactory> channelFactory;
    private volatile SupplierDependency<JChannel> channel;
    private volatile SupplierDependency<Module> module;
    private volatile Supplier<ModuleLoader> loader;
    private volatile Duration timeout = Duration.ofMinutes(1L);

    public ChannelCommandDispatcherFactoryServiceConfigurator(ServiceName name, String group) {
        super(name);
        this.group = group;
    }

    @Override
    public AutoCloseableCommandDispatcherFactory get() {
        return new ChannelCommandDispatcherFactory((ChannelCommandDispatcherFactoryConfiguration)this);
    }

    public ServiceConfigurator configure(CapabilityServiceSupport support) {
        this.channel = new ServiceSupplierDependency(JGroupsRequirement.CHANNEL.getServiceName(support, this.group));
        this.channelFactory = new ServiceSupplierDependency(JGroupsRequirement.CHANNEL_SOURCE.getServiceName(support, this.group));
        this.module = new ServiceSupplierDependency(JGroupsRequirement.CHANNEL_MODULE.getServiceName(support, this.group));
        return this;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceBuilder builder = new AsyncServiceConfigurator(this.getServiceName()).build(target);
        this.loader = builder.requires(Services.JBOSS_SERVICE_MODULE_LOADER);
        Consumer factory = new CompositeDependency(new Dependency[]{this.channel, this.channelFactory, this.module}).register(builder).provides(new ServiceName[]{this.getServiceName()});
        FunctionalService service = new FunctionalService(factory, Functions.identity(), (Supplier)this, Consumers.close());
        return builder.setInstance((Service)service).setInitialMode(ServiceController.Mode.PASSIVE);
    }

    public ChannelCommandDispatcherFactoryServiceConfigurator timeout(Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    public Function<ClassLoader, ByteBufferMarshaller> getMarshallerFactory() {
        return this;
    }

    @Override
    public ByteBufferMarshaller apply(ClassLoader loader) {
        ModuleLoader moduleLoader = this.loader.get();
        try {
            return new ProtoStreamByteBufferMarshaller(new SerializationContextBuilder((ClassLoaderMarshaller)new ModuleClassLoaderMarshaller(moduleLoader)).require(loader).build());
        }
        catch (NoSuchElementException e) {
            return new JBossByteBufferMarshaller((MarshallingConfigurationRepository)new SimpleMarshallingConfigurationRepository(MarshallingVersion.class, (Enum)MarshallingVersion.CURRENT, new AbstractMap.SimpleImmutableEntry<ModularClassResolver, ClassLoader>(ModularClassResolver.getInstance((ModuleLoader)moduleLoader), loader)), loader);
        }
    }

    public JChannel getChannel() {
        return (JChannel)this.channel.get();
    }

    public ByteBufferMarshaller getMarshaller() {
        return new ProtoStreamByteBufferMarshaller(new SerializationContextBuilder((ClassLoaderMarshaller)new ModuleClassLoaderMarshaller(this.loader.get())).load((ClassLoader)((Module)this.module.get()).getClassLoader()).build());
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public Predicate<ByteBuffer> getUnknownForkPredicate() {
        return this;
    }

    @Override
    public boolean test(ByteBuffer buffer) {
        return ((ChannelFactory)this.channelFactory.get()).isUnknownForkResponse(buffer);
    }

    static enum MarshallingVersion implements Function<Map.Entry<ClassResolver, ClassLoader>, MarshallingConfiguration>
    {
        VERSION_1{

            @Override
            public MarshallingConfiguration apply(Map.Entry<ClassResolver, ClassLoader> entry) {
                ClassLoader[] classLoaderArray;
                ClassLoader loader;
                MarshallingConfiguration config = new MarshallingConfiguration();
                ClassLoader userLoader = entry.getValue();
                if (userLoader.equals(loader = WildFlySecurityManager.getClassLoaderPrivileged(ChannelCommandDispatcherFactory.class))) {
                    ClassLoader[] classLoaderArray2 = new ClassLoader[1];
                    classLoaderArray = classLoaderArray2;
                    classLoaderArray2[0] = userLoader;
                } else {
                    ClassLoader[] classLoaderArray3 = new ClassLoader[2];
                    classLoaderArray3[0] = userLoader;
                    classLoaderArray = classLoaderArray3;
                    classLoaderArray3[1] = loader;
                }
                ClassLoader[] loaders = classLoaderArray;
                config.setClassResolver(entry.getKey());
                config.setClassTable((ClassTable)new DynamicClassTable(loaders));
                config.setObjectTable((ObjectTable)new ExternalizerObjectTable(loaders));
                return config;
            }
        };

        static final MarshallingVersion CURRENT;

        static {
            CURRENT = VERSION_1;
        }
    }
}

