/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.logging;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.jms.IllegalStateRuntimeException;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleNotFoundException;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartException;
import org.jboss.weld.exceptions.IllegalArgumentException;

@MessageLogger(projectCode="WFLYMSGAMQ", length=4)
public interface MessagingLogger
extends BasicLogger {
    public static final MessagingLogger ROOT_LOGGER = (MessagingLogger)Logger.getMessageLogger(MessagingLogger.class, (String)"org.wildfly.extension.messaging-activemq");

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1, value="AIO wasn't located on this platform, it will fall back to using pure Java NIO.")
    public void aioInfo();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=2, value="Bound messaging object to jndi name %s")
    public void boundJndiName(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3, value="Exception while stopping Jakarta Messaging server")
    public void errorStoppingJmsServer(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=4, value="Failed to destroy %s: %s")
    public void failedToDestroy(@Cause Throwable var1, String var2, String var3);

    @LogMessage(level=Logger.Level.WARN)
    public void failedToDestroy(String var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5, value="%s caught exception attempting to revert operation %s at address %s")
    public void revertOperationFailed(@Cause Throwable var1, String var2, String var3, PathAddress var4);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=6, value="Unbound messaging object to jndi name %s")
    public void unboundJndiName(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=7, value="Could not close file %s")
    public void couldNotCloseFile(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=8, value="Failed to unbind messaging object bound to jndi name %s in %d %s")
    public void failedToUnbindJndiName(String var1, long var2, String var4);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=11, value="Started %s %s")
    public void startedService(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=12, value="Stopped %s %s")
    public void stoppedService(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=15, value="Ignoring %s property that is not a known property for pooled connection factory.")
    public void unknownPooledConnectionFactoryAttribute(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=16, value="Registered HTTP upgrade for %s protocol handled by %s acceptor")
    public void registeredHTTPUpgradeHandler(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=18, value="No connectors were explicitly defined for the pooled connection factory %s. Using %s as the connector.")
    public void connectorForPooledConnectionFactory(String var1, String var2);

    @Message(id=22, value="Cannot bind a null or empty string as jndi name")
    public IllegalArgumentException cannotBindJndiName();

    @Message(id=25, value="Cannot unbind a null or empty string as jndi name")
    public IllegalArgumentException cannotUnbindJndiName();

    @Message(id=26, value="A child resource of type %1$s already exists; the messaging subsystem only allows a single resource of type %1$s")
    public String childResourceAlreadyExists(String var1);

    @Message(id=27, value="Connector %s not defined")
    public IllegalStateException connectorNotDefined(String var1);

    @Message(id=28, value="Failed to create %s")
    public StartException failedToCreate(@Cause Throwable var1, String var2);

    @Message(id=29, value="Failed to find SocketBinding for broadcast binding: %s")
    public StartException failedToFindBroadcastSocketBinding(String var1);

    @Message(id=30, value="Failed to find SocketBinding for connector: %s")
    public StartException failedToFindConnectorSocketBinding(String var1);

    @Message(id=31, value="Failed to find SocketBinding for discovery binding: %s")
    public StartException failedToFindDiscoverySocketBinding(String var1);

    @Message(id=32, value="Failed to shutdown %s server")
    public RuntimeException failedToShutdownServer(@Cause Throwable var1, String var2);

    @Message(id=33, value="Failed to start service")
    public StartException failedToStartService(@Cause Throwable var1);

    @Message(id=36, value="Illegal value %s for element %s")
    public String illegalValue(Object var1, String var2);

    @Message(id=37, value="Resource is immutable")
    public UnsupportedOperationException immutableResource();

    @Message(id=38, value="%s is invalid")
    public String invalid(Object var1);

    @Message(id=39, value="Attribute %s has unexpected type %s")
    public IllegalStateException invalidAttributeType(String var1, ModelType var2);

    @Message(id=42, value="Service %s is not in state %s, it is in state %s")
    public IllegalStateException invalidServiceState(ServiceName var1, ServiceController.State var2, ServiceController.State var3);

    @Message(id=43, value="JNDI name %s is already registered")
    public String jndiNameAlreadyRegistered(String var1);

    @Message(id=45, value="%s is required")
    public String required(Object var1);

    @Message(id=46, value="Either %s or %s is required")
    public String required(Object var1, Object var2);

    @Message(id=47, value="%s is null")
    public IllegalArgumentException nullVar(String var1);

    @Message(id=50, value="Read support for attribute %s was not properly implemented")
    public IllegalStateException unsupportedAttribute(String var1);

    @Message(id=52, value="Support for operation %s was not properly implemented")
    public IllegalStateException unsupportedOperation(String var1);

    @Message(id=53, value="Runtime handling for %s is not implemented")
    public UnsupportedOperationException unsupportedRuntimeAttribute(String var1);

    @Message(id=54, value="No ActiveMQ Server is available under name %s")
    public OperationFailedException activeMQServerNotInstalled(String var1);

    @Message(id=55, value="Could not parse file %s")
    public DeploymentUnitProcessingException couldNotParseDeployment(String var1, @Cause Throwable var2);

    @Message(id=56, value="Handler cannot handle operation %s")
    public IllegalStateException operationNotValid(String var1);

    @Message(id=57, value="No message destination registered at address %s")
    public String noDestinationRegisteredForAddress(PathAddress var1);

    @Message(id=58, value="SecurityDomainContext has not been set")
    public IllegalStateException securityDomainContextNotSet();

    @Message(id=60, value="Failed to recover %s")
    public OperationFailedException failedToRecover(@Cause Throwable var1, String var2);

    @Message(id=63, value="Resources of type %s cannot be registered")
    public UnsupportedOperationException canNotRegisterResourceOfType(String var1);

    @Message(id=64, value="Resources of type %s cannot be removed")
    public UnsupportedOperationException canNotRemoveResourceOfType(String var1);

    @Message(id=66, value="Resource at the address %s can not be managed, the server is in backup mode")
    public String serverInBackupMode(PathAddress var1);

    @Message(id=67, value="The broadcast group '%s' defines reference to nonexistent connector '%s'. Available connectors '%s'.")
    public OperationFailedException wrongConnectorRefInBroadCastGroup(String var1, String var2, Collection<String> var3);

    @Message(id=68, value="It is not permitted to call this method on injected JMSContext (see Jakarta Messaging 2.0 spec, \u00a712.4.5).")
    public IllegalStateRuntimeException callNotPermittedOnInjectedJMSContext();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=71, value="There is no resource matching the expiry-address %s for the address-settings %s, expired messages from destinations matching this address-setting will be lost!")
    public void noMatchingExpiryAddress(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=72, value="There is no resource matching the dead-letter-address %s for the address-settings %s, undelivered messages from destinations matching this address-setting will be lost!")
    public void noMatchingDeadLetterAddress(String var1, String var2);

    @Message(id=73, value="Can not remove JNDI name %s. The resource must have at least one JNDI name")
    public String canNotRemoveLastJNDIName(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=75, value="AIO wasn't located on this platform, it will fall back to using pure Java NIO. Your platform is Linux, install LibAIO to enable the AIO journal and achieve optimal performance.")
    public void aioInfoLinux();

    @Message(id=76, value="Parameter %s contains duplicate elements [%s]")
    public OperationFailedException duplicateElements(String var1, ModelNode var2);

    @Message(id=77, value="Can not remove unknown entry %s")
    public OperationFailedException canNotRemoveUnknownEntry(String var1);

    @Message(id=78, value="Only one %s child resource is allowed, found children: %s")
    public OperationFailedException onlyOneChildIsAllowed(String var1, Set<String> var2);

    @Message(id=79, value="Indexed child resources can only be registered if the parent resource supports ordered children. The parent of '%s' is not indexed")
    public IllegalStateException indexedChildResourceRegistrationNotAvailable(PathElement var1);

    @Message(id=80, value="Discovery group %s is not defined")
    public StartException discoveryGroupIsNotDefined(String var1);

    @Message(id=81, value="Unsupported type of broadcast group configuration for legacy resource: %s")
    public StartException unsupportedBroadcastGroupConfigurationForLegacy(String var1);

    @Message(id=82, value="Unsupported type of connector factory for legacy resource: %s")
    public StartException unsupportedConnectorFactoryForLegacy(String var1);

    @Message(id=83, value="The %s operation can not be performed: the server must be in %s mode")
    public OperationFailedException managementOperationAllowedOnlyInRunningMode(String var1, RunningMode var2);

    @Message(id=84, value="The server does not define any in-vm connector. One is required to be able to import a journal")
    public OperationFailedException noInVMConnector();

    @Message(id=85, value="Unable to load class %s from module %s")
    public OperationFailedException unableToLoadClassFromModule(String var1, String var2);

    @Message(id=86, value="Unable to load module %s")
    public OperationFailedException unableToLoadModule(String var1, @Cause ModuleLoadException var2);

    @Message(id=87, value="Unable to load connector service factory class: %s")
    public OperationFailedException unableToLoadConnectorServiceFactoryClass(String var1);

    @Message(id=88, value="%s is an invalid value for parameter %s, it should be multiple of %s")
    public OperationFailedException invalidModularParameterValue(long var1, String var3, long var4);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=89, value="Resource at %s is not correctly configured: when its attribute %s is defined, the other attributes %s will not be taken into account")
    public void invalidConfiguration(PathAddress var1, String var2, List<String> var3);

    @Message(id=90, value="The Elytron security domain cannot be null")
    public IllegalArgumentException invalidNullSecurityDomain();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=91, value="Failed to authenticate username %s. Exception message: %s")
    public void failedAuthenticationWithException(@Cause Throwable var1, String var2, String var3);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=92, value="Failed to authenticate username %s: cannot verify username/password pair")
    public void failedAuthentication(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=93, value="Failed to authorize username %s: missing permissions")
    public void failedAuthorization(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=94, value="Unable to detect database dialect from connection metadata or JDBC driver name. Please configure this manually using the 'journal-database' property in your configuration.  Known database dialect strings are %s")
    public void jdbcDatabaseDialectDetectionFailed(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=95, value="Multiple client-mapping found in [%s] socket binding used by ActiveMQ [%s] transport configuration. Using address: [host: %s, port %s]")
    public void multipleClientMappingsFound(String var1, String var2, String var3, int var4);

    @Message(id=96, value="The %s operation can not be performed on a JDBC store journal")
    public OperationFailedException operationNotAllowedOnJdbcStore(String var1);

    @Message(id=97, value="There is no socket-binding or outbound-socket-binding configured with the name %s")
    public OperationFailedException noSocketBinding(String var1);

    @Message(id=98, value="Unable to load module %s - the module or one of its dependencies is missing [%s]")
    public OperationFailedException moduleNotFound(String var1, String var2, @Cause ModuleNotFoundException var3);

    @Message(id=99, value="Creating the remote destination %s failed with error %s")
    public StartException remoteDestinationCreationFailed(String var1, String var2);

    @Message(id=100, value="Deleting the remote destination %s failed with error %s")
    public RuntimeException remoteDestinationDeletionFailed(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=101, value="Invalid value %s for %s, legal values are %s, default value is applied.")
    public void invalidTransactionNameValue(String var1, String var2, Collection<?> var3);

    @Message(id=102, value="HTTP Upgrade request missing Sec-JbossRemoting-Key header")
    public IOException upgradeRequestMissingKey();

    @Message(id=103, value="Broker is not started. It cannot be managed yet.")
    public IllegalStateException brokerNotStarted();

    @Message(id=104, value="Legacy security is no longer supported.")
    public IllegalStateException legacySecurityUnsupported();

    @Message(id=105, value="The %s %s is configured to use socket-binding %s, but this socket binding doesn't have the multicast-address or a multicast-port attributes configured.")
    public OperationFailedException socketBindingMulticastNotSet(String var1, String var2, String var3);

    @Message(id=106, value="The bridge %s didn't deploy.")
    public OperationFailedException failedBridgeDeployment(String var1);
}

