/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.logger;

import java.io.Serializable;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPIllegalStateException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPInternalErrorException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPInvalidFieldException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPNotFoundException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPSecurityException;
import org.apache.activemq.artemis.protocol.amqp.logger.ActiveMQAMQPProtocolMessageBundle;

public class ActiveMQAMQPProtocolMessageBundle_$bundle
implements ActiveMQAMQPProtocolMessageBundle,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final ActiveMQAMQPProtocolMessageBundle_$bundle INSTANCE = new ActiveMQAMQPProtocolMessageBundle_$bundle();
    private static final Locale LOCALE = Locale.ROOT;

    protected ActiveMQAMQPProtocolMessageBundle_$bundle() {
    }

    protected Object readResolve() {
        return INSTANCE;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String targetAddressNotSet$str() {
        return "AMQ119000: target address not set";
    }

    @Override
    public final ActiveMQAMQPInvalidFieldException targetAddressNotSet() {
        ActiveMQAMQPInvalidFieldException result = new ActiveMQAMQPInvalidFieldException(String.format(this.getLoggingLocale(), this.targetAddressNotSet$str(), new Object[0]));
        ActiveMQAMQPProtocolMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String errorCreatingTemporaryQueue$str() {
        return "AMQ119001: error creating temporary queue, {0}";
    }

    @Override
    public final ActiveMQAMQPInternalErrorException errorCreatingTemporaryQueue(String message) {
        ActiveMQAMQPInternalErrorException result = new ActiveMQAMQPInternalErrorException(this._formatMessage(this.errorCreatingTemporaryQueue$str(), message));
        ActiveMQAMQPProtocolMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    private String _formatMessage(String format, Object ... args) {
        MessageFormat formatter = new MessageFormat(format, this.getLoggingLocale());
        return formatter.format(args, new StringBuffer(), new FieldPosition(0)).toString();
    }

    protected String addressDoesntExist$str() {
        return "AMQ119002: target address does not exist";
    }

    @Override
    public final ActiveMQAMQPNotFoundException addressDoesntExist() {
        ActiveMQAMQPNotFoundException result = new ActiveMQAMQPNotFoundException(String.format(this.getLoggingLocale(), this.addressDoesntExist$str(), new Object[0]));
        ActiveMQAMQPProtocolMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String errorFindingTemporaryQueue$str() {
        return "AMQ119003: error finding temporary queue, {0}";
    }

    @Override
    public final ActiveMQAMQPNotFoundException errorFindingTemporaryQueue(String message) {
        ActiveMQAMQPNotFoundException result = new ActiveMQAMQPNotFoundException(this._formatMessage(this.errorFindingTemporaryQueue$str(), message));
        ActiveMQAMQPProtocolMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String errorCreatingConsumer$str() {
        return "AMQ119005: error creating consumer, {0}";
    }

    @Override
    public final ActiveMQAMQPInternalErrorException errorCreatingConsumer(String message) {
        ActiveMQAMQPInternalErrorException result = new ActiveMQAMQPInternalErrorException(this._formatMessage(this.errorCreatingConsumer$str(), message));
        ActiveMQAMQPProtocolMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String errorStartingConsumer$str() {
        return "AMQ119006: error starting consumer, {0}";
    }

    @Override
    public final ActiveMQAMQPIllegalStateException errorStartingConsumer(String message) {
        ActiveMQAMQPIllegalStateException result = new ActiveMQAMQPIllegalStateException(this._formatMessage(this.errorStartingConsumer$str(), message));
        ActiveMQAMQPProtocolMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String errorAcknowledgingMessage$str() {
        return "AMQ119007: error acknowledging message {0}, {1}";
    }

    @Override
    public final ActiveMQAMQPIllegalStateException errorAcknowledgingMessage(String messageID, String message) {
        ActiveMQAMQPIllegalStateException result = new ActiveMQAMQPIllegalStateException(this._formatMessage(this.errorAcknowledgingMessage$str(), messageID, message));
        ActiveMQAMQPProtocolMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String errorCancellingMessage$str() {
        return "AMQ119008: error cancelling message {0}, {1}";
    }

    @Override
    public final ActiveMQAMQPIllegalStateException errorCancellingMessage(String messageID, String message) {
        ActiveMQAMQPIllegalStateException result = new ActiveMQAMQPIllegalStateException(this._formatMessage(this.errorCancellingMessage$str(), messageID, message));
        ActiveMQAMQPProtocolMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String sourceAddressDoesntExist$str() {
        return "AMQ119010: source address does not exist";
    }

    @Override
    public final ActiveMQAMQPNotFoundException sourceAddressDoesntExist() {
        ActiveMQAMQPNotFoundException result = new ActiveMQAMQPNotFoundException(String.format(this.getLoggingLocale(), this.sourceAddressDoesntExist$str(), new Object[0]));
        ActiveMQAMQPProtocolMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String sourceAddressNotSet$str() {
        return "AMQ119011: source address not set";
    }

    @Override
    public final ActiveMQAMQPInvalidFieldException sourceAddressNotSet() {
        ActiveMQAMQPInvalidFieldException result = new ActiveMQAMQPInvalidFieldException(String.format(this.getLoggingLocale(), this.sourceAddressNotSet$str(), new Object[0]));
        ActiveMQAMQPProtocolMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String errorRollingbackCoordinator$str() {
        return "AMQ119012: error rolling back coordinator: {0}";
    }

    @Override
    public final ActiveMQAMQPIllegalStateException errorRollingbackCoordinator(String message) {
        ActiveMQAMQPIllegalStateException result = new ActiveMQAMQPIllegalStateException(this._formatMessage(this.errorRollingbackCoordinator$str(), message));
        ActiveMQAMQPProtocolMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String errorCommittingCoordinator$str() {
        return "AMQ119013: error committing coordinator: {0}";
    }

    @Override
    public final ActiveMQAMQPIllegalStateException errorCommittingCoordinator(String message) {
        ActiveMQAMQPIllegalStateException result = new ActiveMQAMQPIllegalStateException(this._formatMessage(this.errorCommittingCoordinator$str(), message));
        ActiveMQAMQPProtocolMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String txNotFound$str() {
        return "AMQ119014: Transaction not found: xid={0}";
    }

    @Override
    public final ActiveMQAMQPIllegalStateException txNotFound(String xidToString) {
        ActiveMQAMQPIllegalStateException result = new ActiveMQAMQPIllegalStateException(this._formatMessage(this.txNotFound$str(), xidToString));
        ActiveMQAMQPProtocolMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String securityErrorCreatingConsumer$str() {
        return "AMQ119015: not authorized to create consumer, {0}";
    }

    @Override
    public final ActiveMQAMQPSecurityException securityErrorCreatingConsumer(String message) {
        ActiveMQAMQPSecurityException result = new ActiveMQAMQPSecurityException(this._formatMessage(this.securityErrorCreatingConsumer$str(), message));
        ActiveMQAMQPProtocolMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String securityErrorCreatingTempDestination$str() {
        return "AMQ119016: not authorized to create temporary destination, {0}";
    }

    @Override
    public final ActiveMQAMQPSecurityException securityErrorCreatingTempDestination(String message) {
        ActiveMQAMQPSecurityException result = new ActiveMQAMQPSecurityException(this._formatMessage(this.securityErrorCreatingTempDestination$str(), message));
        ActiveMQAMQPProtocolMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String securityErrorCreatingProducer$str() {
        return "AMQ119017: not authorized to create producer, {0}";
    }

    @Override
    public final ActiveMQAMQPSecurityException securityErrorCreatingProducer(String message) {
        ActiveMQAMQPSecurityException result = new ActiveMQAMQPSecurityException(this._formatMessage(this.securityErrorCreatingProducer$str(), message));
        ActiveMQAMQPProtocolMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String missingOfferedCapability$str() {
        return "AMQ119018: link is missing an offered capability declaration {0}";
    }

    @Override
    public final ActiveMQAMQPIllegalStateException missingOfferedCapability(String capability) {
        ActiveMQAMQPIllegalStateException result = new ActiveMQAMQPIllegalStateException(this._formatMessage(this.missingOfferedCapability$str(), capability));
        ActiveMQAMQPProtocolMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String missingBrokerID$str() {
        return "AMQ119019: There is no brokerID defined on the target connection. Connection will be closed.";
    }

    @Override
    public final ActiveMQAMQPIllegalStateException missingBrokerID() {
        ActiveMQAMQPIllegalStateException result = new ActiveMQAMQPIllegalStateException(this.missingBrokerID$str());
        ActiveMQAMQPProtocolMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String brokerConnectionTimeout$str() {
        return "AMQ119020: The Broker Connection Open Callback Has Timed Out.";
    }

    @Override
    public final ActiveMQAMQPIllegalStateException brokerConnectionTimeout() {
        ActiveMQAMQPIllegalStateException result = new ActiveMQAMQPIllegalStateException(this.brokerConnectionTimeout$str());
        ActiveMQAMQPProtocolMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String brokerConnectionRemoteLinkClosed$str() {
        return "AMQ119021: The broker connection had a remote link closed unexpectedly";
    }

    @Override
    public final ActiveMQAMQPIllegalStateException brokerConnectionRemoteLinkClosed() {
        ActiveMQAMQPIllegalStateException result = new ActiveMQAMQPIllegalStateException(this.brokerConnectionRemoteLinkClosed$str());
        ActiveMQAMQPProtocolMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String brokerConnectionMirrorItself$str() {
        return "AMQ119022: The broker connection is trying to connect to itself. Check your configuration.";
    }

    @Override
    public final ActiveMQAMQPIllegalStateException brokerConnectionMirrorItself() {
        ActiveMQAMQPIllegalStateException result = new ActiveMQAMQPIllegalStateException(this.brokerConnectionMirrorItself$str());
        ActiveMQAMQPProtocolMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String senderLinkRefused$str() {
        return "AMQ119023: Sender link refused for address {0}";
    }

    @Override
    public final ActiveMQAMQPIllegalStateException senderLinkRefused(String address) {
        ActiveMQAMQPIllegalStateException result = new ActiveMQAMQPIllegalStateException(this._formatMessage(this.senderLinkRefused$str(), address));
        ActiveMQAMQPProtocolMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String missingDesiredCapability$str() {
        return "AMQ119024: link is missing a desired capability declaration {0}";
    }

    @Override
    public final ActiveMQAMQPIllegalStateException missingDesiredCapability(String capability) {
        ActiveMQAMQPIllegalStateException result = new ActiveMQAMQPIllegalStateException(this._formatMessage(this.missingDesiredCapability$str(), capability));
        ActiveMQAMQPProtocolMessageBundle_$bundle._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }
}

