/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import java.util.Map;
import org.apache.activemq.artemis.api.core.management.ClusterConnectionControl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.messaging.activemq.AbstractActiveMQComponentControlHandler;
import org.wildfly.extension.messaging.activemq.ClusterConnectionDefinition;

public class ClusterConnectionControlHandler
extends AbstractActiveMQComponentControlHandler<ClusterConnectionControl> {
    public static final ClusterConnectionControlHandler INSTANCE = new ClusterConnectionControlHandler();

    private ClusterConnectionControlHandler() {
    }

    @Override
    protected ClusterConnectionControl getActiveMQComponentControl(ActiveMQServer activeMQServer, PathAddress address) {
        String resourceName = address.getLastElement().getValue();
        return (ClusterConnectionControl)ClusterConnectionControl.class.cast(activeMQServer.getManagementService().getResource("clusterconnection." + resourceName));
    }

    @Override
    protected String getDescriptionPrefix() {
        return "cluster-connection";
    }

    @Override
    protected void handleReadAttribute(String attributeName, OperationContext context, ModelNode operation) throws OperationFailedException {
        if (ClusterConnectionDefinition.NODE_ID.getName().equals(attributeName)) {
            ClusterConnectionControl control = (ClusterConnectionControl)this.getActiveMQComponentControl(context, operation, false);
            if (control != null) {
                context.getResult().set(control.getNodeID());
            }
        } else if (ClusterConnectionDefinition.TOPOLOGY.getName().equals(attributeName)) {
            ClusterConnectionControl control = (ClusterConnectionControl)this.getActiveMQComponentControl(context, operation, false);
            if (control != null) {
                context.getResult().set(control.getTopology());
            }
        } else {
            this.unsupportedAttribute(attributeName);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Object handleOperation(String operationName, OperationContext context, ModelNode operation) throws OperationFailedException {
        if ("get-nodes".equals(operationName)) {
            ClusterConnectionControl control = (ClusterConnectionControl)this.getActiveMQComponentControl(context, operation, false);
            try {
                if (control == null) return null;
                Map nodes = control.getNodes();
                ModelNode result = context.getResult();
                result.setEmptyObject();
                for (Map.Entry entry : nodes.entrySet()) {
                    result.get((String)entry.getKey()).set((String)entry.getValue());
                }
                return null;
            }
            catch (Exception e) {
                context.getFailureDescription().set(e.getLocalizedMessage());
                return null;
            }
        } else {
            this.unsupportedOperation(operationName);
        }
        return null;
    }
}

