/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.weld.injection;

import java.io.IOException;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.Bean;
import org.infinispan.protostream.descriptors.WireType;
import org.jboss.weld.Container;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.annotated.enhanced.jlr.EnhancedAnnotatedConstructorImpl;
import org.jboss.weld.annotated.slim.AnnotatedTypeIdentifier;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.annotated.slim.backed.BackedAnnotatedConstructor;
import org.jboss.weld.annotated.slim.backed.BackedAnnotatedType;
import org.jboss.weld.injection.ConstructorInjectionPoint;
import org.jboss.weld.injection.InjectionPointFactory;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.serialization.spi.BeanIdentifier;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

public class ConstructorInjectionPointMarshaller<X>
implements ProtoStreamMarshaller<ConstructorInjectionPoint<X>> {
    private static final int CONSTRUCTOR_INDEX = 1;
    private static final int BEAN_INDEX = 2;

    public Class<? extends ConstructorInjectionPoint<X>> getJavaClass() {
        return ConstructorInjectionPoint.class;
    }

    public ConstructorInjectionPoint<X> readFrom(ProtoStreamReader reader) throws IOException {
        BackedAnnotatedConstructor constructor = null;
        BeanIdentifier beanId = null;
        block4: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    constructor = (BackedAnnotatedConstructor)reader.readObject(BackedAnnotatedConstructor.class);
                    continue block4;
                }
                case 2: {
                    beanId = (BeanIdentifier)reader.readAny(BeanIdentifier.class);
                    continue block4;
                }
            }
            reader.skipField(tag);
        }
        BackedAnnotatedType type = constructor.getDeclaringType();
        AnnotatedTypeIdentifier identifier = (AnnotatedTypeIdentifier)type.getIdentifier();
        BeanManagerImpl manager = Container.instance((AnnotatedTypeIdentifier)identifier).getBeanManager(identifier.getBdaId());
        ClassTransformer transformer = ClassTransformer.instance((BeanManagerImpl)manager);
        Bean bean = beanId != null ? (Bean)((ContextualStore)Container.instance((BeanManagerImpl)manager).services().get(ContextualStore.class)).getContextual(beanId) : null;
        return InjectionPointFactory.silentInstance().createConstructorInjectionPoint(bean, type.getJavaClass(), EnhancedAnnotatedConstructorImpl.of((AnnotatedConstructor)constructor, (EnhancedAnnotatedType)transformer.getEnhancedAnnotatedType((SlimAnnotatedType)type), (ClassTransformer)transformer), manager);
    }

    public void writeTo(ProtoStreamWriter writer, ConstructorInjectionPoint<X> injectionPoint) throws IOException {
        Bean bean;
        BackedAnnotatedConstructor constructor = (BackedAnnotatedConstructor)injectionPoint.getAnnotated();
        if (constructor != null) {
            writer.writeObject(1, (Object)constructor);
        }
        if ((bean = injectionPoint.getBean()) != null) {
            BeanIdentifier beanId = ((ContextualStore)Container.instance((AnnotatedTypeIdentifier)constructor.getDeclaringType().getIdentifier()).services().get(ContextualStore.class)).putIfAbsent((Contextual)bean);
            writer.writeAny(2, (Object)beanId);
        }
    }
}

