/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice.persistence.filestore;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.ejb.ScheduleExpression;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.timerservice.CalendarTimer;
import org.jboss.as.ejb3.timerservice.TimerImpl;
import org.jboss.as.ejb3.timerservice.TimerServiceImpl;
import org.jboss.as.ejb3.timerservice.TimerState;
import org.jboss.as.ejb3.timerservice.persistence.TimeoutMethod;
import org.jboss.marshalling.ByteBufferInput;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class EjbTimerXmlParser_1_0
implements XMLElementReader<List<TimerImpl>> {
    public static final String NAMESPACE = "urn:jboss:wildfly:ejb-timers:1.0";
    private final TimerServiceImpl timerService;
    private final MarshallerFactory factory;
    private final MarshallingConfiguration configuration;
    private final ClassLoader classLoader;

    public EjbTimerXmlParser_1_0(TimerServiceImpl timerService, MarshallerFactory factory, MarshallingConfiguration configuration, ClassLoader classLoader) {
        this.timerService = timerService;
        this.factory = factory;
        this.configuration = configuration;
        this.classLoader = classLoader;
    }

    public void readElement(XMLExtendedStreamReader reader, List<TimerImpl> timers) throws XMLStreamException {
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    switch (reader.getName().getLocalPart()) {
                        case "timer": {
                            this.parseTimer(reader, timers);
                            break block0;
                        }
                        case "calendar-timer": {
                            this.parseCalendarTimer(reader, timers);
                            break block0;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
        }
    }

    private void parseTimer(XMLExtendedStreamReader reader, List<TimerImpl> timers) throws XMLStreamException {
        LoadableElements loadableElements = new LoadableElements();
        TimerImpl.Builder builder = TimerImpl.builder();
        builder.setPersistent(true);
        HashSet<String> required = new HashSet<String>(Arrays.asList("timed-object-id", "timer-id", "initial-date", "repeat-interval", "timer-state"));
        block12: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attr = reader.getAttributeValue(i);
            String attrName = reader.getAttributeLocalName(i);
            required.remove(attrName);
            boolean handled = this.handleCommonAttributes(builder, reader, i);
            if (handled) continue;
            switch (attrName) {
                case "repeat-interval": {
                    builder.setRepeatInterval(Long.parseLong(attr));
                    continue block12;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    try {
                        if (loadableElements.info != null) {
                            builder.setInfo((Serializable)this.deserialize(loadableElements.info));
                        }
                        timers.add(builder.build(this.timerService));
                    }
                    catch (Exception e) {
                        EjbLogger.EJB3_TIMER_LOGGER.timerReinstatementFailed(builder.getTimedObjectId(), builder.getId(), e);
                    }
                    return;
                }
                case 1: {
                    boolean handled = this.handleCommonElements(reader, loadableElements);
                    if (handled) break;
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
        }
    }

    private Object deserialize(String info) throws IOException, ClassNotFoundException {
        byte[] data = Base64.getDecoder().decode(info.trim());
        try (Unmarshaller unmarshaller = this.factory.createUnmarshaller(this.configuration);){
            unmarshaller.start((ByteInput)new ByteBufferInput(ByteBuffer.wrap(data)));
            Object object = unmarshaller.readObject();
            return object;
        }
    }

    private boolean handleCommonElements(XMLExtendedStreamReader reader, LoadableElements builder) throws XMLStreamException {
        boolean handled = false;
        switch (reader.getName().getLocalPart()) {
            case "info": {
                builder.info = reader.getElementText();
                handled = true;
            }
        }
        return handled;
    }

    private void parseCalendarTimer(XMLExtendedStreamReader reader, List<TimerImpl> timers) throws XMLStreamException {
        LoadableElements loadableElements = new LoadableElements();
        CalendarTimer.Builder builder = CalendarTimer.builder();
        builder.setAutoTimer(false).setPersistent(true);
        HashSet<String> required = new HashSet<String>(Arrays.asList("timed-object-id", "timer-id", "timer-state", "schedule-expr-second", "schedule-expr-minute", "schedule-expr-hour", "schedule-expr-day-of-week", "schedule-expr-day-of-month", "schedule-expr-month", "schedule-expr-year"));
        ScheduleExpression scheduleExpression = new ScheduleExpression();
        block36: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attr = reader.getAttributeValue(i);
            String attrName = reader.getAttributeLocalName(i);
            required.remove(attrName);
            boolean handled = this.handleCommonAttributes(builder, reader, i);
            if (handled) continue;
            switch (attrName) {
                case "schedule-expr-second": {
                    scheduleExpression.second(attr);
                    continue block36;
                }
                case "schedule-expr-minute": {
                    scheduleExpression.minute(attr);
                    continue block36;
                }
                case "schedule-expr-hour": {
                    scheduleExpression.hour(attr);
                    continue block36;
                }
                case "schedule-expr-day-of-week": {
                    scheduleExpression.dayOfWeek(attr);
                    continue block36;
                }
                case "schedule-expr-day-of-month": {
                    scheduleExpression.dayOfMonth(attr);
                    continue block36;
                }
                case "schedule-expr-month": {
                    scheduleExpression.month(attr);
                    continue block36;
                }
                case "schedule-expr-year": {
                    scheduleExpression.year(attr);
                    continue block36;
                }
                case "schedule-expr-start-date": {
                    scheduleExpression.start(new Date(Long.parseLong(attr)));
                    continue block36;
                }
                case "schedule-expr-end-date": {
                    scheduleExpression.end(new Date(Long.parseLong(attr)));
                    continue block36;
                }
                case "schedule-expr-timezone": {
                    scheduleExpression.timezone(attr);
                    continue block36;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        builder.setScheduleExpression(scheduleExpression);
        while (reader.hasNext()) {
            block25 : switch (reader.nextTag()) {
                case 2: {
                    try {
                        if (loadableElements.info != null) {
                            builder.setInfo((Serializable)this.deserialize(loadableElements.info));
                        }
                        if (loadableElements.methodName != null) {
                            Method timeoutMethod = CalendarTimer.getTimeoutMethod(new TimeoutMethod(loadableElements.className, loadableElements.methodName, loadableElements.params.toArray(new String[loadableElements.params.size()])), this.classLoader);
                            if (timeoutMethod != null) {
                                builder.setTimeoutMethod(timeoutMethod);
                                timers.add(builder.build(this.timerService));
                            } else {
                                builder.setId("deleted-timer");
                                timers.add(builder.build(this.timerService));
                                EjbLogger.EJB3_TIMER_LOGGER.timerReinstatementFailed(builder.getTimedObjectId(), builder.getId(), null);
                            }
                        } else {
                            timers.add(builder.build(this.timerService));
                        }
                    }
                    catch (Exception e) {
                        EjbLogger.EJB3_TIMER_LOGGER.timerReinstatementFailed(builder.getTimedObjectId(), builder.getId(), e);
                    }
                    return;
                }
                case 1: {
                    boolean handled = this.handleCommonElements(reader, loadableElements);
                    if (handled) break;
                    switch (reader.getName().getLocalPart()) {
                        case "timeout-method": {
                            builder.setAutoTimer(true);
                            this.parseTimeoutMethod(reader, loadableElements);
                            break block25;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
        }
    }

    private void parseTimeoutMethod(XMLExtendedStreamReader reader, LoadableElements loadableElements) throws XMLStreamException {
        HashSet<String> required = new HashSet<String>(Arrays.asList("declaring-class", "name"));
        block18: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attr = reader.getAttributeValue(i);
            String attrName = reader.getAttributeLocalName(i);
            required.remove(attrName);
            switch (attrName) {
                case "declaring-class": {
                    loadableElements.className = attr;
                    continue block18;
                }
                case "name": {
                    loadableElements.methodName = attr;
                    continue block18;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        while (reader.hasNext()) {
            block8 : switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    switch (reader.getName().getLocalPart()) {
                        case "parameter": {
                            this.handleParam(reader, loadableElements);
                            break block8;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
        }
    }

    private void handleParam(XMLExtendedStreamReader reader, LoadableElements loadableElements) throws XMLStreamException {
        HashSet<String> required = new HashSet<String>(Arrays.asList("type"));
        block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attr = reader.getAttributeValue(i);
            String attrName = reader.getAttributeLocalName(i);
            required.remove(attrName);
            switch (attrName) {
                case "type": {
                    loadableElements.params.add(attr);
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
        }
    }

    private boolean handleCommonAttributes(TimerImpl.Builder builder, XMLExtendedStreamReader reader, int i) {
        boolean handled = true;
        String attr = reader.getAttributeValue(i);
        switch (reader.getAttributeLocalName(i)) {
            case "timed-object-id": {
                builder.setTimedObjectId(attr);
                break;
            }
            case "timer-id": {
                builder.setId(attr);
                break;
            }
            case "initial-date": {
                builder.setInitialDate(new Date(Long.parseLong(attr)));
                break;
            }
            case "next-date": {
                builder.setNextDate(new Date(Long.parseLong(attr)));
                break;
            }
            case "timer-state": {
                builder.setTimerState(TimerState.valueOf(attr));
                break;
            }
            case "previous-run": {
                builder.setPreviousRun(new Date(Long.parseLong(attr)));
                break;
            }
            default: {
                handled = false;
            }
        }
        return handled;
    }

    private static class LoadableElements {
        String info;
        String className;
        String methodName;
        final List<String> params = new ArrayList<String>();

        private LoadableElements() {
        }
    }
}

