/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.ejb;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.weld.ejb.StatefulSessionObjectReferenceImpl;
import org.jboss.ejb.client.SessionID;
import org.jboss.msc.service.ServiceName;

public class SerializedStatefulSessionObject
implements Serializable {
    private final String componentServiceName;
    private final SessionID sessionID;
    private final Map<Class<?>, String> serviceNames;

    public SerializedStatefulSessionObject(ServiceName componentServiceName, SessionID sessionID, Map<Class<?>, ServiceName> serviceNames) {
        this.componentServiceName = componentServiceName.getCanonicalName();
        this.sessionID = sessionID;
        HashMap names = new HashMap();
        for (Map.Entry<Class<?>, ServiceName> e : serviceNames.entrySet()) {
            names.put(e.getKey(), e.getValue().getCanonicalName());
        }
        this.serviceNames = names;
    }

    public SerializedStatefulSessionObject(String componentServiceName, SessionID sessionID, Map<Class<?>, String> serviceNames) {
        this.componentServiceName = componentServiceName;
        this.sessionID = sessionID;
        this.serviceNames = serviceNames;
    }

    private Object readResolve() throws ObjectStreamException {
        HashMap names = new HashMap();
        for (Map.Entry<Class<?>, String> e : this.serviceNames.entrySet()) {
            names.put(e.getKey(), ServiceName.parse((String)e.getValue()));
        }
        return new StatefulSessionObjectReferenceImpl(this.sessionID, ServiceName.parse((String)this.componentServiceName), names);
    }

    public String getComponentServiceName() {
        return this.componentServiceName;
    }

    public SessionID getSessionID() {
        return this.sessionID;
    }

    public Map<Class<?>, String> getServiceNames() {
        return this.serviceNames;
    }
}

