/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.internal;

import java.io.Serializable;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.TimestampsCache;
import org.hibernate.cache.spi.TimestampsRegion;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.jboss.logging.Logger;

public class TimestampsCacheEnabledImpl
implements TimestampsCache {
    private static final Logger log = Logger.getLogger(TimestampsCacheEnabledImpl.class);
    private static final boolean DEBUG_ENABLED = log.isDebugEnabled();
    private final TimestampsRegion timestampsRegion;

    public TimestampsCacheEnabledImpl(TimestampsRegion timestampsRegion) {
        this.timestampsRegion = timestampsRegion;
    }

    @Override
    public TimestampsRegion getRegion() {
        return this.timestampsRegion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preInvalidate(String[] spaces, SharedSessionContractImplementor session) {
        SessionFactoryImplementor factory = session.getFactory();
        RegionFactory regionFactory = factory.getCache().getRegionFactory();
        boolean stats = factory.getStatistics().isStatisticsEnabled();
        Long ts = regionFactory.nextTimestamp() + regionFactory.getTimeout();
        for (String space : spaces) {
            if (DEBUG_ENABLED) {
                log.debugf("Pre-invalidating space [%s], timestamp: %s", (Object)space, (Object)ts);
            }
            try {
                session.getEventListenerManager().cachePutStart();
                this.timestampsRegion.putIntoCache(space, ts, session);
            }
            finally {
                session.getEventListenerManager().cachePutEnd();
            }
            if (!stats) continue;
            factory.getStatistics().updateTimestampsCachePut();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate(String[] spaces, SharedSessionContractImplementor session) {
        boolean stats = session.getFactory().getStatistics().isStatisticsEnabled();
        Long ts = session.getFactory().getCache().getRegionFactory().nextTimestamp();
        for (String space : spaces) {
            if (DEBUG_ENABLED) {
                log.debugf("Invalidating space [%s], timestamp: %s", (Object)space, (Object)ts);
            }
            try {
                session.getEventListenerManager().cachePutStart();
                this.timestampsRegion.putIntoCache(space, ts, session);
            }
            finally {
                session.getEventListenerManager().cachePutEnd();
                if (stats) {
                    session.getFactory().getStatistics().updateTimestampsCachePut();
                }
            }
        }
    }

    @Override
    public boolean isUpToDate(String[] spaces, Long timestamp, SharedSessionContractImplementor session) {
        boolean stats = session.getFactory().getStatistics().isStatisticsEnabled();
        for (String space : spaces) {
            Long lastUpdate = this.getLastUpdateTimestampForSpace((Serializable)((Object)space), session);
            if (lastUpdate == null) {
                if (!stats) continue;
                session.getFactory().getStatistics().updateTimestampsCacheMiss();
                continue;
            }
            if (DEBUG_ENABLED) {
                log.debugf("[%s] last update timestamp: %s", (Object)space, (Object)(lastUpdate + ", result set timestamp: " + timestamp));
            }
            if (stats) {
                session.getFactory().getStatistics().updateTimestampsCacheHit();
            }
            if (lastUpdate < timestamp) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long getLastUpdateTimestampForSpace(Serializable space, SharedSessionContractImplementor session) {
        Long ts = null;
        try {
            session.getEventListenerManager().cacheGetStart();
            ts = (Long)this.timestampsRegion.getFromCache(space, session);
            session.getEventListenerManager().cacheGetEnd(ts != null);
        }
        catch (Throwable throwable) {
            session.getEventListenerManager().cacheGetEnd(ts != null);
            throw throwable;
        }
        return ts;
    }
}

