/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.commons;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.ServiceRegistry;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.FileLookup;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.hibernate.cache.commons.util.InfinispanMessageLogger;
import org.infinispan.hibernate.cache.spi.EmbeddedCacheManagerProvider;
import org.infinispan.hibernate.cache.spi.InfinispanProperties;
import org.infinispan.jboss.marshalling.core.JBossUserMarshaller;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;

public class DefaultCacheManagerProvider
implements EmbeddedCacheManagerProvider {
    private static final InfinispanMessageLogger LOGGER = InfinispanMessageLogger.Provider.getLog(DefaultCacheManagerProvider.class);
    private final ServiceRegistry registry;

    public DefaultCacheManagerProvider(ServiceRegistry registry) {
        this.registry = registry;
    }

    public EmbeddedCacheManager getEmbeddedCacheManager(Properties properties) {
        return new DefaultCacheManager(DefaultCacheManagerProvider.loadConfiguration(this.registry, properties), true);
    }

    public static ConfigurationBuilderHolder loadConfiguration(ServiceRegistry registry, Properties properties) {
        String config = ConfigurationHelper.extractPropertyValue((String)"hibernate.cache.infinispan.cfg", (Properties)properties);
        ConfigurationBuilderHolder holder = DefaultCacheManagerProvider.loadConfiguration(registry, config != null ? config : "org/infinispan/hibernate/cache/commons/builder/infinispan-configs.xml");
        String globalStatsProperty = ConfigurationHelper.extractPropertyValue((String)"hibernate.cache.infinispan.statistics", (Properties)properties);
        if (globalStatsProperty != null) {
            holder.getGlobalConfigurationBuilder().jmx().enabled(Boolean.parseBoolean(globalStatsProperty));
        }
        holder.getGlobalConfigurationBuilder().serialization().marshaller((Marshaller)new JBossUserMarshaller());
        return holder;
    }

    public static ConfigurationBuilderHolder loadConfiguration(ServiceRegistry registry, String config) {
        ClassLoaderService.Work work = classLoader -> {
            ConfigurationBuilderHolder configurationBuilderHolder;
            block8: {
                ClassLoader infinispanClassLoader = InfinispanProperties.class.getClassLoader();
                InputStream input = DefaultCacheManagerProvider.lookupFile(config, classLoader, infinispanClassLoader);
                try {
                    configurationBuilderHolder = DefaultCacheManagerProvider.parse(input, infinispanClassLoader, MediaType.fromExtension((String)config));
                    if (input == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw LOGGER.unableToCreateCacheManager(e);
                    }
                }
                input.close();
            }
            return configurationBuilderHolder;
        };
        return (ConfigurationBuilderHolder)((ClassLoaderService)registry.getService(ClassLoaderService.class)).workWithClassLoader(work);
    }

    private static InputStream lookupFile(String configFile, ClassLoader classLoader, ClassLoader strictClassLoader) throws FileNotFoundException {
        FileLookup fileLookup = FileLookupFactory.newInstance();
        InputStream input = fileLookup.lookupFile(configFile, classLoader);
        if (input == null) {
            input = fileLookup.lookupFileStrict(configFile, strictClassLoader);
        }
        return input;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ConfigurationBuilderHolder parse(InputStream input, ClassLoader classLoader, MediaType mediaType) {
        ParserRegistry parser = new ParserRegistry(classLoader);
        Thread currentThread = Thread.currentThread();
        ClassLoader originalClassLoader = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(classLoader);
            ConfigurationBuilderHolder builderHolder = parser.parse(input, null, mediaType);
            builderHolder.getGlobalConfigurationBuilder().classLoader(classLoader);
            ConfigurationBuilderHolder configurationBuilderHolder = builderHolder;
            return configurationBuilderHolder;
        }
        finally {
            currentThread.setContextClassLoader(originalClassLoader);
        }
    }
}

